/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_webtexterprovider_hpp__
#define __web2sms_webtexterprovider_hpp__

// Local includes
#include "../providerinterface.hpp"

// Forward declarations
class WebTexterProviderPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class WebTexterProvider : public ProviderInterface
{
  Q_OBJECT

public:
  WebTexterProvider(int provider, QObject* parent = 0);
  ~WebTexterProvider();

  void loadSettings(const QByteArray& data);
  QByteArray saveSettings() const;

  bool showAccountSettingsDialog(QWidget* parent);

  void sendMessage(const Message& message);
  
  QList<MessageType> messageTypes() const;

protected:
  WebTexterProviderPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_webtexterprovider_hpp__
