/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "util.hpp"

// Global includes
#include <QtCore/QUrl>
#include <QtCore/QTextCodec>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

// ## Copied from qurl.cpp - why is this not part of the public api??
#define ABNF_sub_delims         "!$&'()*+,;="
#define ABNF_pchar              ABNF_sub_delims ":@"

namespace {
  static const char queryExcludeChars[] = ABNF_pchar "/?";
  static const char alsoEncode[5]       = "=&?/";
}
// ### End copy

PROVIDERS_API QByteArray toUrlPercentEncoding(const QByteArray& data)
{
  return data.toPercentEncoding(queryExcludeChars, alsoEncode);
}

//////////////////////////////////////////////////////////////////////////

PROVIDERS_API QByteArray toLatin1Euro(const QString& input)
{
  // Get the codec
  QTextCodec* codec = QTextCodec::codecForName("ISO 8859-15"); // ISO 8859-15 can handle the euro sign

  // Convert the charset
  QByteArray output = codec->fromUnicode(input);

  // Now we have to turn ISO 8859-15 to ISO 8859-1
  output.replace(char(164), char(128));

  return output;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
