/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "appsettings.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct AppSettings2Private
{
  AppSettings2Private()
  : provider( static_cast<Providers>(0) )
  , use_proxy_script(false)
  , savemsg(false)
  , orientation_enabled(false)
  , emulator(false)
  , extra_logging(false)
  , proxy_url("http://www.cabbagetexter.com/send.php")
  , curl_timeout(30)
  {
  }

  QByteArray userName;
  QByteArray password;
  QByteArray number;
  Providers provider;
  bool use_proxy_script;
  bool savemsg;
  bool orientation_enabled;
  bool emulator;
  bool extra_logging;
  QByteArray proxy_url;
  int curl_timeout;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

AppSettings2::AppSettings2()
: d(new AppSettings2Private)
{
}

//////////////////////////////////////////////////////////////////////////

AppSettings2::AppSettings2(const AppSettings2& cpy)
: d(new AppSettings2Private)
{
  *this = cpy;
}

//////////////////////////////////////////////////////////////////////////

AppSettings2::~AppSettings2()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

AppSettings2& AppSettings2::operator=(const AppSettings2& cpy)
{
  // Copy the internal structure
  *d = *cpy.d;
  return *this;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setUsername(const QByteArray& userName)
{
  d->userName = userName;
}

//////////////////////////////////////////////////////////////////////////

QByteArray AppSettings2::userName() const
{
  return d->userName;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setPassword(const QByteArray& password)
{
  d->password = password;
}

//////////////////////////////////////////////////////////////////////////

QByteArray AppSettings2::password() const
{
  return d->password;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setNumber(const QByteArray& number)
{
  d->number = number;
}

//////////////////////////////////////////////////////////////////////////

QByteArray AppSettings2::number() const
{
  return d->number;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setProvider(Providers provider)
{
  d->provider = provider;
}

//////////////////////////////////////////////////////////////////////////

Providers AppSettings2::provider() const
{
  return d->provider;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setUseProxyScript(bool useProxyScript)
{
  d->use_proxy_script = useProxyScript;
}

//////////////////////////////////////////////////////////////////////////

bool AppSettings2::useProxyScript() const
{
  return d->use_proxy_script;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setSaveMsg(bool saveMsg)
{
  d->savemsg = saveMsg;
}

//////////////////////////////////////////////////////////////////////////

bool AppSettings2::saveMsg() const
{
  return d->savemsg;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setOrientationEnabled(bool orientationEnabled)
{
  d->orientation_enabled = orientationEnabled;
}

//////////////////////////////////////////////////////////////////////////

bool AppSettings2::orientationEnabled() const
{
  return d->orientation_enabled;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setEmulator(bool emulator)
{
  d->emulator = emulator;
}

//////////////////////////////////////////////////////////////////////////

bool AppSettings2::emulator() const
{
  return d->emulator;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setExtraLogging(bool extraLogging)
{
  d->extra_logging = extraLogging;
}

//////////////////////////////////////////////////////////////////////////

bool AppSettings2::extraLogging() const
{
  return d->extra_logging;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setProxyUrl(const QByteArray& proxyUrl)
{
  d->proxy_url = proxyUrl;
}

//////////////////////////////////////////////////////////////////////////

QByteArray AppSettings2::proxyUrl() const
{
  return d->proxy_url;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::setCurlTimeout(int curlTimeout)
{
  d->curl_timeout = curlTimeout;
}

//////////////////////////////////////////////////////////////////////////

int AppSettings2::curlTimeout() const
{
  return d->curl_timeout;
}

//////////////////////////////////////////////////////////////////////////

void AppSettings2::fillAppSettings(AppSettings *settings)
{
  // Fill the settings
  settings->username = d->userName.data();
  settings->password = d->password.data();
  settings->number   = d->number.data();
  settings->provider = d->provider;
  settings->use_proxy_script = d->use_proxy_script;
  settings->savemsg  = d->savemsg;
  settings->orientation_enabled = d->orientation_enabled;
  settings->emulator = d->emulator;
  settings->extra_logging = d->extra_logging;
  settings->proxy_url = d->proxy_url.data();
  settings->curl_timeout = d->curl_timeout;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
