/**
 *  Viito -- an image dictionary for sign language
 *
 *  Copyright (C) 2010  Aki Niemi <aki.niemi@iki.fi>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QVariant>
#include "vdatamodel.h"

VTopicItem::VTopicItem()
    : QStandardItem()
{
}

VTopicItem::VTopicItem(const QString &name, QStandardItemModel *model)
    : QStandardItem(name)
{
    setData(qVariantFromValue((void *)model), ModelRole);
    
    setTextAlignment(Qt::AlignCenter);
    setEditable(false);
}

VImageItem::VImageItem()
    : QStandardItem()
{
}

VImageItem::VImageItem(const QString &name, const QString &author,
		       const QString &path)
    : QStandardItem(name)
{
    setData(author, AuthorRole);
    setData(path, PathRole);

    setTextAlignment(Qt::AlignCenter);
    setEditable(false);
}

