
void VMainWindow::createModels(const QDomDocument &doc)
{
    mTopicModel = new QStandardItemModel(this);
    mImageMap = new QMultiMap<QString, QString>(this);

    QDomNodeList topics = doc.elementsByTagName("topic");

    for (int i = 0; i < topics.count(); i++) {

	QDomNode node = topics.at(i);

	QString name = node.attributes().namedItem("name").nodeValue();
	if (name.isEmpty())
	    continue;

	QDomNodeList images = node.childNodes();

	QStandardItem *topic = new QStandardItem(name);
	topic->setTextAlignment(Qt::AlignCenter);
	topic->setEditable(false);

	QStandardItemModel *imageModel = new QStandardItemModel;
	topic->setData(qVariantFromValue((void *)imageModel),
		       VMainWindow::ModelRole);

	for (int j = 0; j < images.count(); j++) {

	    QDomNamedNodeMap imgattrs = images.at(j).attributes();
	    QStandardItem *image;

	    image = new QStandardItem(imgattrs.namedItem("name").nodeValue());

	    image->setData(imgattrs.namedItem("author").nodeValue(),
			   VMainWindow::AuthorRole);
	    image->setData(imgattrs.namedItem("file").nodeValue(),
			   VMainWindow::PathRole);

	    image->setTextAlignment(Qt::AlignCenter);
	    image->setEditable(false);

	    imageModel->appendRow(image);

	    mImageMap->insert(
	    searchModel->appendRow(image->clone());
	}
	imageModel->sort(0);
	mTopicModel->appendRow(topic);
    }
    mTopicModel->sort(0);

    mSearchModel->setSourceModel(searchModel);
    mSearchModel->setFilterCaseSensitivity(Qt::CaseInsensitive);
    mSearchModel->setSortCaseSensitivity(Qt::CaseInsensitive);
    mSearchModel->sort(0);
}
