/**
 *  Viito -- an image dictionary for sign language
 *
 *  Copyright (C) 2010  Aki Niemi <aki.niemi@iki.fi>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VMAINWINDOW_H
#define VMAINWINDOW_H

#include <QMainWindow>

class QString;
class QModelIndex;
class QListView;
class QDomDocument;
class QLabel;
class QStandardItemModel;
class VImageWidget;

class VMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    VMainWindow();
    VMainWindow(const QString &file);

    enum Roles {
	ModelRole = Qt::UserRole + 1,
	AuthorRole,
	PathRole,
    };

private slots:
    void topicClicked(const QModelIndex &index);
    void imageClicked(const QModelIndex &index);
    void nextImage();
    void previousImage();
    void about();

private:
    void createModels(const QDomDocument &doc);
    void setImage(const QModelIndex &index, int offset=0);

    QListView *mImageView;
    VImageWidget *mImageWidget;
    QStandardItemModel *mDataModel;
};

#endif // VMAINWINDOW_H
