unit txdbus;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, ctypes, dbus, xatom, Dialogs;

const
  // MCE D-Bus service
  MCE_SERVICE =	'com.nokia.mce';
  // MCE D-Bus Request interface
  MCE_REQUEST_IF = 'com.nokia.mce.request';
  // MCE D-Bus Signal interface
  MCE_SIGNAL_IF = 'com.nokia.mce.signal';
  // MCE D-Bus Request path
  MCE_REQUEST_PATH = '/com/nokia/mce/request';
  // MCE D-Bus Signal path
  MCE_SIGNAL_PATH = '/com/nokia/mce/signal';

  {**
   * Notify everyone that the display is on/dimmed/off
   *
   * @since v1.5.21
   * @return @c gchar @c * with the display state
   *         (see @ref mce/mode-names.h for valid display states)
   *}
  MCE_DISPLAY_SIG = 'display_status_ind';

{Show a message dialog using the DBus.. }
procedure ShowDBusMessage(s : string);
procedure ShowDBusMiniMessage(s : string);

{Get the screen status}
//procedure CheckScreenStatus;


implementation

{ Not yet finished, currently junk..
procedure CheckScreenStatus;
var
  err: DBusError;
  conn: PDBusConnection;
  ret: cint;
  msg: PDBusMessage;
  serial: dbus_uint32_t = 0;
begin
  { Initializes the errors }
  dbus_error_init(@err);
  { Connection }
  conn := dbus_bus_get(DBUS_BUS_SYSTEM, @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    WriteLn('Connection Error: ' + err.message);
    dbus_error_free(@err);
  end;
  if conn = nil then
    begin
      ShowMessage('conn is nil :/ ');
      Exit;
    end;

  // create a new method call and check for errors
  msg := dbus_message_new_method_call(MCE_SERVICE, // target for the method call
                                      MCE_SIGNAL_PATH, // object to call on
                                      MCE_SIGNAL_IF, // interface to call on
                                      MCE_DISPLAY_SIG); // method name
  if (msg = nil) then
  begin
    ShowMessage('Message Null');
    Exit;
  end;

  if not boolean(dbus_message_append_args_valist(msg,DBUS_TYPE_VARIANT,@OnScreenChange)) then
    ShowMessage('bollocks :)');


  // send the message and flush the connection
  if (dbus_connection_send(conn, msg, @serial) = 0) then
  begin
    ShowMessage('Out Of Memory!');
    Exit;
  end;
  dbus_connection_flush(conn);



end;    }

{
dBusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                   MCE_REQUEST_IF, dBusConnection, this);

dBusConnection.connect(MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
                       MCE_DISPLAY_SIG, this, SLOT(displayStateChanged(const QDBusMessage &)));

dBusInterface->callWithCallback(MCE_DISPLAY_STATUS_GET, QList<QVariant>(), this,
                                  SLOT(setDisplayState(QString)),
                                  SLOT(displayStateError(QDBusError)));
}

procedure ShowDBusMiniMessage(s : string);
var
  err: DBusError;
  conn: PDBusConnection;
  ret: cint;
  msg: PDBusMessage;
  serial: dbus_uint32_t = 0;
begin
  { Initializes the errors }
  dbus_error_init(@err);
  { Connection }
  conn := dbus_bus_get(DBUS_BUS_SYSTEM, @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    WriteLn('Connection Error: ' + err.message);
    dbus_error_free(@err);
  end;
  if conn = nil then
    begin
      ShowMessage('conn is nil :/ ');
      Exit;
    end;
  { Request the name of the bus }
  ret := dbus_bus_name_has_owner(conn, 'org.freedesktop.Notifications', @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    ShowMessage('Name Error: ' + err.message);
    dbus_error_free(@err);
  end;
  // create a new method call and check for errors
  msg := dbus_message_new_method_call('org.freedesktop.Notifications', // target for the method call
                                      '/org/freedesktop/Notifications', // object to call on
                                      'org.freedesktop.Notifications', // interface to call on
                                      'SystemNoteInfoprint'); // method name
  if (msg = nil) then
  begin
    ShowMessage('Message Null');
    Exit;
  end;
  if not boolean(dbus_message_append_args(msg,DBUS_TYPE_STRING, [@s, DBUS_TYPE_INVALID])) then
   Exit;
  // send the message and flush the connection
  if (dbus_connection_send(conn, msg, @serial) = 0) then
  begin
    ShowMessage('Out Of Memory!');
    Exit;
  end;
  dbus_connection_flush(conn);
  // free the message and close the connection
  dbus_message_unref(msg);
  dbus_connection_unref(conn);
end;

procedure ShowDBusMessage(s : string);
var
  err: DBusError;
  conn: PDBusConnection;
  ret: cint;
  msg: PDBusMessage;
  serial: dbus_uint32_t = 0;
  mType : cardinal;
  mBtnText : string;
begin
  { Initializes the errors }
  dbus_error_init(@err);
  { Connection }
  conn := dbus_bus_get(DBUS_BUS_SYSTEM, @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    WriteLn('Connection Error: ' + err.message);
    dbus_error_free(@err);
  end;
  if conn = nil then
    begin
      ShowMessage('conn is nil :/ ');
      Exit;
    end;
  { Request the name of the bus }
  ret := dbus_bus_name_has_owner(conn, 'org.freedesktop.Notifications', @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    ShowMessage('Name Error: ' + err.message);
    dbus_error_free(@err);
  end;
  // create a new method call and check for errors
  msg := dbus_message_new_method_call('org.freedesktop.Notifications', // target for the method call
                                      '/org/freedesktop/Notifications', // object to call on
                                      'org.freedesktop.Notifications', // interface to call on
                                      'SystemNoteDialog'); // method name
  if (msg = nil) then
  begin
    ShowMessage('Message Null');
    Exit;
  end;
  mType := 0;
  mBtnText := 'NAO OK!';
  if not boolean(dbus_message_append_args(msg,DBUS_TYPE_STRING, [@s,DBUS_TYPE_UINT32,@mType,DBUS_TYPE_STRING,@mBtnText,DBUS_TYPE_INVALID])) then
   Exit;
  // send the message and flush the connection
  if (dbus_connection_send(conn, msg, @serial) = 0) then
  begin
    ShowMessage('Out Of Memory!');
    Exit;
  end;
  dbus_connection_flush(conn);
  // free the message and close the connection
  dbus_message_unref(msg);
  dbus_connection_unref(conn);
end;

end.

