unit settingsunit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, ComCtrls, ColorBox, Grids, SynCompletion, SynEdit, SynExportHTML,
  qtwidgets, TxKinScroller, qt4;

type

  { TSettingsF }

  TSettingsF = class(TForm)
    Button4: TButton;
    Button5: TButton;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    ColorDialog1: TColorDialog;
    Edit1: TEdit;
    Edit2: TEdit;
    GroupBox4: TGroupBox;
    GutterTextBox: TColorBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ListBox1: TListBox;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TextBox: TColorBox;
    GutterBox: TColorBox;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    BackgroundBox: TColorBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PageControl1: TPageControl;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    CodeFolderBox: TColorBox;
    procedure BackgroundBoxChange(Sender: TObject);
    procedure BackgroundBoxCloseUp(Sender: TObject);
    procedure BackgroundBoxDropDown(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure sgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure sgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure sgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  SettingsF: TSettingsF;

implementation

{$R *.lfm}

{ TSettingsF }


{ TSettingsF }

procedure TSettingsF.FormCreate(Sender: TObject);
var
  edt : TQtLineEdit;
begin

  edt := TQtLineEdit(Edit1.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhPreferNumbers or QtImhDigitsOnly);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';
  edt := TQtLineEdit(Edit2.Handle);
  QWidget_setInputMethodHints(edt.Widget,QtImhNoAutoUppercase);
  edt.StyleSheet:= ' QLineEdit { border: 1px solid gray; ' +
                               ' border-radius: 0px; ' +
                               ' padding: 0 0px; ' +
                               ' background-color : white }';

  TQtTabWidget(PageControl1.Handle).TabBar.StyleSheet := 'QTabBar::tab { height: 50px; } ';
  TQtGroupBox(GroupBox1.Handle).StyleSheet := ' QGroupBox::title { subcontrol-position: top center; }';  // position at the top center
  TQtGroupBox(GroupBox2.Handle).StyleSheet := ' QGroupBox::title { subcontrol-position: top center; }';  // position at the top center
  TQtGroupBox(GroupBox3.Handle).StyleSheet := ' QGroupBox::title { subcontrol-position: top center; }';  // position at the top center
end;

procedure TSettingsF.FormDestroy(Sender: TObject);
begin
end;

procedure TSettingsF.FormShow(Sender: TObject);
begin
  TQtTabWidget(PageControl1.Handle).TabBar.StyleSheet := 'QTabBar::tab { height: 50px; } ';
  TQtGroupBox(GroupBox1.Handle).StyleSheet := ' QGroupBox::title { subcontrol-position: top center; }';  // position at the top center
  TQtGroupBox(GroupBox2.Handle).StyleSheet := ' QGroupBox::title { subcontrol-position: top center; }';  // position at the top center
  TQtGroupBox(GroupBox3.Handle).StyleSheet := ' QGroupBox::title { subcontrol-position: top center; }';  // position at the top center
end;

procedure TSettingsF.sgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
end;

procedure TSettingsF.sgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
end;

procedure TSettingsF.sgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
end;

procedure TSettingsF.BackgroundBoxChange(Sender: TObject);
begin
  with Sender as TColorBox do
    Color := Selected;
end;

procedure TSettingsF.BackgroundBoxCloseUp(Sender: TObject);
begin
  with Sender as TColorBox do
    Color := Selected;
end;

procedure TSettingsF.BackgroundBoxDropDown(Sender: TObject);
begin
  with Sender as TColorBox do
    Color := clBlack;
end;

procedure TSettingsF.Button3Click(Sender: TObject);
begin
end;

procedure TSettingsF.Button4Click(Sender: TObject);
begin
  if length(Edit2.Text) > 0 then
    begin
      ListBox1.Items.Add(Edit2.Text);
      Edit2.Clear;
    end;
end;

procedure TSettingsF.Button5Click(Sender: TObject);
begin
  if ListBox1.ItemIndex > 0 then
    ListBox1.Items.Delete(ListBox1.ItemIndex);
end;

end.

