unit FontDlg;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, qt4, qtwidgets, qtobjects;

type

  { TFontDlgF }

  TFontDlgF = class(TForm)
    Button1: TButton;
    Button2: TButton;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox1SelectionChange(Sender: TObject; User: boolean);
  private
    { private declarations }
  public
    { public declarations }
    FontSize : integer;
    FontName : string;
    FontPitch : TFontPitch;
    procedure PopulateFamilies(font_db : QFontDatabaseH; default : string);
    procedure PopulateSizes(font_db : QFontDatabaseH; family : WideString; default : string);
  end;

var
  FontDlgF: TFontDlgF;
  font_db : QFontDatabaseH;

implementation

{$R *.lfm}

{ TFontDlgF }

procedure TFontDlgF.PopulateFamilies(font_db : QFontDatabaseH; default : string);
var
  families : TQtStringList;
  i, index : integer;
begin
  families := TQtStringList.Create;
  QFontDatabase_families(font_db,families.Handle);
  ListBox1.Clear;
  index := -1;
  for i := 0 to families.Count-1 do
    begin
      ListBox1.Items.Add(families[i]);
      if families[i] = default then
        index := i;
    end;
  if index > -1 then
    ListBox1.ItemIndex:=index
  else
    ListBox1.ItemIndex:=ListBox1.Items.IndexOf('NewCourier');
  families.Free;
end;

procedure TFontDlgF.PopulateSizes(font_db : QFontDatabaseH; family : WideString; default : string);
var
  pointSizes : array of PtrInt;
  i, index : integer;
begin
  QFontDatabase_pointSizes(font_db,@pointSizes,@family);
  ComboBox1.Clear;
  for i := low(pointsizes) to high(pointSizes) do
    begin
      ComboBox1.Items.Add(inttostr(pointSizes[i]));
    end;
  if ComboBox1.Items.Count < 1 then
    ComboBox1.Text := '16';
  if default <> '' then
    begin
      index := ComboBox1.Items.IndexOf(default);
      if index > -1 then
        ComboBox1.ItemIndex := index
      else
        ComboBox1.ItemIndex := ComboBox1.Items.IndexOf('16');
    end;
end;

procedure TFontDlgF.FormCreate(Sender: TObject);
begin

end;

procedure TFontDlgF.Button1Click(Sender: TObject);
var
  size : integer;
  s1, s2 : string;
begin
  s1 := ListBox1.Items[ListBox1.ItemIndex];
  s2 := 'Normal';
  if not TryStrToInt(ComboBox1.Text,size) then
    size := 16;
  if QFontDatabase_isFixedPitch(font_db,@s1,@s2) then
    FontPitch := fpFixed
  else
    FontPitch := fpVariable;
end;

procedure TFontDlgF.ComboBox1Change(Sender: TObject);
begin
  FontSize := StrToInt(ComboBox1.Text);
  Edit1.Font.Size := FontSize;
  Edit1.Font.Name:= FontName;
end;

procedure TFontDlgF.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  QFontDatabase_destroy(font_db);
end;

procedure TFontDlgF.FormShow(Sender: TObject);
begin
  font_db := QFontDatabase_create();
  PopulateFamilies(font_db, FontName);
  PopulateSizes(font_db, ListBox1.Items[ListBox1.ItemIndex] , IntTostr(FontSize));
  Edit1.Font.Size := FontSize;
  Edit1.Font.Name:= FontName;
end;

procedure TFontDlgF.ListBox1Click(Sender: TObject);
begin

end;

procedure TFontDlgF.ListBox1SelectionChange(Sender: TObject; User: boolean);
var
  oldsize : string;
begin
  oldsize := ComboBox1.Text;
  PopulateSizes(font_db,ListBox1.Items[ListBox1.ItemIndex],oldsize);
  FontName:= ListBox1.Items[ListBox1.ItemIndex];
  Edit1.Font.Size := FontSize;
  Edit1.Font.Name:= FontName;
end;

end.

