{
    This file is part of TxPad.

    TxPad is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TxPad is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TxPad.  If not, see <http://www.gnu.org/licenses/>
}

{
Linking : -L/home/trx/lazarus/fpc/libcross

After : arm-linux-strip -s /home/trx/n900/new/TxPad/txpad
}



unit MainUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Menus, ComCtrls, Buttons, ActnList, LResources, SynEdit,
  SynHighlighterAny, SynHighlighterPHP, SynHighlighterPas, SynHighlighterCpp,
  SynHighlighterJava, SynHighlighterPerl, SynHighlighterHTML, SynHighlighterXML,
  SynHighlighterLFM, SynHighlighterDiff, synhighlighterunixshellscript,
  SynHighlighterCss, SynHighlighterTeX, SynHighlighterSQL, SynHighlighterPython,
  SynHighlighterVB, SynEditHighlighter, SynEditKeyCmds,
  IdHTTP, IdGlobal, IdGlobalProtocols, SynEditTypes, dbus, conic,
  IniFiles, txqtfunc, qtwidgets,qtproc, ctypes, qt4, Lmessages, types, LCLType;


type
  TxZoomKeys = (zkChangeTabs, zkChangeFont, zkDontUse);

  TxSettings = record
    UseRegExpr : boolean;
    WholeWords : boolean;
    CaseSensitive : boolean;
    AppOrientation : TAppOrientation;
    ZoomKeys : TxZoomKeys;
    ShowTabBar : boolean;
  end;

  TxDocument = record
    Page : TTabSheet;
    Edit : TSynEdit;
    FileName : string;
    Modified : boolean;
    Active : boolean;
  end;
  // Shift = 16 , Fn = 227 , Ctrl = 17
  TxShiftState = (xssNone, xssOne, xssTwo);
  TxAltGrState = (xasNone, xasOne, xasTwo);
  { TMainForm }

  TMainForm = class(TForm)
    ActionZoomMinus: TAction;
    ActionZoomPlus: TAction;
    ActionFullScreen: TAction;
    ActionSearch: TAction;
    ActionSearchReplace: TAction;
    ActionCloseTab: TAction;
    ActionSaveAs: TAction;
    ActionSave: TAction;
    ActionOpen: TAction;
    ActionNew: TAction;
    ActionList1: TActionList;
    Button1: TButton;
    FullscreenButton: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    BookmarkButton: TButton;
    BMImgList: TImageList;
    kinTimer: TTimer;
    MenuItem1: TMenuItem;
    BMToggle1: TMenuItem;
    BMToggle2: TMenuItem;
    BMToggle3: TMenuItem;
    BMToggle4: TMenuItem;
    BMToggle5: TMenuItem;
    BMToggle6: TMenuItem;
    BMGoto4: TMenuItem;
    MenuItem2: TMenuItem;
    BMGoto5: TMenuItem;
    BMGoto6: TMenuItem;
    BMGoto1: TMenuItem;
    BMGoto2: TMenuItem;
    BMGoto3: TMenuItem;
    PageLeftButton: TButton;
    Label2: TLabel;
    Label3: TLabel;
    ExitItem: TMenuItem;
    MenuItem29: TMenuItem;
    MenuItem35: TMenuItem;
    MenuItem36: TMenuItem;
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    FileMenuItem: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem13: TMenuItem;
    MenuItem14: TMenuItem;
    MenuItem15: TMenuItem;
    MenuItem16: TMenuItem;
    MenuItem17: TMenuItem;
    MenuItem18: TMenuItem;
    MenuItem19: TMenuItem;
    PageLabelButton: TButton;
    PageUpFullButton: TButton;
    PageRightButton: TButton;
    PageCloseButton: TButton;
    PageUpButton: TButton;
    PageDownButton: TButton;
    PageDownFullButton: TButton;
    BookmarkMenu: TPopupMenu;
    ProximityTimer: TTimer;
    ProxTimeoutTimer: TTimer;
    StartupTimer: TTimer;
    ViewMenuItem: TMenuItem;
    MenuItem20: TMenuItem;
    MenuItem21: TMenuItem;
    MenuItem22: TMenuItem;
    MenuItem23: TMenuItem;
    MenuItem24: TMenuItem;
    MenuItem25: TMenuItem;
    MenuItem26: TMenuItem;
    MenuItem27: TMenuItem;
    MenuItem28: TMenuItem;
    MenuItem3: TMenuItem;
    ToolsMenuItem: TMenuItem;
    MenuItem31: TMenuItem;
    MenuItem33: TMenuItem;
    MenuItem37: TMenuItem;
    MenuItem38: TMenuItem;
    MenuItem39: TMenuItem;
    HighlightMenuItem: TMenuItem;
    MenuItem40: TMenuItem;
    MenuItem42: TMenuItem;
    MenuItem43: TMenuItem;
    AboutItem: TMenuItem;
    MenuItem5: TMenuItem;
    EditMenuItem: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    Panel1: TPanel;
    ReplacePanel: TPanel;
    SearchEdit: TEdit;
    ReplaceEdit: TEdit;
    pg: TPageControl;
    SearchEdit2: TEdit;
    SearchPanel: TPanel;
    SearchPanel1: TPanel;
    SynCppSyn1: TSynCppSyn;
    SynCssSyn1: TSynCssSyn;
    SynFreePascalSyn1: TSynFreePascalSyn;
    SynHTMLSyn1: TSynHTMLSyn;
    SynJavaSyn1: TSynJavaSyn;
    SynLFMSyn1: TSynLFMSyn;
    SynPasSyn1: TSynPasSyn;
    SynPerlSyn1: TSynPerlSyn;
    SynPHPSyn1: TSynPHPSyn;
    SynPythonSyn1: TSynPythonSyn;
    SynSQLSyn1: TSynSQLSyn;
    SynTeXSyn1: TSynTeXSyn;
    SynUNIXShellScriptSyn1: TSynUNIXShellScriptSyn;
    SynVBSyn1: TSynVBSyn;
    SynXMLSyn1: TSynXMLSyn;
    FocusTimer: TTimer;
    ShortCutDelayTimer: TTimer;
    procedure ActionNewExecute(Sender: TObject);
    procedure BMGoto1Click(Sender: TObject);
    procedure BMToggle1Click(Sender: TObject);
    procedure BookmarkButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure ExitItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure FormUTF8KeyPress(Sender: TObject; var UTF8Key: TUTF8Char);
    procedure FullscreenButtonClick(Sender: TObject);
    procedure kineticTimerTimer(Sender: TObject);
    procedure MenuItem10Click(Sender: TObject);
    procedure MenuItem12Click(Sender: TObject);
    procedure MenuItem13Click(Sender: TObject);
    procedure MenuItem14Click(Sender: TObject);
    procedure MenuItem15Click(Sender: TObject);
    procedure MenuItem16Click(Sender: TObject);
    procedure MenuItem17Click(Sender: TObject);
    procedure MenuItem18Click(Sender: TObject);
    procedure MenuItem19Click(Sender: TObject);
    procedure MenuItem20Click(Sender: TObject);
    procedure MenuItem21Click(Sender: TObject);
    procedure MenuItem22Click(Sender: TObject);
    procedure MenuItem23Click(Sender: TObject);
    procedure MenuItem24Click(Sender: TObject);
    procedure MenuItem25Click(Sender: TObject);
    procedure MenuItem26Click(Sender: TObject);
    procedure MenuItem27Click(Sender: TObject);
    procedure MenuItem28Click(Sender: TObject);
    procedure MenuItem31Click(Sender: TObject);
    procedure MenuItem33Click(Sender: TObject);
    procedure MenuItem35Click(Sender: TObject);
    procedure MenuItem36Click(Sender: TObject);
    procedure MenuItem37Click(Sender: TObject);
    procedure MenuItem39Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem42Click(Sender: TObject);
    procedure AboutItemClick(Sender: TObject);
    procedure MenuItem5Click(Sender: TObject);
    procedure MenuItem8Click(Sender: TObject);
    procedure MenuItem9Click(Sender: TObject);
    procedure PageCloseButtonClick(Sender: TObject);
    procedure PageDownButtonClick(Sender: TObject);
    procedure PageDownFullButtonClick(Sender: TObject);
    procedure PageLeftButtonClick(Sender: TObject);
    procedure PageRightButtonClick(Sender: TObject);
    procedure PageUpButtonClick(Sender: TObject);
    procedure PageUpFullButtonClick(Sender: TObject);
    procedure pgCloseTabClicked(Sender: TObject);
    procedure GenSynEditChange(Sender: TObject);
    procedure pgPageChanged(Sender: TObject);
    procedure ProximityTimerTimer(Sender: TObject);
    procedure ProxTimeoutTimerTimer(Sender: TObject);
    procedure SearchEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StartupTimerTimer(Sender: TObject);
    procedure GenSynEditReplaceText(Sender: TObject; const ASearch,
      AReplace: string; Line, Column: integer;
      var ReplaceAction: TSynReplaceAction);
    procedure SynEditDummyMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SynEditDummyMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SynEditDummyMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SynEditDummyKeyPress(Sender: TObject; var Key: char);
    procedure FocusTimerTimer(Sender: TObject);
    procedure ShortCutDelayTimerTimer(Sender: TObject);
    procedure kinTimerTimer(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    TagCount : integer; // Unique tag id counter
    Settings : TxSettings;
    Docs : array of TxDocument;
    Fullscreen : boolean;
    AutoOrientation : boolean;
    PortraitMode : boolean;
    XShift : TxShiftState;
    XAltGr : TxAltGrState;
    SearchReplace : boolean;
    PromptingReplace : boolean;
    procedure NewDoc(fname : string);
    procedure CloseDoc(id : integer);
    procedure SaveDoc(id : integer; SaveAs : boolean = false);
    procedure ApplyHighlight(id : integer; hl :TSynCustomHighlighter);
    procedure ApplyHighlightByExt(id : integer);
    procedure ApplyHighlightToMenu(h : TSynCustomHighlighter);
    procedure LoadSettings(fname : string);
    procedure SaveSettings(fname : string);
    function GetDocIDByTag(t : integer):integer;
  public //Menu stuff..
    mb : QMenuBarH;
    mh : QMenuH;
    hook_mh : QMenu_hookH;
    actFile, actEdit, actView, actTools, actAbout, actExit : QActionH;
    short_executed : boolean;
    LastAction : TAction;
    procedure MenuHookTrigered(act : QActionH); cdecl;
    procedure CreateMenuBar;
  public //Misc stuff..
    iconFullscreenH, iconPageLeftH, iconPageRightH, iconPageCloseH,
    iconPageUpH, iconPageUpFullH, iconPageDownH, iconPageDownFullH : QIconH;
    ProxSession : boolean;
    MediaBarTimeout : integer;
    procedure MediaBarProx(use : boolean);
  public
    kinMouseDownPoint : TPoint;
    kinMouseCurrentPoint : TPoint;
    kinMouseDownPointInertia : TPoint;
    kinMouseCurrentPointInertia : TPoint;
    kinOriginalScrollBarValue : TPoint;
    kinCurrentScrollBarValue : TPoint;
    kinMouseIsDown : boolean;
    kinMouseIsMoving : boolean;
    kinInertiaActive : boolean;
    kinInertiaY, kinInertiaX : integer;
    procedure kinStopInertia;
  end;


const
  CURRENT_VER : string = 'v0.5.1';
  CONFIG_FILE : string = '/home/user/.config/TxPad/txpad.conf';

var
  MainForm: TMainForm;
  zz : boolean;
  mx,my : integer;
  kk : boolean;
  temp_k : word;
  first : boolean;
  sY, sX : integer;



procedure prox(use : boolean);
function isProxClosed():boolean;

implementation

uses CharDialog, OpenDlg, SaveDlg, PasteBin, SettingsUnit, AboutBox, txdbus, FontDlg, TestDiag, GenMenu;

{$R *.lfm}

const
  kinIgnoreRadius : integer = 20;
  kinTimerInterval : integer = 50;
  kinFriction : integer = 1;

procedure TMainForm.MediaBarProx(use : boolean);
const
  iniFileName : string = '/home/user/.config/MohammadAG/mediabar.conf';
var
  iniFile : TMemIniFile;
begin
  if not FileExists(iniFileName) then
    Exit;
  iniFile := TMemIniFile.Create(iniFileName);
  if use then
    begin // Enable it..
      iniFile.WriteInteger('main','timeout',MediaBarTimeOut);
    end
  else
    begin // Disable it..
      MediaBarTimeOut := iniFile.ReadInteger('main','timeout',1200);
      if MediaBarTimeOut = 9999999 then
        MediaBarTimeOut := 1200;
      iniFile.WriteInteger('main','timeout',9999999);
    end;
  iniFile.UpdateFile;
  iniFile.Free;
end;

procedure TMainForm.MenuHookTrigered(act : QActionH); cdecl;
var
  i, res : integer;
begin
  if act = actFile then
    begin
      GenMenuF.ListBox1.Clear;
      for i := 0 to FileMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(FileMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          for i := 0 to FileMenuItem.Count - 1 do
            begin
              if FileMenuItem.Items[i].Caption = GenMenuF.MRes then
                FileMenuItem.Items[i].OnClick(Self);
            end;
        end;
    end;
  if act = actEdit then
    begin
      GenMenuF.ListBox1.Clear;
      for i := 0 to EditMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(EditMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          for i := 0 to EditMenuItem.Count - 1 do
            begin
              if EditMenuItem.Items[i].Caption = GenMenuF.MRes then
                EditMenuItem.Items[i].OnClick(Self);
            end;
        end;
    end;
  if act = actView then
    begin
      GenMenuF.ListBox1.Clear;
      for i := 0 to ViewMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(ViewMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          if GenMenuF.MRes = 'Highlight Code' then
            begin
              GenMenuF.MRes := '';
              GenMenuF.ListBox1.Clear;
              for i := 0 to HighlightMenuItem.Count - 1 do
                begin
                  GenMenuF.ListBox1.Items.Add(HighlightMenuItem.Items[i].Caption);
                end;
              res := GenMenuF.ShowModal;
              if (GenMenuF.MRes <> '') and (res = mrOk) then
                for i := 0 to HighlightMenuItem.Count - 1 do
                  begin
                    if HighlightMenuItem.Items[i].Caption = GenMenuF.MRes then
                      HighlightMenuItem.Items[i].OnClick(Self);
                  end;
            end
          else
            begin
              for i := 0 to ViewMenuItem.Count - 1 do
                 begin
                   if ViewMenuItem.Items[i].Caption = GenMenuF.MRes then
                     ViewMenuItem.Items[i].OnClick(Self);
                 end;
            end;
        end;
    end;
  if act = actTools then
    begin
      GenMenuF.ListBox1.Clear;
      for i := 0 to ToolsMenuItem.Count - 1 do
        begin
          GenMenuF.ListBox1.Items.Add(ToolsMenuItem.Items[i].Caption);
        end;
      GenMenuF.MRes := '';
      res := GenMenuF.ShowModal;
      if (GenMenuF.MRes <> '') and (res = mrOk) then
        begin
          for i := 0 to ToolsMenuItem.Count - 1 do
            begin
              if ToolsMenuItem.Items[i].Caption = GenMenuF.MRes then
                ToolsMenuItem.Items[i].OnClick(Self);
            end;
        end;
    end;
  if act = actAbout then
    begin
      AboutItem.OnClick(Self);
    end;
  if act = actExit then
    begin
      ExitItem.OnClick(Self);
    end;
end;

procedure TMainForm.CreateMenuBar;
var
  s, mh_name : WideString;
  ma : QActionH;
begin
  short_executed := False;
  mb := QMenuBar_Create(TQtMainWindow(MainForm.Handle).Widget);
  TQtMainWindow(MainForm.Handle).setMenuBar(mb);
  mh_name := 'menu';
  mh := QMenu_Create(@mh_name, QMenuBarH(TQtMainWindow(MainForm.Handle).MenuBar.Widget));
  QMenu_setTitle(mh,@mh_name);
  ma := TQtMainWindow(MainForm.Handle).MenuBar.addMenu(mh);
  s := 'File';
  actFile := QMenu_addAction(mh, @s);
  s := 'Edit';
  actEdit := QMenu_addAction(mh, @s);
  s := 'View';
  actView := QMenu_addAction(mh, @s);
  s := 'Tools';
  actTools := QMenu_addAction(mh, @s);
  s := 'About';
  actAbout := QMenu_addAction(mh, @s);
  s := 'Exit';
  actExit := QMenu_addAction(mh, @s);

  hook_mh := QMenu_hook_create(QObjectH(mh));
  QMenu_hook_hook_triggered(hook_mh,@MenuHookTrigered);
end;

function TMainForm.GetDocIDByTag(t : integer):integer;
var
  i : integer;
begin
  Result := -1;
  for i := 0 to length(Docs)-1 do
    begin
      if Docs[i].Page.Tag = t then
        begin
          Result := i;
          Break;
        end;
    end;
end;

function isProxClosed():boolean;
var
  sl : TStringList;
begin
  sl := TStringList.Create();
  if FileExists('/sys/devices/platform/gpio-switch/proximity/state') then
    sl.LoadFromFile('/sys/devices/platform/gpio-switch/proximity/state')
  else
    begin
      ShowMessage('File doesnt exist!');
      sl.Free;
      Exit;
    end;
  if sl.Count > 0 then
    begin
      if sl[0] = 'closed' then
        Result := True
      else
        Result := False;
    end
  else
    ShowMessage('sl.Count := 0');
  sl.Free;
end;

procedure prox(use : boolean);
var
  err: DBusError;
  conn: PDBusConnection;
  ret: cint;
  msg: PDBusMessage;
  serial: dbus_uint32_t = 0;
  state : string;
begin
  { Initializes the errors }
  dbus_error_init(@err);
  { Connection }
  conn := dbus_bus_get(DBUS_BUS_SYSTEM, @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    WriteLn('Connection Error: ' + err.message);
    dbus_error_free(@err);
  end;
  if conn = nil then
    begin
      ShowMessage('conn is nil :/ ');
      Exit;
    end;
  { Request the name of the bus }
  ret := dbus_bus_name_has_owner(conn, 'proximityd.method.change', @err);
  if dbus_error_is_set(@err) <> 0 then
  begin
    ShowMessage('Name Error: ' + err.message);
    dbus_error_free(@err);
  end;
  {
  system(QString("dbus-send --dest=proximityd.method.change --type=method_call --print-reply /proximityd/method/change proximityd.method.change.Change string:turnOn int32:%2").arg(QCoreApplication::applicationPid()).toUtf8().constData());
  }

  // create a new method call and check for errors
  msg := dbus_message_new_method_call('proximityd.method.change', // target for the method call
                                      '/proximityd/method/change', // object to call on
                                      'proximityd.method.change', // interface to call on
                                      'Change'); // method name
  if (msg = nil) then
  begin
    ShowMessage('Message Null');
    Exit;
  end;

  if use then
    state := 'turnOn'
  else
    state := 'turnOff';

  if not boolean(dbus_message_append_args(msg,DBUS_TYPE_STRING, [@state, DBUS_TYPE_INVALID])) then
   Exit;
  // send the message and flush the connection
  if (dbus_connection_send(conn, msg, @serial) = 0) then
  begin
    ShowMessage('Out Of Memory!');
    Exit;
  end;
  dbus_connection_flush(conn);
  // free the message and close the connection
  dbus_message_unref(msg);
  dbus_connection_unref(conn);
end;

procedure TMainForm.LoadSettings(fname : string);
var
  ini : TMemIniFile;
  orient : string;
  zoom : string;
begin
  if not FileExists(fname) then
    begin // First run :)
      if not CreateDir('/home/user/.config/TxPad') then
        begin
          ShowMessage('Cant create config file!');
          Exit;
        end;
      ShowDBusMessage('Welcome to TxPad '+CURRENT_VER);
    end;
  ini := TMemIniFile.Create(fname);
  Settings.ShowTabBar := ini.ReadBool('Misc','ShowTabBar',False);
  Settings.UseRegExpr := ini.ReadBool('Search','UseRegExpr',False);
  Settings.WholeWords := ini.ReadBool('Search','WholeWords',False);
  Settings.CaseSensitive := ini.ReadBool('Search','CaseSensitive',False);
  zoom := ini.ReadString('Misc','ZoomKeys','zkChangeTabs');
  if zoom = 'zkChangeTabs' then
    Settings.ZoomKeys := zkChangeTabs;
  if zoom = 'zkChangeFont' then
    Settings.ZoomKeys := zkChangeFont;
  if zoom = 'zkChangeTabs' then
    Settings.ZoomKeys := zkDontUse;
  orient := ini.ReadString('Layout','AppOrientation','aoAuto');
  if orient = 'aoHorizontal' then
    Settings.AppOrientation := aoHorizontal;
  if orient = 'aoVertical' then
    Settings.AppOrientation := aoVertical;
  if orient = 'aoAuto' then
    Settings.AppOrientation := aoAuto;
  // Apply settings
  RotateApp(MainForm.Handle,Settings.AppOrientation);
  case Settings.ZoomKeys of
    zkChangeTabs, zkChangeFont : UseZoomKeys(MainForm.Handle, True);
  end;
  if Settings.ShowTabBar then
    begin
      pg.ShowTabs := True;
 //     ProximityTimer.Enabled := False;
    end
  else
    begin
      pg.ShowTabs := False;
 //     ProximityTimer.Enabled := True;
    end;
  ini.UpdateFile;
  ini.Free;
end;

procedure TMainForm.SaveSettings(fname : string);
var
  ini : TMemIniFile;
begin
  // Apply the settings to SettingsF first
  SettingsF.CheckBox1.Checked := Settings.UseRegExpr;
  SettingsF.CheckBox2.Checked := Settings.WholeWords;
  SettingsF.CheckBox3.Checked := Settings.CaseSensitive;
  SettingsF.CheckBox4.Checked := Settings.ShowTabBar;
  case Settings.AppOrientation of
    aoHorizontal:SettingsF.RadioButton1.Checked := True;
    aoVertical:SettingsF.RadioButton2.Checked := True;
    aoAuto:SettingsF.RadioButton3.Checked := True;
  end;
  case Settings.ZoomKeys of
    zkChangeTabs : SettingsF.RadioButton4.Checked := True;
    zkChangeFont : SettingsF.RadioButton5.Checked := True;
    zkDontUse : SettingsF.RadioButton6.Checked := True;
  end;


  // Check result
  if SettingsF.ShowModal <> mrOK then
    Exit;
  // Apply settings
  Settings.UseRegExpr := SettingsF.CheckBox1.Checked;
  Settings.WholeWords := SettingsF.CheckBox2.Checked;
  Settings.CaseSensitive := SettingsF.CheckBox3.Checked;
  Settings.ShowTabBar := SettingsF.CheckBox4.Checked;
  if Settings.ShowTabBar then
    begin
      pg.ShowTabs := True;
//      ProximityTimer.Enabled := False;
    end
  else
    begin
      pg.ShowTabs := False;
//      ProximityTimer.Enabled := True;
    end;

  if SettingsF.RadioButton1.Checked then
    Settings.AppOrientation := aoHorizontal;
  if SettingsF.RadioButton2.Checked then
    Settings.AppOrientation := aoVertical;
  if SettingsF.RadioButton3.Checked then
    Settings.AppOrientation := aoAuto;

  if SettingsF.RadioButton4.Checked then
    begin
      Settings.ZoomKeys := zkChangeTabs;
      UseZoomKeys(MainForm.Handle, True);
    end;
  if SettingsF.RadioButton5.Checked then
    begin
      Settings.ZoomKeys := zkChangeFont;
      UseZoomKeys(MainForm.Handle, True);
    end;
  if SettingsF.RadioButton6.Checked then
    begin
      Settings.ZoomKeys := zkDontUse;
      UseZoomKeys(MainForm.Handle, False);
    end;
  RotateApp(MainForm.Handle,Settings.AppOrientation);
  // Save to ini
  ini := TMemIniFile.Create(fname);
  ini.WriteBool('Search','UseRegExpr',SettingsF.CheckBox1.Checked);
  ini.WriteBool('Search','WholeWords',SettingsF.CheckBox2.Checked);
  ini.WriteBool('Search','CaseSensitive',SettingsF.CheckBox3.Checked);
  ini.WriteBool('Misc','ShowTabBar',SettingsF.CheckBox4.Checked);
  case Settings.AppOrientation of
    aoHorizontal:ini.WriteString('Layout','AppOrientation','aoHorizontal');
    aoVertical:ini.WriteString('Layout','AppOrientation','aoVertical');
    aoAuto:ini.WriteString('Layout','AppOrientation','aoAuto');
  end;
  case Settings.ZoomKeys of
    zkChangeTabs : ini.WriteString('Misc','ZoomKeys','zkChangeTabs');
    zkChangeFont : ini.WriteString('Misc','ZoomKeys','zkChangeFont');
    zkDontUse : ini.WriteString('Misc','ZoomKeys','zkDontUse');
  end;
  ini.UpdateFile;
  ini.Free;
end;

{ TMainForm }
procedure TMainForm.ApplyHighlightToMenu(h : TSynCustomHighlighter);
begin
{  if h = nil then
    begin
      MenuItem5.Checked := True;
      Exit;
    end;
  if h.name = 'SynPasSyn1' then
    MenuItem14.Checked := True;
  if h.name = 'SynFreePascalSyn1' then
    MenuItem15.Checked := True;
  if h.name = 'SynCppSyn1' then
    MenuItem16.Checked := True;
  if h.name = 'SynJavaSyn1' then
    MenuItem17.Checked := True;
  if h.name = 'SynPerlSyn1' then
    MenuItem18.Checked := True;
  if h.name = 'SynHTMLSyn1' then
    MenuItem19.Checked := True;
  if h.name = 'SynXMLSyn1' then
    MenuItem20.Checked := True;
  if h.name = 'SynPythonSyn1' then
    MenuItem21.Checked := True;
  if h.name = 'SynLFMSyn1' then
    MenuItem22.Checked := True;
  if h.name = 'SynUNIXShellScriptSyn1' then
    MenuItem23.Checked := True;
  if h.name = 'SynCssSyn1' then
    MenuItem24.Checked := True;
  if h.name = 'SynPHPSyn1' then
    MenuItem25.Checked := True;
  if h.name = 'SynTeXSyn1' then
    MenuItem26.Checked := True;
  if h.name = 'SynSQLSyn1' then
    MenuItem27.Checked := True;
  if h.name = 'SynVBSyn1' then
    MenuItem28.Checked := True;      }

end;

procedure TMainForm.ApplyHighlightByExt(id : integer);
  function Check(id : integer; ext : string; hl : TSynCustomHighlighter):boolean;
  begin
    if pos(LowerCase(ext),LowerCase(hl.DefaultFilter)) > 0 then
      begin
        Docs[id].Edit.Highlighter := hl;
        hl.Enabled := True;
        Result := True
      end
    else
      Result := False;
  end;

var
  s : string;
begin
  s := ExtractFileExt(Docs[id].FileName);
  if Check(id,s,SynPasSyn1) then Exit;
  if Check(id,s,SynFreePascalSyn1) then Exit;
  if Check(id,s,SynCppSyn1) then Exit;
  if Check(id,s,SynJavaSyn1) then Exit;
  if Check(id,s,SynPerlSyn1) then Exit;
  if Check(id,s,SynHTMLSyn1) then Exit;
  if Check(id,s,SynXMLSyn1) then Exit;
  if Check(id,s,SynPythonSyn1) then Exit;
  if Check(id,s,SynLFMSyn1) then Exit;
  if Check(id,s,SynUNIXShellScriptSyn1) then Exit;
  if Check(id,s,SynCssSyn1) then Exit;
  if Check(id,s,SynPHPSyn1) then Exit;
  if Check(id,s,SynTeXSyn1) then Exit;
  if Check(id,s,SynSQLSyn1) then Exit;
  if Check(id,s,SynVBSyn1) then Exit;
end;

procedure TMainForm.ApplyHighlight(id : integer; hl :TSynCustomHighlighter);
begin
  Docs[id].Edit.Highlighter := hl;
  hl.Enabled := True;
end;

procedure TMainForm.SaveDoc(id : integer; SaveAs : boolean = false);
begin
  if SaveAs then
    begin
      if SaveDlgF.ShowModal <> mrOk then
        Exit;
      if SaveDlgF.FName <> '' then
        begin
          Docs[id].Edit.Lines.SaveToFile(SaveDlgF.FName);
          Docs[id].FileName := SaveDlgF.FName;
          Docs[id].Page.Caption := ExtractFileName(SaveDlgF.FName);
        end;
    end
  else
    begin
      if Docs[id].FileName <> '' then
        begin
          Docs[id].Edit.Lines.SaveToFile(Docs[id].FileName);
        end
      else
        begin
          if SaveDlgF.ShowModal <> mrOk then
            Exit;
          if SaveDlgF.FName <> '' then
            begin
              Docs[id].Edit.Lines.SaveToFile(SaveDlgF.FName);
              Docs[id].FileName := SaveDlgF.FName;
              Docs[id].Page.Caption := ExtractFileName(SaveDlgF.FName);
            end;
        end;
    end;
  ShowDBusMiniMessage('File saved');
  Docs[id].Modified := False;
  if Pos('*',Docs[id].Page.Caption)  > 0 then
    Docs[id].Page.Caption := Copy(Docs[id].Page.Caption,Pos('*',Docs[id].Page.Caption)+1,length(Docs[id].Page.Caption));

end;

procedure TMainForm.CloseDoc(id : integer);
var
  i : integer;
  l : TList;
begin
  // Free the components
  Docs[id].Edit.Free;
  Docs[id].Edit := nil;
  Docs[id].Page.Free;
  Docs[id].Page := nil;
  // Now delete from array...
  if Length(Docs) > 1 then
    begin
      for i := id+1 to Length(Docs)-1 do
        begin
          Docs[i-1] := Docs[i];
        end;
      SetLength(Docs, Length(Docs)-1);
    end
  else
    begin
      SetLength(Docs, 0);
      Docs := nil;
    end;
  if pg.PageCount < 1 then
    HighlightMenuItem.Enabled := False;
end;

procedure TMainForm.NewDoc(fname : string);
var
  p : TPoint;
  bmPNG : TPortableNetworkGraphic;
  ks : TSynEditKeyStroke;
  sh : TShortCut;
begin
  SetLength(Docs, Length(Docs)+1);
  Inc(TagCount);
  Docs[Length(Docs)-1].Page := TTabSheet.Create(pg);
  Docs[Length(Docs)-1].Page.Parent := pg;
  Docs[Length(Docs)-1].Page.Tag := TagCount;
  Docs[Length(Docs)-1].Edit := TSynEdit.Create(Docs[Length(Docs)-1].Page);
  Docs[Length(Docs)-1].Edit.Parent := Docs[Length(Docs)-1].Page;
  Docs[Length(Docs)-1].Edit.Align := alClient;
  Docs[Length(Docs)-1].Edit.Tag := TagCount;
  Docs[Length(Docs)-1].Edit.Font.Size:= 16;
  Docs[Length(Docs)-1].Edit.Font.Color:= clBlack;
  Docs[Length(Docs)-1].Edit.Font.Quality:= fqCleartype;
  Docs[Length(Docs)-1].Edit.Font.CharSet:= 4; //FCS_ISO_10646_1 - Unicode
  if fname <> '' then
    begin
      try
        Docs[Length(Docs)-1].Edit.Lines.LoadFromFile(fname);
        Docs[Length(Docs)-1].FileName:= fname;
        Docs[Length(Docs)-1].Page.Caption:= ExtractFileName(fname);
        ApplyHighlightByExt(Length(Docs)-1);
      except
        ShowMessage('Can''t open that file!');
        Docs[Length(Docs)-1].Page.Caption := 'Untitled';
        Docs[Length(Docs)-1].FileName := '';
      end;
    end
  else
    begin
      Docs[Length(Docs)-1].Page.Caption := 'Untitled';
    end;
  Docs[Length(Docs)-1].Edit.OnChange := @GenSynEditChange;
  Docs[Length(Docs)-1].Edit.OnKeyPress := @SynEditDummyKeyPress;
  Docs[Length(Docs)-1].Edit.OnMouseDown := @SynEditDummyMouseDown;
  Docs[Length(Docs)-1].Edit.OnMouseMove := @SynEditDummyMouseMove;
  Docs[Length(Docs)-1].Edit.OnMouseUp := @SynEditDummyMouseUp;
  Docs[Length(Docs)-1].Edit.OnReplaceText := @GenSynEditReplaceText;
  Docs[Length(Docs)-1].Edit.Gutter.Color := clGray;
  Docs[Length(Docs)-1].Edit.Gutter.Parts.Part[1].MarkupInfo.Background := clGray;
  Docs[Length(Docs)-1].Edit.Gutter.Parts.Part[4].MarkupInfo.Foreground := clBlack;
  TQtCustomControl( Docs[Length(Docs)-1].Edit.Handle).viewport.setAttribute(QtWA_InputMethodEnabled);
  // Add bookmark icons
  Docs[Length(Docs)-1].Edit.BookMarkOptions.BookmarkImages := BMImgList;

  // Claim some keys..
  ks := Docs[Length(Docs)-1].Edit.Keystrokes.Add;
  ks.ShortCut := Menus.ShortCut(VK_K,[ssCtrl]);
  ks.Command:=199;

  HighlightMenuItem.Enabled := True;
  pg.ActivePageIndex := Docs[Length(Docs)-1].Page.PageIndex;
  FocusTimer.Enabled := True;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  i : integer;
  iconFile : WideString;
  btn : TQtPushButton;
begin
  MediaBarProx(False);
  CreateMenuBar;
  TagCount := 0;
  LoadSettings(CONFIG_FILE);
  TQtTabWidget(pg.Handle).TabBar.StyleSheet := 'QTabBar::tab { height: 45px; } ' +
                                               'QTabBar::close-button { image: url(/usr/share/icons/hicolor/48x48/hildon/general_close.png); height: 45px; width: 45px; } ' +
                                               'QTabBar::scroller { width: 60px; } ' +
                                               'QTabBar QToolButton { border-color: gray; border-width: 2px; } ' +
                                               'QTabBar QToolButton { background: black; } ' +
                                               'QTabBar QToolButton::right-arrow { image: url(/usr/share/icons/hicolor/48x48/hildon/general_forward.png); } ' +
                                               'QTabBar QToolButton::left-arrow { image: url(/usr/share/icons/hicolor/48x48/hildon/general_back.png); } ';
  // Fullscreen button
  btn := TQtPushButton(FullscreenButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/hildon/general_fullsize.png';
  iconFullscreenH := QIcon_create(@iconFile);
  btn.setIcon(iconFullscreenH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';
  FullscreenButton.Visible := False;
  // Page left button
  btn := TQtPushButton(PageLeftButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/hildon/general_back.png';
  iconPageLeftH := QIcon_create(@iconFile);
  btn.setIcon(iconPageLeftH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';
  PageLeftButton.Visible := False;
  // Page right button
  btn := TQtPushButton(PageRightButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/hildon/general_forward.png';
  iconPageRightH := QIcon_create(@iconFile);
  btn.setIcon(iconPageRightH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';
  PageRightButton.Visible := False;
  // Page close button
  btn := TQtPushButton(PageCloseButton.Handle);
  iconFile := '/usr/share/icons/hicolor/48x48/hildon/general_close.png';
  iconPageCloseH := QIcon_create(@iconFile);
  btn.setIcon(iconPageCloseH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';
  PageCloseButton.Visible := False;

  // Page up button
  btn := TQtPushButton(PageUpButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_up.png';
  iconPageUpH := QIcon_create(@iconFile);
  btn.setIcon(iconPageUpH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page up full button
  btn := TQtPushButton(PageUpFullButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_up_full.png';
  iconPageUpFullH := QIcon_create(@iconFile);
  btn.setIcon(iconPageUpFullH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page down button
  btn := TQtPushButton(PageDownButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_down.png';
  iconPageDownH := QIcon_create(@iconFile);
  btn.setIcon(iconPageDownH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page down full button
  btn := TQtPushButton(PageDownFullButton.Handle);
  iconFile := '/usr/share/icons/hicolor/64x64/apps/txpad_down_full.png';
  iconPageDownFullH := QIcon_create(@iconFile);
  btn.setIcon(iconPageDownFullH);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  // Page label button
  btn := TQtPushButton(PageLabelButton.Handle);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(10, 10, 10, 50%) }';

  // Bookmark button
  btn := TQtPushButton(BookmarkButton.Handle);
  btn.StyleSheet:= 'QPushButton { background-color: rgba(20, 20, 20, 50%) }';

  fullscreen := False;
  XShift := xssNone;
  first := true;
  SearchReplace := False;

  if ParamCount > 0 then
    begin
      for i := 1 to ParamCount do
        begin
          NewDoc(ParamStr(i));
        end;
    end
  else
    NewDoc('');
  StartUpTimer.Enabled := True;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  doit : boolean;
begin
{  doit := False;
//    TxShiftState = (xssNone, xssOne, xssTwo);
  if Key = 227 then
    begin
      case XAltGr of
        xasNone:
          begin
            XAltGr := xasOne;
            Caption := ('xasOne');
          end;
        xasOne:
          begin
            XAltGr := xasTwo;
            Caption := ('xasTwo');
          end;
        xasTwo:
          begin
            XAltGr := xasNone;
            Caption := ('xasNone');
          end;
      end;
    end;
  if (Key = 17) and (XAltGr <> xasNone) then
    begin
      if MainForm.ActiveControl.ClassType = TSynEdit then
        begin
          doit := True;
        end;
    end;
  if (MainForm.ActiveControl.ClassType = TSynEdit) and (doit) then
    begin
      if XAltGr = xasOne then
        begin
          if pg.PageCount < 1 then
            Exit;
          CharDialogF.ShowModal;
          if CharDialogF.Tab then
            begin
              CharDialogF.Tab := False;
              Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(#9);
            end
          else
            Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(CharDialogF.Key);
          XAltGr := xasNone;
        end;
      if XAltGr = xasTwo then
        begin
          if pg.PageCount < 1 then
            Exit;
          CharDialogF.ShowModal;
          if CharDialogF.Tab then
            begin
              CharDialogF.Tab := False;
              Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(#9);
            end
          else
            Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.InsertTextAtCaret(CharDialogF.Key);
        end;
   end;
  if key <> 227 then
    case XAltGr of
      xasOne, xasTwo:
        begin
          XAltGr := xasNone;
        end;
    end;   }
end;

procedure TMainForm.FormResize(Sender: TObject);
begin
  if MainForm.Height > MainForm.Width then
    PortraitMode := True
  else
    PortraitMode := False;
end;

procedure TMainForm.FormUTF8KeyPress(Sender: TObject; var UTF8Key: TUTF8Char);
begin
//  ShowMessage(UTF8Key);
end;

procedure TMainForm.FullscreenButtonClick(Sender: TObject);
begin
  MenuItem31.OnClick(Self);
end;

procedure TMainForm.kineticTimerTimer(Sender: TObject);
begin

end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
//  ShowMessage(inttostr(TQtAbstractScrollArea(Docs[GetDocIDByTag(pg.activepage.tag)].Edit.Handle).verticalScrollBar.getPageStep));
end;

procedure TMainForm.BMGoto1Click(Sender: TObject);
begin
  with Sender as TMenuItem do
    begin
      if Name = 'BMGoto1' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(301,'',nil);
      if Name = 'BMGoto2' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(302,'',nil);
      if Name = 'BMGoto3' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(303,'',nil);
      if Name = 'BMGoto4' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(304,'',nil);
      if Name = 'BMGoto5' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(305,'',nil);
      if Name = 'BMGoto6' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(306,'',nil);
    end;
end;

procedure TMainForm.BMToggle1Click(Sender: TObject);
var
  p : TPoint;
begin
  p := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.LogicalCaretXY;
  with Sender as TMenuItem do
    begin
      if Name = 'BMToggle1' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(361,'',@p);
      if Name = 'BMToggle2' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(362,'',@p);
      if Name = 'BMToggle3' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(363,'',@p);
      if Name = 'BMToggle4' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(364,'',@p);
      if Name = 'BMToggle5' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(365,'',@p);
      if Name = 'BMToggle6' then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CommandProcessor(366,'',@p);
    end;
end;

procedure TMainForm.BookmarkButtonClick(Sender: TObject);
begin
  BookmarkMenu.PopUp;
end;

procedure TMainForm.ActionNewExecute(Sender: TObject);
begin
  LastAction := Sender as TAction;
  LastAction.Enabled:= False;
  if not short_executed then
    begin
      if LastAction.Name = 'ActionNew' then
        MenuItem3.OnClick(Self);
      if LastAction.Name = 'ActionOpen' then
        MenuItem8.OnClick(Self);
      if LastAction.Name = 'ActionSave' then
        MenuItem9.OnClick(Self);
      if LastAction.Name = 'ActionSaveAs' then
        MenuItem10.OnClick(Self);
      if LastAction.Name = 'ActionCloseTab' then
        MenuItem12.OnClick(Self);
      if LastAction.Name = 'ActionSearch' then
        MenuItem35.OnClick(Self);
      if LastAction.Name = 'ActionSearchReplace' then
        MenuItem36.OnClick(Self);
      if LastAction.Name = 'ActionFullScreen' then
        MenuItem31.OnClick(Self);
      if LastAction.Name = 'ActionZoomPlus' then
        MenuItem37.OnClick(Self);
      if LastAction.Name = 'ActionZoomMinus' then
        MenuItem39.OnClick(Self);
      short_executed := True;
    end;
  ShortCutDelayTimer.Enabled := True;
end;

procedure TMainForm.Button4Click(Sender: TObject);
var
  opts : TSynSearchOptions;
  res : integer;
begin
  if not SearchReplace then
    begin
      opts := [ssoFindContinue];
      if Settings.UseRegExpr then
        opts := opts+[ssoRegExpr];
      if Settings.CaseSensitive then
        opts := opts+[ssoMatchCase];
      if Settings.WholeWords then
        opts := opts+[ssoWholeWord];
      res := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,'',opts);
    end
  else
    begin
      opts := [ssoPrompt, ssoReplace];
      if Settings.UseRegExpr then
        opts := opts+[ssoRegExpr];
      if Settings.CaseSensitive then
        opts := opts+[ssoMatchCase];
      if Settings.WholeWords then
        opts := opts+[ssoWholeWord];
      PromptingReplace := False;
      res := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,ReplaceEdit.Text,opts);
    end;
  if res = 0 then
    ShowDBusMiniMessage('Text not found!');
end;

procedure TMainForm.Button5Click(Sender: TObject);
begin
  if SearchReplace then
    MenuItem36.OnClick(Self)
  else
    MenuItem35.OnClick(Self);
end;

procedure TMainForm.Button6Click(Sender: TObject);
var
  opts : TSynSearchOptions;
  res : integer;
begin
  if MessageDlg('Replace All', 'Really replace all?',mtConfirmation,[mbYes, mbNo],0) <> mrYes then
    Exit;
  begin
    opts := [ssoReplaceAll];
    if Settings.UseRegExpr then
      opts := opts+[ssoRegExpr];
    if Settings.CaseSensitive then
      opts := opts+[ssoMatchCase];
    if Settings.WholeWords then
      opts := opts+[ssoWholeWord];
    PromptingReplace := False;
    res := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,ReplaceEdit.Text,opts);
  end;
if res = 0 then
  ShowDBusMiniMessage('Text not found!');
end;

procedure TMainForm.Button7Click(Sender: TObject);
var
  opts : TSynSearchOptions;
begin
  ReplacePanel.Visible := False;
  opts := [ssoPrompt, ssoReplace, ssoSelectedOnly];
  if Settings.UseRegExpr then
    opts := opts+[ssoRegExpr];
  if Settings.CaseSensitive then
    opts := opts+[ssoMatchCase];
  if Settings.WholeWords then
    opts := opts+[ssoWholeWord];
  PromptingReplace := True;
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SearchReplace(SearchEdit.Text,ReplaceEdit.Text,opts);
  Button4.OnClick(Self);
end;

procedure TMainForm.Button8Click(Sender: TObject);
begin
  ReplacePanel.Visible := False;
  Button4.OnClick(Self);
end;

procedure TMainForm.Button9Click(Sender: TObject);
begin
  prox(false);
end;

procedure TMainForm.ExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  MediaBarProx(True);
end;

procedure TMainForm.MenuItem10Click(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      SaveDoc(GetDocIDByTag(pg.ActivePage.Tag), True);
    end;
end;

procedure TMainForm.MenuItem12Click(Sender: TObject);
var
  res : integer;
begin
  if pg.PageCount < 1 then
    Exit;
  if Docs[GetDocIDByTag(pg.ActivePage.Tag)].Modified then
    begin
      res := MessageDlg('Document has been modified', 'Do you want to save the changes?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
      if res = mrYes then
        begin
          SaveDoc(GetDocIDByTag(pg.ActivePage.Tag));
          CloseDoc(GetDocIDByTag(pg.ActivePage.Tag));
        end;
      if res = mrNo then
        begin
          CloseDoc(GetDocIDByTag(pg.ActivePage.Tag));
        end;
    end
  else
    CloseDoc(GetDocIDByTag(pg.ActivePage.Tag));
end;

procedure TMainForm.MenuItem13Click(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      FontDlgF.FontSize := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size;
      FontDlgF.FontName := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Name;
      if FontDlgF.ShowModal = mrOk then
        begin
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Pitch := FontDlgF.FontPitch;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Quality := fqClearType;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := FontDlgF.FontSize;
          Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Name := FontDlgF.FontName;
        end;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Refresh;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
    end;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem14Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPasSyn1);
  //with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem15Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynFreePascalSyn1);
  //with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem16Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynCppSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem17Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynJavaSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem18Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPerlSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem19Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynHTMLSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem20Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynXMLSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem21Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPythonSyn1);
//  with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem22Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynLFMSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem23Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynUnixShellScriptSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem24Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynCSSSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem25Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynPHPSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem26Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynTeXSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem27Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynSQLSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem28Click(Sender: TObject);
begin
  ApplyHighlight(GetDocIDByTag(pg.ActivePage.Tag),SynVBSyn1);
 // with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem31Click(Sender: TObject);
begin
  if fullscreen then
    begin
      UseFullscreen(MainForm.Handle, False);
      fullscreen := False;
      FullscreenButton.Visible := True;
      FullscreenButton.Visible := False;
      FullscreenButton.BringToFront;
    end
  else
    begin
      UseFullscreen(MainForm.Handle, True);
      fullscreen := True;
      FullscreenButton.Visible := False;
      FullscreenButton.Visible := True;
      FullscreenButton.BringToFront;
    end;
end;

procedure TMainForm.MenuItem33Click(Sender: TObject);
var
  i : integer;
begin
  if pg.PageCount  < 1 then
    begin
      ShowMessage('There are no open files...');
      Exit;
    end;
  for i := 14 to 28 do
    begin
      with FindComponent('MenuItem'+inttostr(i)) as TMenuItem do
        if Checked then
          begin
            PasteBinF.Edit2.Text := lowercase(Caption);
            if i = 15 then
              PasteBinF.Edit2.Text := 'pascal';
            if i = 19 then
              PasteBinF.Edit2.Text := 'html4strict';
            if i = 23 then
              PasteBinF.Edit2.Text := '';
            if i = 26 then
              PasteBinF.Edit2.Text := '';
          end;
    end;
  PasteBinF.ShowModal;
end;

procedure TMainForm.MenuItem35Click(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  if not SearchReplace then
    begin
      if SearchPanel.Visible = True then
        begin
          SearchPanel.Visible := False;
          FullScreenButton.Top := MainForm.Height-64;
        end
      else
        begin
          SearchPanel.Visible := True;
          FullScreenButton.Top := MainForm.Height-64-50;
        end;
    end
  else
    begin
      if SearchPanel.Visible = True then
        begin
          SearchPanel.Height := 50;
          Button4.Caption := 'Find Next';
          SearchReplace := False;
          FullScreenButton.Top := MainForm.Height-64-50;
        end
      else
        begin
          SearchPanel.Height := 50;
          Button4.Caption := 'Find Next';
          SearchReplace := False;
          SearchPanel.Visible := False;
          FullScreenButton.Top := MainForm.Height-64;
        end;
    end;
end;

procedure TMainForm.MenuItem36Click(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  if SearchReplace then
    begin
      SearchReplace := False;
      SearchPanel.Height := 50;
      SearchPanel.Visible := False;
      Button4.Caption := 'Find Next';
      FullScreenButton.Top := MainForm.Height-64;
    end
  else
    begin
      SearchReplace := True;
      SearchPanel.Height := 100;
      SearchPanel.Visible := True;
      Button4.Caption := 'Rep Next';
      FullScreenButton.Top := MainForm.Height-64-100;
    end;
end;

procedure TMainForm.MenuItem37Click(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  if Settings.ZoomKeys = zkChangeTabs then
    begin
      // Go left
      if pg.PageIndex > 0 then
        pg.PageIndex:= pg.PageIndex-1;
    end;
  if Settings.ZoomKeys = zkChangeFont then
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := Docs[pg.ActivePage.Tag].Edit.Font.Size-1;
      if Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size <= 6 then
        Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := 6;
      // Caret size doesnt change (bug in SynEdit), so improvise
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.SetFocus;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
//      Docs[pg.ActivePage.Tag].Edit.XCaret.ChangeOnTouch;
    end;

end;

procedure TMainForm.MenuItem39Click(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  if Settings.ZoomKeys = zkChangeTabs then
    begin
      // Go right
      if pg.PageIndex < pg.PageCount then
        pg.PageIndex:= pg.PageIndex+1;
    end;
  if Settings.ZoomKeys = zkChangeFont then
    begin
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := Docs[pg.ActivePage.Tag].Edit.Font.Size+1;
      if Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size >= 40 then
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Font.Size := 40;
      // Caret size doesnt change (bug in SynEdit), so improvise
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Page.SetFocus;
      Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
//      Docs[pg.ActivePage.Tag].Edit.XCaret.ChangeOnTouch;
    end;
end;

procedure TMainForm.MenuItem3Click(Sender: TObject);
begin
  NewDoc('');
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem42Click(Sender: TObject);
begin
  SaveSettings(CONFIG_FILE);
end;

procedure TMainForm.AboutItemClick(Sender: TObject);
begin
  AboutBoxF.ShowModal;
end;

procedure TMainForm.MenuItem5Click(Sender: TObject);
begin
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Highlighter := nil;
  //with Sender as TMenuItem do Checked := True;
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem8Click(Sender: TObject);
begin
  OpenDlgF.ShowModal;
  if OpenDlgF.FName <> '' then
    NewDoc(OpenDlgF.FName);
  MainForm.Refresh;
end;

procedure TMainForm.MenuItem9Click(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      SaveDoc(GetDocIDByTag(pg.ActivePage.Tag));
      ShowDBusMiniMessage('File saved');
    end;
end;

procedure TMainForm.PageCloseButtonClick(Sender: TObject);
begin
  MenuItem12.OnClick(Self);
end;

procedure TMainForm.PageDownButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := TopLine + (LinesInWindow);
        end;
    end;
end;

procedure TMainForm.PageDownFullButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := Lines.Count;
        end;
    end;
end;

procedure TMainForm.PageLeftButtonClick(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  // Go left
  if pg.PageIndex > 0 then
    pg.PageIndex:= pg.PageIndex-1;
end;

procedure TMainForm.PageRightButtonClick(Sender: TObject);
begin
  if pg.PageCount  < 1 then
    Exit;
  // Go right
  if pg.PageIndex < pg.PageCount then
    pg.PageIndex:= pg.PageIndex+1;
end;

procedure TMainForm.PageUpButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := TopLine - (LinesInWindow);
        end;
    end;
end;

procedure TMainForm.PageUpFullButtonClick(Sender: TObject);
begin
  if pg.PageCount > 0 then
    begin
      with Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit do
        begin
          TopLine := 0;
        end;
    end;
end;

procedure TMainForm.pgCloseTabClicked(Sender: TObject);
var
  res : integer;
  i : integer;
begin
  with Sender as TTabSheet do
    begin

      if GetDocIDByTag(Tag) < 0 then
        begin
          ShowMessage('This shouldn''t happen'+inttostr(Tag));
          for i := 0 to length(Docs)-1 do
            ShowMessage('D Tags['+inttostr(i)+'] = '+inttostr(Docs[i].Page.Tag));
        end;
      if Docs[GetDocIDByTag(Tag)].Modified then
        begin
          res := MessageDlg('Document has been modified', 'Do you want to save the changes?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
          if res = mrYes then
            begin
              SaveDoc(GetDocIDByTag(Tag));
              CloseDoc(GetDocIDByTag(Tag));
            end;
          if res = mrNo then
            begin
              CloseDoc(GetDocIDByTag(Tag));
            end;
        end
      else
        CloseDoc(GetDocIDByTag(Tag));
    end;
end;

procedure TMainForm.GenSynEditChange(Sender: TObject);
begin
  with Sender as TSynEdit do
    begin
      Docs[GetDocIDByTag(Tag)].Modified := True;
      if Pos('*',Docs[GetDocIDByTag(Tag)].Page.Caption)  < 1 then
        Docs[GetDocIDByTag(Tag)].Page.Caption := '*'+Docs[GetDocIDByTag(Tag)].Page.Caption;
    end;
end;

procedure TMainForm.pgPageChanged(Sender: TObject);
begin
  if pg.PageCount > 0 then
    PageLabelButton.Caption := pg.ActivePage.Caption
  else
    PageLabelButton.Caption := '';
end;

procedure TMainForm.ProximityTimerTimer(Sender: TObject);
begin
  if not Settings.ShowTabBar then
    begin
      if isProxClosed and (ProxTimeoutTimer.Enabled = false) and (ProxSession = false) then
        begin //Show the buttons..
          ProxSession := True;
          PageLeftButton.Visible := True;
          PageRightButton.Visible := True;
          PageCloseButton.Visible := True;
          PageLabelButton.Visible := True;
          BookmarkButton.Visible := True;
          if pg.PageCount > 0 then
            PageLabelButton.Caption := pg.ActivePage.Caption
          else
            PageLabelButton.Caption := '';
          ProxTimeoutTimer.Enabled := True;
        end;
      if ProxSession and not isProxClosed then
        ProxSession := False;
    end;

  // Page up/down buttons
  if isProxClosed then
    begin
      if Settings.ShowTabBar then
        begin
          PageUpFullButton.Top := 51;
          PageUpButton.Top := 115;
        end
      else
        begin
          PageUpFullButton.Top := 1;
          PageUpButton.Top := 65;
        end;
      PageUpButton.Visible := True;
      PageUpFullButton.Visible := True;
      BookmarkButton.Visible := True;
      if SearchPanel.Visible then
        begin
          if SearchPanel.Height = 50 then
            begin
              PageDownButton.Top := MainForm.Height-64-65-50;
              PageDownFullButton.Top := MainForm.Height-64-50;
              if FullscreenButton.Visible then
                BookmarkButton.Top := MainForm.Height-64-65-50
              else
                BookmarkButton.Top := MainForm.Height-64-50;
            end;
          if SearchPanel.Height = 100 then
            begin
              PageDownButton.Top :=  MainForm.Height-64-65-100;
              PageDownFullButton.Top :=  MainForm.Height-64-100;
              if FullscreenButton.Visible then
                BookmarkButton.Top := MainForm.Height-64-65-100
              else
                BookmarkButton.Top := MainForm.Height-64-100;
            end;
        end
      else
        begin
          PageDownButton.Top :=  MainForm.Height-64-65;
          PageDownFullButton.Top :=  MainForm.Height-64;
          if FullscreenButton.Visible then
            BookmarkButton.Top := MainForm.Height-64-65
          else
            BookmarkButton.Top := MainForm.Height-64;
        end;
      PageDownButton.Visible := True;
      PageDownFullButton.Visible := True;
    end
  else
    begin
      PageUpButton.Visible := False;
      PageUpFullButton.Visible := False;
      PageDownButton.Visible := False;
      PageDownFullButton.Visible := False;
      if ProxTimeoutTimer.Enabled = false then
        PageLabelButton.Visible := False;
    end;
end;

procedure TMainForm.ProxTimeoutTimerTimer(Sender: TObject);
begin
  ProxTimeoutTimer.Enabled := False;
  PageLeftButton.Visible := False;
  PageRightButton.Visible := False;
  PageCloseButton.Visible := False;
  PageLabelButton.Visible := False;
  BookmarkButton.Visible := False;
end;

procedure TMainForm.SearchEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then
    Button4.OnClick(Self);
end;

procedure TMainForm.StartupTimerTimer(Sender: TObject);
begin
  StartupTimer.Enabled := False;
  PageUpButton.Visible := True;
  PageUpFullButton.Visible := True;
  PageDownButton.Visible := True;
  PageDownFullButton.Visible := True;
  PageLabelButton.Visible := True;
  BookmarkButton.Visible := True;
  PageUpButton.Visible := False;
  PageUpFullButton.Visible := False;
  PageDownButton.Visible := False;
  PageDownFullButton.Visible := False;
  PageLabelButton.Visible := False;
  BookmarkButton.Visible := False;
end;

procedure TMainForm.GenSynEditReplaceText(Sender: TObject; const ASearch,
  AReplace: string; Line, Column: integer; var ReplaceAction: TSynReplaceAction
  );
begin
  if not PromptingReplace then
    begin
      PromptingReplace := True;
      ReplaceAction := raCancel;
      ReplacePanel.Visible := True;
    end
  else
    begin
      PromptingReplace := False;
      ReplacePanel.Visible := False;
      ReplaceAction := raReplace;
    end;
end;

procedure TMainForm.kinStopInertia;
begin
  kinInertiaActive := False;
  kinInertiaY := 0;
  kinInertiaX := 0;
  kinTimer.Enabled := False;
end;

procedure TMainForm.SynEditDummyMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if isProxClosed then
    begin
      kinMouseDownPoint.X := X;
      kinMouseDownPoint.Y := Y;
      kinMouseDownPointInertia.X := X;
      kinMouseDownPointInertia.Y := Y;
      kinOriginalScrollBarValue.Y := TQtAbstractScrollArea(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Handle).verticalScrollBar.getValue;
      kinOriginalScrollBarValue.X := TQtAbstractScrollArea(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Handle).horizontalScrollBar.getValue;
      kinMouseIsDown := True;
      with Sender as TSynEdit do
        Options:= Options+[eoNoSelection, eoNoCaret];
      if kinInertiaActive then
        kinStopInertia;
    end;
end;

procedure TMainForm.SynEditDummyMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  SArea : TQtAbstractScrollArea;
  Dist : TPoint;
  SAreaSize : TPoint;
  amountY, amountX : integer;
begin
  if isProxClosed then
    begin
      kinMouseCurrentPoint.X := X;
      kinMouseCurrentPoint.Y := Y;
      kinMouseCurrentPointInertia.X := X;
      kinMouseCurrentPointInertia.Y := Y;
      //Check if outside the no-go radius...
      if kinMouseDownPoint.Y <> -1 then //Check if CurPos is accurate first...
        if (kinMouseCurrentPoint.Y > (kinMouseDownPoint.Y+kinIgnoreRadius)) or (kinMouseCurrentPoint.Y < (kinMouseDownPoint.Y-kinIgnoreRadius)) or
           (kinMouseCurrentPoint.X > (kinMouseDownPoint.X+kinIgnoreRadius)) or (kinMouseCurrentPoint.X < (kinMouseDownPoint.X-kinIgnoreRadius)) then
          begin//We have moved outside the radius, do some moving...
            if not kinInertiaActive then
              begin // Inertia...
                kinInertiaActive := True;
                if not kinTimer.Enabled then
                  kinTimer.Enabled := True;
              end
            else
              begin // Manual drag...
                // Get the Y distance
                if (kinMouseCurrentPoint.Y > kinMouseDownPoint.Y) then
                  dist.Y := (kinMouseCurrentPoint.Y - kinMouseDownPoint.Y)
                else
                  dist.Y := (kinMouseDownPoint.Y - kinMouseCurrentPoint.Y)*-1;
                // Get the X distance
                if (kinMouseCurrentPoint.X > kinMouseDownPoint.X) then
                  dist.X := (kinMouseCurrentPoint.X - kinMouseDownPoint.X)
                else
                  dist.X := (kinMouseDownPoint.X - kinMouseCurrentPoint.X)*-1;

                // Get the ScrollArea
                SArea := TQtAbstractScrollArea(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Handle);
                // Do the math
//                SAreaSize.Y := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.LineHeight*Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Lines.Count;
                SAreaSize.Y := Round((Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Height*((SArea.verticalScrollBar.getMax-SArea.verticalScrollBar.getMin)+SArea.verticalScrollBar.getPageStep))/SArea.verticalScrollBar.getPageStep);
                amountY := Round((Dist.Y * SArea.verticalScrollBar.getMax) / SAreaSize.Y);

              //  TSynEdit.MaxLeftChar:=;

                SAreaSize.X := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.MaxLeftChar*Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CharWidth;
                amountX := Round((Dist.X * SArea.horizontalScrollBar.getMax) / SAreaSize.X);

                // Scroll...
                SArea.verticalScrollBar.setValue(kinOriginalScrollBarValue.Y-amountY);
                SArea.horizontalScrollBar.setValue(kinOriginalScrollBarValue.X-amountX);
              end;
         end;

    end;
end;

procedure TMainForm.SynEditDummyMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  kinMouseDownPoint.X := -1;
  kinMouseDownPoint.Y := -1;
  kinMouseIsDown := False;
  with Sender as TSynEdit do
    Options:= Options-[eoNoSelection, eoNoCaret];
end;

procedure TMainForm.SynEditDummyKeyPress(Sender: TObject; var Key: char);
begin
{  if Key in ['a'..'z','A'..'Z'] then
    if Key <> UpCase(Key) then // Its lower case
      Key := UpCase(Key)
    else
      Key := LowerCase(Key);}
{  if (XShift = xssOne) then
    begin
      if Key in ['a'..'z'] then
        Key := UpCase(Key);
      if Key = '.' then
        Key := ':';
      if Key = ',' then
        Key := ';';
      XShift := xssNone;
    end;
  if (XShift = xssTwo) then
    begin
      if Key in ['a'..'z'] then
        Key := UpCase(Key);
      if Key = '.' then
        Key := ':';
      if Key = ',' then
        Key := ';';
    end;
  if (XAltGr = xasOne) then
    begin
      if UpCase(Key) = UpCase('q') then
        Key := '1';
      if UpCase(Key) = UpCase('w') then
        Key := '2';
      if UpCase(Key) = UpCase('e') then
        Key := '3';
      if UpCase(Key) = UpCase('r') then
        Key := '4';
      if UpCase(Key) = UpCase('t') then
        Key := '5';
      if UpCase(Key) = UpCase('y') then
        Key := '6';
      if UpCase(Key) = UpCase('u') then
        Key := '7';
      if UpCase(Key) = UpCase('i') then
        Key := '8';
      if UpCase(Key) = UpCase('o') then
        Key := '9';
      if UpCase(Key) = UpCase('p') then
        Key := '0';
      if (UpCase(Key) = UpCase(',')) or (UpCase(Key) = UpCase(';')) then
        Key := '=';
      if UpCase(Key) = UpCase('a') then
        Key := '*';
      if UpCase(Key) = UpCase('s') then
        Key := '+';
      if UpCase(Key) = UpCase('d') then
        Key := '#';
      if UpCase(Key) = UpCase('f') then
        Key := '-';
      if UpCase(Key) = UpCase('g') then
        Key := '_';
      if UpCase(Key) = UpCase('h') then
        Key := '(';
      if UpCase(Key) = UpCase('j') then
        Key := ')';
      if UpCase(Key) = UpCase('k') then
        Key := '&';
      if UpCase(Key) = UpCase('l') then
        Key := '!';
      if (UpCase(Key) = UpCase('.')) or (UpCase(Key) = UpCase(':')) then
        Key := '?';
      if UpCase(Key) = UpCase('z') then
        begin
          Key := Char('');
          Docs[pg.ActivePage.Tag].Edit.InsertTextAtCaret('£');
        end;
      if UpCase(Key) = UpCase('x') then
        Key := '$';
      if UpCase(Key) = UpCase('c') then
        begin
          Key := Char('');
          Docs[pg.ActivePage.Tag].Edit.InsertTextAtCaret('€');
        end;
      if UpCase(Key) = UpCase('v') then
        Key := '/';
      if UpCase(Key) = UpCase('b') then
        Key := '\';
      if UpCase(Key) = UpCase('n') then
        Key := '"';
      if UpCase(Key) = UpCase('m') then
        Key := '''';
      if Key = ' ' then
        Key := '@';

      XAltGr := xasNone;
    end;
  if (XAltGr = xasTwo) then
    begin
      if UpCase(Key) = UpCase('q') then
        Key := '1';
      if UpCase(Key) = UpCase('w') then
        Key := '2';
      if UpCase(Key) = UpCase('e') then
        Key := '3';
      if UpCase(Key) = UpCase('r') then
        Key := '4';
      if UpCase(Key) = UpCase('t') then
        Key := '5';
      if UpCase(Key) = UpCase('y') then
        Key := '6';
      if UpCase(Key) = UpCase('u') then
        Key := '7';
      if UpCase(Key) = UpCase('i') then
        Key := '8';
      if UpCase(Key) = UpCase('o') then
        Key := '9';
      if UpCase(Key) = UpCase('p') then
        Key := '0';
      if (UpCase(Key) = UpCase(',')) or (UpCase(Key) = UpCase(';')) then
        Key := '=';
      if UpCase(Key) = UpCase('a') then
        Key := '*';
      if UpCase(Key) = UpCase('s') then
        Key := '+';
      if UpCase(Key) = UpCase('d') then
        Key := '#';
      if UpCase(Key) = UpCase('f') then
        Key := '-';
      if UpCase(Key) = UpCase('g') then
        Key := '_';
      if UpCase(Key) = UpCase('h') then
        Key := '(';
      if UpCase(Key) = UpCase('j') then
        Key := ')';
      if UpCase(Key) = UpCase('k') then
        Key := '&';
      if UpCase(Key) = UpCase('l') then
        Key := '!';
      if (UpCase(Key) = UpCase('.')) or (UpCase(Key) = UpCase(':')) then
        Key := '?';
      if UpCase(Key) = UpCase('z') then
        begin
          Key := Char('');
          Docs[pg.ActivePage.Tag].Edit.InsertTextAtCaret('£');
        end;
      if UpCase(Key) = UpCase('x') then
        Key := '$';
      if UpCase(Key) = UpCase('c') then
        begin
          Key := Char('');
          Docs[pg.ActivePage.Tag].Edit.InsertTextAtCaret('€');
        end;
      if UpCase(Key) = UpCase('v') then
        Key := '/';
      if UpCase(Key) = UpCase('b') then
        Key := '\';
      if UpCase(Key) = UpCase('n') then
        Key := '"';
      if UpCase(Key) = UpCase('m') then
        Key := '''';
      if Key = ' ' then
        Key := '@';
    end;   }
end;


procedure TMainForm.FocusTimerTimer(Sender: TObject);
begin
  FocusTimer.Enabled := False;
  Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.SetFocus;
  pg.ActivePage.Caption := '';
  if Docs[GetDocIDByTag(pg.ActivePage.Tag)].FileName <> '' then
    pg.ActivePage.Caption := ExtractFileName(Docs[GetDocIDByTag(pg.ActivePage.Tag)].FileName)
  else
    pg.ActivePage.Caption := 'Untitled';
end;

procedure TMainForm.ShortCutDelayTimerTimer(Sender: TObject);
begin
  ShortCutDelayTimer.Enabled := False;
  LastAction.Enabled:= True;
  short_executed := False;
end;

procedure TMainForm.kinTimerTimer(Sender: TObject);
var
  SArea : TQtAbstractScrollArea;
  SAreaSize : TPoint;
  tempY, tempX : integer;
begin
  if kinMouseIsDown and kinInertiaActive then
    begin // Gather some energy...
      SArea := TQtAbstractScrollArea(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Handle);
//      SAreaSize.Y := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.LineHeight*Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Lines.Count;
      SAreaSize.Y := Round((Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Height*((SArea.verticalScrollBar.getMax-SArea.verticalScrollBar.getMin)+SArea.verticalScrollBar.getPageStep))/SArea.verticalScrollBar.getPageStep);
      SAreaSize.X := Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.MaxLeftChar*Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.CharWidth;

      tempY := (kinMouseCurrentPointInertia.Y - kinMouseDownPointInertia.Y);
      tempX := (kinMouseCurrentPointInertia.X - kinMouseDownPointInertia.X);
      // Do the math..
      kinInertiaY := Round((tempY * SArea.verticalScrollBar.getMax) / SAreaSize.Y);
      kinMouseDownPointInertia.Y := kinMouseCurrentPointInertia.Y;

      kinInertiaX := Round((tempX * SArea.horizontalScrollBar.getMax) / SAreaSize.X);
      kinMouseDownPointInertia.X := kinMouseCurrentPointInertia.X;
    end
  else if (not kinMouseIsDown) and kinInertiaActive then
    begin // Release the energy...

      // Apply the Y axis friction..
      if kinInertiaY > 0 then
        Dec(kinInertiaY)
      else
        Inc(kinInertiaY);
      // Apply the X axis friction..
      if kinInertiaX > 0 then
        Dec(kinInertiaX)
      else
        Inc(kinInertiaX);

      // Dont boomerang..
      if abs(kinInertiaY) < 2 then
        kinInertiaY := 0;
      if abs(kinInertiaX) < 2 then
        kinInertiaX := 0;

      if (kinInertiaY = 0) and (kinInertiaX = 0) then
        kinStopInertia;

      // Scroll it..
      SArea := TQtAbstractScrollArea(Docs[GetDocIDByTag(pg.ActivePage.Tag)].Edit.Handle);

      SArea.verticalScrollBar.setValue(SArea.verticalScrollBar.getValue-kinInertiaY);
      SArea.horizontalScrollBar.setValue(SArea.horizontalScrollBar.getValue-kinInertiaX);
    end
  else
    begin // Do nothing, stop the motion...(reset);
      kinStopInertia;
    end;
end;

end.

