#!/bin/sh

#!/bin/bash
set -x

# Set the vars

FPC=fpcsrc
LAZARUS=lazarus
PPCARM=ppcarm
PRFX=~/laz-temp
FPC_INSTALL_DIR=fpcinst

function get_fpc {
  if [ -d $PRFX ] 
  then
    echo "$PRFX already exists"
  else
    mkdir $PRFX
    cp compiler/ppcarm $PRFX/ppcarm
    cp t_linux.diff $PRFX/t_linux.diff
  fi 
  cd $PRFX
  echo "getting source from svn"
  svn checkout http://svn.freepascal.org/svn/fpc/trunk fpc
  mv fpc fpcsrc
}

function apply_patches {
  cd $PRFX
  echo "applying patches"
  patch -p1 $FPC/compiler/systems/t_linux.pas < $PRFX/t_linux.diff
}

function compile {
  if [ -d $PRFX ] 
  then
    echo "$PRFX already exists"
  else
    mkdir $PRFX
  fi 
  cd $PRFX
  chmod 777 $PPCARM
  cd $FPC
  echo "About to make all"
  make all PP=$PRFX/$PPCARM PREFIX=$PRFX/$FPC_INSTALL_DIR OPT="-dFPC_ARMEL -O- -dFPC_ABI_EABI -CfSOFT"
  echo "About to make install"
  make install PP=$PRFX/$PPCARM PREFIX=$PRFX/$FPC_INSTALL_DIR OPT="-dFPC_ARMEL -O- -dFPC_ABI_EABI -CfSOFT"
  cd ..
  echo "Done"
}

function create_cfg_file {
  echo "config file setup"
  cp compiler/fpc.etc /etc/fpc.cfg
  cp compiler/fpc.usr ~/.fpc.cfg  
}

function make_fpc {
  echo "make fpc"
  create_cfg_file
  get_fpc
  apply_patches
  compile
}

function get_lazarus {
  cd $PRFX
  echo "getting lazarus"
  svn co http://svn.freepascal.org/svn/lazarus/trunk lazarus  
}

#BEGIN
make_fpc
get_lazarus


