function url_encode( s ) {
    return encodeURIComponent( s )
        .replace( /!/g, '%21' )
        .replace( /\(/g, '%28' )
        .replace( /\)/g, '%29' )
        .replace( /\*/g, '%2A' )
        .replace( /'/g, '%27' );
}

Array.prototype.hasValue = function(value) {
  var i;
  for (i=0; i<this.length; i++) { if (this[i] === value) return true; }
  return false;
}

String.prototype.stripTags = function () {
    return this.replace(/<([^>]+)>/g,'');
}

function convertFromAtom(dateStr) {
//from: YYYY[-MM[-DD[Thh:mm[:ss[.f*]](Z|(+|-)hh:mm)]]] (e.g., 1980-07-03T22:02:00.000-07:00 )
//to: DD MMM YYYY hh:mm:ss GMT[(+|-)hhmm] (e.g., 03 Jul 1980 22:02:00 GMT-0700 )
    if(!(/^(\d{4})(-(\d{2})(-(\d{2})(T(\d{2}:\d{2})(:(\d{2})(.\d+)?)?(Z|[+-]\d{2}:\d{2}))?)?)?$/i).test(dateStr))
    return ""; //not a valid ISO 8601 date string
    var date = dateStr.replace(/^(\d{4})(-(\d{2})(-(\d{2})(.*)?)?)?$/i, "$1,$3,$5,$6").split(","); //date
    var time = date[3].replace(/^T(\d{2}:\d{2})(:(\d{2})(.\d+)?)?(.*)$/i, "$1,$3,$5").split(","); //time
    var zone = time[2].replace(/^(Z|[+-])((\d{2}):(\d{2}))$/i, "$1,$3,$4").split(","); //time zone
    if (zone[1] == undefined) zone[1] = "";
    if (zone[2] == undefined) zone[2] = "";
    var months = ["","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];
    return (date[2]||"01") + " " + (months[date[1]+0]||"Jan") + " " + date[0] + " " + (time[0]||"00:00") + ":" + (time[1]||"00") + " GMT" + (zone[0]=="Z"?"":zone[0]) + zone[1] + zone[2]
}

String.prototype.trim = function () {
    return this.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
}

function getUnixtime(t, mode) {
    var tmp = t;
    if (mode == 'search') tmp = screen.js().convertFromAtom(t);
    var ts = new Date(tmp);
    return ts.getTime();
}

var a = 0;
var tmpDate;
function OBJtoXML(obj,d) {
    // console.log("a: " + a);
    // console.log((typeof obj === "string")?"obj: " + obj:"obj: Object");
    d=(d)?d:0;
    var rString="\n";
    var pad="";
    for(var i=0;i<d;i++) {
        pad+=" ";
    }
    if(typeof obj==="object") {
        if(obj.constructor.toString().indexOf("Array")!== -1) {
            for(var i=0;i<obj.length;i++) {
                if(typeof obj === "string")
                    rString+=pad+"<item>"+obj[i]+"</item>\n";
                else {
                    rString+=pad+"<item>";
                    for(var j in obj[i]){
                        if (obj[i][j] == null) obj[i][j] = "0";
                        // console.log(i + "." + j)
                        a++;
                        var val=OBJtoXML(obj[i][j],d+2);
                        if(!val){
                            return false;
                        }
                        rString+=((rString==="\n")?"":"\n")+pad+" <"+j+">"+val+((typeof obj[i][j]==="object")?"\n"+pad + " ":"")+"</"+j+">";
                    }
                    rString += "\n" + pad + " <timestamp>"+ tmpDate+"</timestamp>\n"
                        + pad + " <user>Twitter</user>\n";
                    rString += pad + "</item>\n";

                }
            }
            rString=rString.substr(0,rString.length-1);
        } else {
            for(i in obj){
                a++;
                var isDate = i.match(/[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}/gi);
                if (isDate) tmpDate = isDate

                var val=OBJtoXML(obj[i],d+1);
                if(!val) {
                    return false;
                }
                if (isDate) {

                    rString+=((rString==="\n")?"":"\n")+pad+"<items>"+val+((typeof obj[i]==="object")?"\n"+pad:"")+"</items>"; // replaced a date with word "time"
                } else
                    rString+=((rString==="\n")?"":"\n")+pad+"<"+i+">"+val+((typeof obj[i]==="object")?"\n"+pad:"")+"</"+i+">";
            }
        }
    } else if(typeof obj === "string"){
        rString=obj;
    } else if(obj.toString){
        rString=obj.toString();
    } else {
        return false;
    }
    return rString;
}

function JSONtoXML(json) {
    return eval("OBJtoXML("+json+");");
}

function getBgSource(type) {
    console.log("type: " + type)
    switch(type) {
        case "search" :
            return "images/flower_blue_1.png"
        break;
        case "rss" :
            return "images/leaves_mix_1.png"
        break;
        case "mentions" :
            return "images/flower_blue_1.png"
        break;
        case "dm" :
            return "images/flower_blue_1.png"
        break;
        case "list" :
            return "images/flower_blue_1.png"
        break;
        case "random" :
            return "images/flower_blue_1.png"
        break;
        default:
            return "images/flower_blue_1.png"
        break;
    }
}
