/*
 * vim:ts=4:sw=4:et:cindent:cino=(0
 */ 

#include <stdlib.h>
#include <glib.h>

static gchar *groups[] =
{
    "edit_mode",
    NULL
};
static gchar *keys[] =
{
    "snap_grid_size",
    NULL
};

int main (int argc, char *argv[])
{
    GKeyFile *kf;
    gint i;
    GError *error = NULL;
    gchar *data;
    gsize size;

    if (argc < 2)
    {
        exit (EXIT_FAILURE);;
    }

    kf = g_key_file_new ();
    if (!g_key_file_load_from_file (kf, TRANSITIONS,
                                    G_KEY_FILE_KEEP_COMMENTS |
                                    G_KEY_FILE_KEEP_TRANSLATIONS,
                                    &error))
    {
        g_warning ("Error while reading %s: %s", TRANSITIONS, error->message);
        g_error_free (error);
        exit (EXIT_FAILURE);
    }

    for (i = 0; i < argc - 1; i++)
    {
        g_key_file_set_string (kf, groups[i], keys[i], argv[i+1]);
    }

    data = g_key_file_to_data (kf, &size, &error);
    if (data == NULL)
    {
        g_warning ("Error while writing keyfile data.");
        g_error_free (error);
        exit (EXIT_FAILURE);
    }
    
    if (!g_file_set_contents (TRANSITIONS, data, size, &error))
    {
        g_warning ("Error writing %s", TRANSITIONS);
        g_free (data);
        g_error_free (error);
        exit (EXIT_FAILURE);
    }

    g_free (data);
    g_key_file_free (kf);

    return 0;
}

