/*
 * TurnOver - try to turn over all the chess pieces
 * Copyright (C) 2010 Xizhi Zhu
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef SCENE_H
#define SCENE_H


#include <QtGui/QGraphicsPixmapItem>
#include <QtGui/QGraphicsScene>


struct Chess
{
    QGraphicsPixmapItem *item;
    bool isWhite;
};


class Scene: public QGraphicsScene
{
    Q_OBJECT

public:
    Scene(QObject *parent = 0);
    ~Scene();

public Q_SLOTS:
    void initBoard(int column, int row);

protected:
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);

signals:
    void gameFinished(int clicks);

private:
    static const int MAX_COLUMNS = 9;
    static const int MAX_ROWS = 9;
    static const int MIN_COLUMNS = 2;
    static const int MIN_ROWS = 2;
    static const int LATTICE_SIZE = 40;
    static const int GRID_WIDTH = 2;
    static const int CHESS_SIZE = 30;
    static const QColor BACKGROUND_COLOR;
    static const QColor LATTICE_COLOR;

    Chess board[MAX_COLUMNS][MAX_ROWS];
    int column;
    int row;
    int clicks;
    int seconds;
};


#endif // SCENE_H
