/*
 * utils.h -- Methods usefull to other classes
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#ifndef UTILS_H
#define UTILS_H

#include <QObject>
#include <QString>
#include <QCryptographicHash>
#include <QMap>
#include <QMapIterator>

class Utils : public QObject
{
    Q_OBJECT

public:
    explicit Utils(QObject *parent = 0);
    QString md5Signature(const QString value);
    QString buildSignature(const QMap<QString, QString> params, const QString secret);
    QString getAuthToken(const QString username, const QString password);
    QString buildApiUrl(const QString baseurl, const QMap<QString, QString> params);
    QByteArray buildPostParameters(const QMap<QString, QString> params);
    QString getScrobblerAuthToken(QString api_secret, QString timestamp);

signals:

public slots:

};

#endif // UTILS_Ha
