#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include "ui_mainwindow.h"
#include <Phonon>
#include <QtNetwork>
#include "options.h"
#include "lastfm.h"
#include "lmaster.h"
#include <QtSql>
#include <QEvent>
#ifdef Q_WS_MAEMO_5
#include <QtDBus>
#endif

class MainWindow : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    Ui::MainWindow ui;
    Phonon::MediaObject *moo ;
    Phonon::AudioOutput *device;
    Phonon::SeekSlider *slider ;
    Phonon::VolumeSlider *volume;
    //QStringList list;
    QMenu *mmenu;
    QMap<int,QStringList> list;
    QMap<int,QStringList> ilist;
    QStringList queue;
    Phonon::MediaObject *metaInformationResolver;
    QProgressBar *loading;
    QDialog *ld;
    options *opt;
    lmaster *lmast;
    int rotate;
    int iload;
    last *scrobler;
    Phonon::VideoWidget *vwidget;

    QSqlDatabase db;
    QString currentQuery;
    QMenu *tmenu;
    QMap<QString,QString> autolist;
    QStringList namefilter;
    Phonon::Effect      *eqEffect;
    QList<QSlider*> sliders;
    Phonon::Path audioPath;
    int on_head_con;
    int on_head_dis;
    int on_start;
    int inet_source;
public slots:
    void load_inet();
    void inet(QListWidgetItem*);
    void fmtx_change(int);
    void toggleEqualizer(bool);
    void sliderChanged (int);
    void resetAll ();
    void alistload();
    void load();
    void click1();
    void click2();
    void click3();
    void click4();
    void click5();
    void click6();
    void click7();
    void click8();


    void i_fn_click();
    void findi();
    void pl_sf_click();
    void pl_fn_click();
    void pl_fn_add_dir();
    void currentItemChanged ( QListWidgetItem * );
    void play_pause();
    void next();
    void prev();
    void changePlay( Phonon::State, Phonon::State ) ;
    void clear();
    void replyFinished(QNetworkReply*);
    void about();
    void drawlist();
    void getMeta(QString );
    void metaStateChanged(Phonon::State, Phonon::State);
    void ch();
    void find();
    void inform();
    void reload();
    #ifdef Q_WS_MAEMO_5
    void grabZoomKeys(bool grab);
    void headphoneEvent (QString,QString);
    #endif
    void dart();
    void dart2();
    void replyFinished2(QNetworkReply*);
    void replyFinished3(QNetworkReply*);
    void kbdhelp();
    void orientationChanged();
protected:
  void keyPressEvent(QKeyEvent* event);
  bool eventFilter(QObject *obj, QEvent *event);

};

#endif // MAINWINDOW_H
