   class SelectDialog(gtk.Dialog):
      
      #-----------------------------------------------------------------
      #  Sets up the search dialog class
      #-----------------------------------------------------------------
      
      def __init__(self, widget, event, parent):
         gtk.Dialog.__init__(self, "Select Search Engine", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
         
         ie = InstalledEngines()
         search_engines = ie.read()
         
         self.liststore = gtk.ListStore(str)
         for s in search_engines:
            self.liststore.append([s])

         self.treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
         self.treeview.set_model(self.liststore)
         
         self.tvcolumn = gtk.TreeViewColumn('Column 0')
         self.treeview.append_column(self.tvcolumn)
         cell = gtk.CellRendererText()
         cell.set_property("alignment", pango.ALIGN_CENTER)
         cell.set_property("xalign", 0.5)
         self.tvcolumn.pack_start(cell, True)
         self.tvcolumn.add_attribute(cell, 'text', 0)
         
         height = len(self.liststore)*70
         if height > 350: height = 350
         
         self.ts = hildon.PannableArea()
         self.ts.set_size_request(-1, height)
         self.ts.add(self.treeview)
         self.vbox.pack_start(self.ts, True, True, 0)
         
         self.show_all()
         
         selection = self.treeview.get_selection()
         selection.unselect_all()
         selection.connect("changed", self.selector_changed, parent)
         
         self.run()
         self.destroy()
         
      def key_pressed(self, widget, event, parent):
         pass
         
      #-----------------------------------------------------------------
      #  Listens for changes in the TouchSelector
      #-----------------------------------------------------------------
         
      def selector_changed(self, widget, parent):
         selection = self.treeview.get_selection()
         model, treeiter = selection.get_selected()
         engine_name = model[treeiter][0]
         # Setup the engine
         TouchSearch.settings.set_search_engine(engine_name)
         TouchSearch.settings.write()
         TouchSearch.engine = Engine(engine_name)
         # Call the parent class paint methods
         TouchSearch.do_expose_event(parent, widget)
         self.destroy() 
