/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.X9FieldElement;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;

public final class X9Curve
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;
    private DERObjectIdentifier fieldIdentifier = null;

    public X9Curve(ECCurve object, byte[] byArray) {
        this.curve = object;
        this.seed = byArray;
        object = this;
        if (((X9Curve)object).curve instanceof ECCurve.Fp) {
            ((X9Curve)object).fieldIdentifier = prime_field;
            return;
        }
        if (((X9Curve)object).curve instanceof ECCurve.F2m) {
            ((X9Curve)object).fieldIdentifier = characteristic_two_field;
            return;
        }
        throw new IllegalArgumentException("This type of ECCurve is not implemented");
    }

    public X9Curve(X9FieldID object, ASN1Sequence aSN1Sequence) {
        this.fieldIdentifier = ((X9FieldID)object).getIdentifier();
        if (this.fieldIdentifier.equals(prime_field)) {
            object = ((DERInteger)((X9FieldID)object).getParameters()).getValue();
            X9FieldElement x9FieldElement = new X9FieldElement((BigInteger)object, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
            X9FieldElement x9FieldElement2 = new X9FieldElement((BigInteger)object, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
            this.curve = new ECCurve.Fp((BigInteger)object, x9FieldElement.getValue().toBigInteger(), x9FieldElement2.getValue().toBigInteger());
        } else if (this.fieldIdentifier.equals(characteristic_two_field)) {
            int n;
            object = (DERSequence)((X9FieldID)object).getParameters();
            int n2 = ((DERInteger)((ASN1Sequence)object).getObjectAt(0)).getValue().intValue();
            ASN1Encodable aSN1Encodable = (DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(1);
            int n3 = 0;
            int n4 = 0;
            if (((ASN1Object)aSN1Encodable).equals(tpBasis)) {
                n = ((DERInteger)((ASN1Sequence)object).getObjectAt(2)).getValue().intValue();
            } else {
                aSN1Encodable = (DERSequence)((ASN1Sequence)object).getObjectAt(2);
                n = ((DERInteger)((ASN1Sequence)aSN1Encodable).getObjectAt(0)).getValue().intValue();
                n3 = ((DERInteger)((ASN1Sequence)aSN1Encodable).getObjectAt(1)).getValue().intValue();
                n4 = ((DERInteger)((ASN1Sequence)aSN1Encodable).getObjectAt(2)).getValue().intValue();
            }
            aSN1Encodable = new X9FieldElement(n2, n, n3, n4, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
            X9FieldElement x9FieldElement = new X9FieldElement(n2, n, n3, n4, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
            this.curve = new ECCurve.F2m(n2, n, n3, n4, ((X9FieldElement)aSN1Encodable).getValue().toBigInteger(), x9FieldElement.getValue().toBigInteger());
        }
        if (aSN1Sequence.size() == 3) {
            this.seed = ((DERBitString)aSN1Sequence.getObjectAt(2)).getBytes();
        }
    }

    public final ECCurve getCurve() {
        return this.curve;
    }

    public final byte[] getSeed() {
        return this.seed;
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.fieldIdentifier.equals(prime_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).getDERObject());
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).getDERObject());
        } else if (this.fieldIdentifier.equals(characteristic_two_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).getDERObject());
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).getDERObject());
        }
        if (this.seed != null) {
            aSN1EncodableVector.add(new DERBitString(this.seed));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

