/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public class DERApplicationSpecific
extends ASN1Object {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, ASN1EncodableVector aSN1EncodableVector) {
        this.tag = n;
        this.isConstructed = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (true) {
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
            if (n2 == aSN1EncodableVector2.v.size()) break;
            try {
                byteArrayOutputStream.write(((ASN1Encodable)aSN1EncodableVector.get(n2)).getEncoded());
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
            ++n2;
        }
        this.octets = byteArrayOutputStream.toByteArray();
    }

    public final boolean isConstructed() {
        return this.isConstructed;
    }

    public final byte[] getContents() {
        return this.octets;
    }

    public final int getApplicationTag() {
        return this.tag;
    }

    public final DERObject getObject(int n) throws IOException {
        byte[] byArray;
        byte[] byArray2 = byArray = this.getEncoded();
        int n2 = 16;
        int n3 = byArray2[0] & 0x1F;
        int n4 = 1;
        if (n3 == 31) {
            ++n4;
            n3 = byArray2[1] & 0xFF;
            if ((n3 & 0x7F) == 0) {
                throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
            }
            while (n3 >= 0 && (n3 & 0x80) != 0) {
                n3 = byArray2[n4++] & 0xFF;
            }
        }
        byte[] byArray3 = new byte[byArray2.length - n4 + 1];
        System.arraycopy(byArray2, n4, byArray3, 1, byArray3.length - 1);
        byArray3[0] = (byte)n2;
        byte[] byArray4 = byArray3;
        if ((byArray[0] & 0x20) != 0) {
            byArray4[0] = (byte)(byArray4[0] | 0x20);
        }
        return new ASN1InputStream(byArray4).readObject();
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        int n = 64;
        if (this.isConstructed) {
            n = 96;
        }
        dEROutputStream.writeEncoded(n, this.tag, this.octets);
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        dERObject = (DERApplicationSpecific)dERObject;
        return this.isConstructed == ((DERApplicationSpecific)dERObject).isConstructed && this.tag == ((DERApplicationSpecific)dERObject).tag && AsymmetricKeyParameter.areEqual(this.octets, ((DERApplicationSpecific)dERObject).octets);
    }

    @Override
    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ AsymmetricKeyParameter.hashCode(this.octets);
    }
}

