/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;

public final class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        super(bl, n, dEREncodable);
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.writeTag(160, this.tagNo);
            dEROutputStream.write(128);
            if (!this.explicit) {
                Object object;
                if (this.obj instanceof ASN1OctetString) {
                    if (this.obj instanceof BERConstructedOctetString) {
                        object = ((BERConstructedOctetString)this.obj).getObjects();
                    } else {
                        object = (ASN1OctetString)this.obj;
                        object = new BERConstructedOctetString(((ASN1OctetString)object).getOctets());
                        object = ((BERConstructedOctetString)object).getObjects();
                    }
                } else if (this.obj instanceof ASN1Sequence) {
                    object = ((ASN1Sequence)this.obj).getObjects();
                } else if (this.obj instanceof ASN1Set) {
                    object = ((ASN1Set)this.obj).getObjects();
                } else {
                    throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                }
                while (object.hasMoreElements()) {
                    dEROutputStream.writeObject(object.nextElement());
                }
            } else {
                dEROutputStream.writeObject(this.obj);
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
            return;
        }
        super.encode(dEROutputStream);
    }
}

