/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui.tree;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;
import to_do_o.gui.IconProvider;
import to_do_o.gui.tree.NoteItem;
import to_do_o.gui.tree.ToDoItem;

public abstract class AbstractItem {
    private String text;
    private Item item;
    protected Element element;

    public static AbstractItem newInstance(Element element, Widget object, int n) {
        if (element.getName().equals("to-do")) {
            object = new ToDoItem(element, (Widget)object, n);
            if (element.getChildCount() > 1 && ((AbstractItem)object).getTreeItem() != null) {
                element = new TreeItem(((AbstractItem)object).getTreeItem(), 0);
                element.setData(null);
            }
        } else {
            object = new NoteItem(element, (Widget)object, n);
        }
        return object;
    }

    protected AbstractItem(Element element, Widget w, int index) {
        this.element = element;
        this.text = element.getText(0);
        if (w instanceof TreeItem) {
            this.item = new TreeItem((TreeItem)w, 0, index);
        } else if (w instanceof Tree) {
            this.item = new TreeItem((Tree)w, 0, index);
        } else if (w instanceof Table) {
            this.item = new TableItem((Table)w, 0);
        } else {
            throw new IllegalArgumentException("Parameter w must be of class Tree or TreeItem! Was: " + w.getClass().getName());
        }
        this.item.setData((Object)this);
        this.update();
    }

    public final void delete() {
        Node parent = this.element.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i).hashCode() != this.element.hashCode()) continue;
            parent.removeChild(i);
            break;
        }
        if (this.item instanceof TreeItem) {
            ((TreeItem)this.item).getParent().notifyListeners(24, null);
        }
        this.item.dispose();
    }

    public final Element getElement() {
        return this.element;
    }

    public final TableItem getTableItem() {
        if (this.item instanceof TableItem) {
            return (TableItem)this.item;
        }
        return null;
    }

    public final String getText() {
        return this.text;
    }

    public final TreeItem getTreeItem() {
        if (this.item instanceof TreeItem) {
            return (TreeItem)this.item;
        }
        return null;
    }

    protected Image iconImageHook() {
        return IconProvider.getIconImage("/icons/to-do_blue.png.png");
    }

    public final void setText(String text) {
        this.text = text;
        this.element.removeChild(0);
        this.element.addChild(0, 4, (Object)this.text);
        this.update();
    }

    public String toString() {
        return this.text;
    }

    protected final void update() {
        if (!(this.item instanceof TableItem)) {
            this.item.setImage(this.iconImageHook());
        }
        this.item.setText(this.toString());
    }

    protected final void notifyTree() {
        if (this.item instanceof TreeItem) {
            ((TreeItem)this.item).getParent().notifyListeners(24, null);
        }
    }
}

