/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui.tree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.kxml2.kdom.Element;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import to_do_o.core.data.ToDoDocument;
import to_do_o.core.io.FileNotFoundException;
import to_do_o.core.io.StreamUtil;
import to_do_o.core.settings.SettingsStore;
import to_do_o.core.settings.SettingsStoreSingleton;
import to_do_o.gui.tree.AbstractItem;
import to_do_o.gui.tree.NoteItem;
import to_do_o.gui.tree.ToDoItem;
import to_do_o.gui.tree.action.Action;
import to_do_o.gui.tree.action.tree_item.EditItemAction;

public class ToDoTree {
    protected Tree tree;
    private Composite parent;
    protected ToDoDocument doc;

    public ToDoTree(Composite parent) {
        this.parent = parent;
    }

    public final void addListener(int n, Listener listener) {
        this.tree.addListener(24, listener);
    }

    protected void addListeners() {
        this.tree.addMouseListener(new MouseListener(this){
            private TreeItem downItem;
            private long downTimestamp;
            private SettingsStore settStore = SettingsStoreSingleton.getInstance();
            private int seconds = this.settStore.getInt("ItemMoveDelay");
            private /* synthetic */ ToDoTree this$0;
            {
                this.this$0 = toDoTree;
            }

            public final void mouseDoubleClick(MouseEvent object) {
                if (!(object.widget instanceof Tree)) {
                    return;
                }
                object = (Tree)object.widget;
                TreeItem treeItem = object.getSelection();
                if (treeItem == null || ((TreeItem[])treeItem).length <= 0) {
                    return;
                }
                if ((treeItem = treeItem[0]) == null || !(treeItem.getData() instanceof AbstractItem)) {
                    return;
                }
                AbstractItem abstractItem = (AbstractItem)treeItem.getData();
                if (abstractItem instanceof ToDoItem) {
                    if (treeItem.getItemCount() > 0) {
                        if (!treeItem.getExpanded()) {
                            ToDoTree.expandTreeItem(treeItem);
                            treeItem.setExpanded(true);
                            return;
                        }
                        treeItem.setExpanded(false);
                        return;
                    }
                } else if ((object = new StreamUtil(object.getShell(), "Edit:\n" + abstractItem.getText())).answerYes()) {
                    new EditItemAction(this.this$0).execute();
                }
            }

            public final void mouseDown(MouseEvent treeItem) {
                if (treeItem == null || treeItem.button != 1) {
                    return;
                }
                if (!(treeItem.widget instanceof Tree)) {
                    this.downItem = null;
                    return;
                }
                treeItem = (Tree)treeItem.widget;
                if ((treeItem = treeItem.getSelection()) == null || ((TreeItem[])treeItem).length <= 0) {
                    this.downItem = null;
                    return;
                }
                if (!((treeItem = treeItem[0]) instanceof TreeItem)) {
                    this.downItem = null;
                    return;
                }
                long l = System.currentTimeMillis();
                this.downItem = treeItem;
                this.downTimestamp = l;
            }

            public final void mouseUp(MouseEvent treeItem) {
                if (this.downItem == null || treeItem == null || !(treeItem.widget instanceof Tree)) {
                    return;
                }
                treeItem = (Tree)treeItem.widget;
                if ((treeItem = treeItem.getSelection()) == null || ((TreeItem[])treeItem).length <= 0) {
                    return;
                }
                if (!((treeItem = treeItem[0]) instanceof TreeItem)) {
                    return;
                }
                long l = System.currentTimeMillis();
                if (l - this.downTimestamp > (long)(1000 * this.seconds) && this.downItem != null && this.downItem != treeItem) {
                    this.this$0.moveTreeItem(this.downItem, treeItem, true);
                }
            }
        });
        this.tree.addTreeListener(new TreeListener(this){
            private /* synthetic */ ToDoTree this$0;
            {
                this.this$0 = toDoTree;
            }

            public final void treeCollapsed(TreeEvent arg0) {
            }

            public final void treeExpanded(TreeEvent treeEvent) {
                treeEvent = (TreeItem)treeEvent.item;
                ToDoTree.expandTreeItem((TreeItem)treeEvent);
            }
        });
    }

    public final void addSelectionListener(SelectionListener listener) {
        this.tree.addSelectionListener(listener);
    }

    private void createTree() {
        ToDoDocument toDoDocument;
        this.tree = new Tree(this.parent, 4);
        this.addListeners();
        int n = 0;
        while (n < (toDoDocument = this.doc).getRootElement().getChildCount()) {
            int n2 = n++;
            toDoDocument = this.doc;
            toDoDocument = toDoDocument.getRootElement().getElement(n2);
            AbstractItem.newInstance((Element)toDoDocument, (Widget)this.tree, this.tree.getItemCount());
        }
        this.tree.layout();
    }

    public final void createTreeEntry(String treeItemArray, String string) {
        if (treeItemArray == null || string == null) {
            return;
        }
        Element element = this.doc.getRootElement();
        string = element.createElement("", string);
        string.addChild(4, (Object)treeItemArray);
        treeItemArray = SettingsStoreSingleton.getInstance();
        treeItemArray = treeItemArray.get("TreeItemPlacement");
        if (treeItemArray != null && treeItemArray.equals("Top")) {
            element.addChild(0, 2, (Object)string);
            treeItemArray = AbstractItem.newInstance((Element)string, (Widget)this.tree, 0);
        } else {
            element.addChild(2, (Object)string);
            treeItemArray = AbstractItem.newInstance((Element)string, (Widget)this.tree, this.tree.getItemCount());
        }
        treeItemArray = new TreeItem[]{treeItemArray.getTreeItem()};
        this.tree.setSelection(treeItemArray);
        this.tree.redraw();
        this.tree.notifyListeners(24, null);
    }

    public final void createTreeItemEntry(String object, String string) {
        if (object == null || string == null) {
            return;
        }
        AbstractItem abstractItem = this.getSelection();
        if (abstractItem == null) {
            return;
        }
        Element element = this.tree.getSelection();
        if (element != null && ((TreeItem[])element).length > 0) {
            ToDoTree.expandTreeItem((TreeItem)element[0]);
        }
        element = abstractItem.getElement();
        string = element.createElement("", string);
        string.addChild(4, object);
        object = SettingsStoreSingleton.getInstance();
        object = ((SettingsStore)object).get("ItemPlacement");
        if (object != null && ((String)object).equals("Top")) {
            element.addChild(1, 2, (Object)string);
            AbstractItem.newInstance((Element)string, (Widget)abstractItem.getTreeItem(), 0);
        } else {
            element.addChild(2, (Object)string);
            AbstractItem.newInstance((Element)string, (Widget)abstractItem.getTreeItem(), abstractItem.getTreeItem().getItemCount());
        }
        this.tree.redraw();
        this.tree.notifyListeners(24, null);
        abstractItem.getTreeItem().setExpanded(true);
    }

    public final void dispose() {
        this.tree.dispose();
    }

    public final void executeActionOnTree(Action action, boolean cascade) {
        TreeItem[] rootItems = this.tree.getItems();
        if (rootItems == null || rootItems.length <= 0) {
            return;
        }
        for (int i = 0; i < rootItems.length; ++i) {
            this.executeActionOnTreeItem(action, rootItems[i], cascade);
        }
    }

    private void executeActionOnTreeItem(Action object, TreeItem treeItemArray, boolean bl) {
        if (treeItemArray == null || treeItemArray.isDisposed()) {
            return;
        }
        boolean bl2 = treeItemArray.getExpanded();
        if (!bl2) {
            ToDoTree.expandTreeItem((TreeItem)treeItemArray);
        }
        this.tree.setSelection(new TreeItem[]{treeItemArray});
        ((Action)object).execute();
        if (bl) {
            TreeItem[] treeItemArray2 = treeItemArray;
            Action action = object;
            object = this;
            if (treeItemArray2 != null && !treeItemArray2.isDisposed() && (treeItemArray2 = treeItemArray2.getItems()) != null && treeItemArray2.length > 0) {
                for (int i = 0; i < treeItemArray2.length; ++i) {
                    super.executeActionOnTreeItem(action, treeItemArray2[i], true);
                }
            }
        }
        if (treeItemArray != null && !treeItemArray.isDisposed()) {
            treeItemArray.setExpanded(bl2);
        }
    }

    public final void executeActionOnSelectedTreeItem(Action action, boolean bl) {
        AbstractItem abstractItem = this.getSelection();
        if (abstractItem instanceof AbstractItem) {
            this.executeActionOnTreeItem(action, abstractItem.getTreeItem(), bl);
            return;
        }
        this.executeActionOnTree(action, bl);
    }

    public static void expandTreeItem(TreeItem object) {
        AbstractItem abstractItem = (AbstractItem)object.getData();
        Element element = abstractItem.getElement();
        object = abstractItem.getTreeItem().getItems();
        if (element.getChildCount() > 1 && object != null && ((TreeItem[])object).length > 0 && object[0].getData() == null) {
            abstractItem.getTreeItem().getItems()[0].dispose();
            for (int i = 1; i < element.getChildCount(); ++i) {
                Element element2 = element.getElement(i);
                if (element2 == null || (object = abstractItem.getTreeItem()) == null) continue;
                if (element2.getName().equals("to-do")) {
                    object = new ToDoItem(element2, (Widget)object, object.getItemCount());
                    if (element2.getChildCount() <= 1) continue;
                    object = new TreeItem(((AbstractItem)object).getTreeItem(), 0);
                    object.setData(null);
                    continue;
                }
                new NoteItem(element2, (Widget)object, object.getItemCount());
            }
        }
    }

    public final AbstractItem getSelection() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection != null && selection.length > 0) {
            TreeItem ti = selection[0];
            AbstractItem tid = (AbstractItem)ti.getData();
            return tid;
        }
        return null;
    }

    public final ToDoDocument getToDoDocument() {
        return this.doc;
    }

    public final Tree getTree() {
        return this.tree;
    }

    public void loadTreeFromRecordStore() {
        this.preLoad();
        Object object = this.doc;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"To-Do_XML", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
                KXmlParser kXmlParser = new KXmlParser();
                try {
                    kXmlParser.setInput((InputStream)byteArrayInputStream, "utf8");
                    object.parse((XmlPullParser)kXmlParser);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    object = xmlPullParserException;
                    xmlPullParserException.printStackTrace();
                }
                byteArrayInputStream.close();
            }
            recordEnumeration.destroy();
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        this.createTree();
    }

    public final void loadTreeFromXMLFile(String string) {
        this.preLoad();
        try {
            this.doc.loadFromFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new X9IntegerConverter(this.parent.getShell(), "Creating new to-do tree.");
        }
        this.createTree();
    }

    public final void moveTreeItem(TreeItem object, TreeItem treeItem, boolean bl) {
        Element element;
        Element element2;
        if (object == null || treeItem == null) {
            return;
        }
        TreeItem treeItem2 = null;
        Tree tree = null;
        if (treeItem.getParentItem() != null) {
            treeItem2 = treeItem.getParentItem();
            element2 = treeItem2.getItems();
        } else {
            tree = treeItem.getParent();
            element2 = tree.getItems();
        }
        if (object.equals(tree) || object.equals(treeItem2)) {
            return;
        }
        int n = 0;
        for (int i = 0; i < ((TreeItem[])element2).length; ++i) {
            if (treeItem != element2[i]) continue;
            n = i + 1;
            break;
        }
        int n2 = n;
        object = (AbstractItem)object.getData();
        element2 = ((AbstractItem)object).getElement();
        if (treeItem2 != null) {
            element = ((AbstractItem)treeItem2.getData()).getElement();
            AbstractItem.newInstance(element2, (Widget)treeItem2, n2);
        } else {
            element = this.doc.getRootElement();
            AbstractItem.newInstance(element2, (Widget)tree, n2);
            --n2;
        }
        treeItem2 = element;
        if (treeItem2.getChildCount() > n2) {
            treeItem2.addChild(n2 + 1, 2, (Object)element2);
        } else if (treeItem2.getChildCount() == n2) {
            treeItem2.addChild(2, (Object)element2);
        }
        if (bl) {
            ((AbstractItem)object).delete();
        }
        this.tree.notifyListeners(24, null);
    }

    protected void preLoad() {
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.doc = new ToDoDocument();
    }

    public void saveTreeToRecordStore() {
        ToDoDocument toDoDocument = this.doc;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        KXmlSerializer kXmlSerializer = new KXmlSerializer();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"To-Do_XML", (boolean)true);
            kXmlSerializer.setOutput((OutputStream)byteArrayOutputStream, "utf8");
            toDoDocument.write((XmlSerializer)kXmlSerializer);
            kXmlSerializer.flush();
            toDoDocument = recordStore.enumerateRecords(null, null, false);
            if (toDoDocument.hasNextElement()) {
                recordStore.deleteRecord(toDoDocument.nextRecordId());
            }
            toDoDocument.destroy();
            recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            recordStore.closeRecordStore();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public final void saveTreeToXMLFile(String object) {
        try {
            this.doc.saveToFile((String)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public final void setLayoutData(Object layoutData) {
        this.tree.setLayoutData(layoutData);
    }

    public final void setMenu(Menu menu) {
        this.tree.setMenu(menu);
    }

    public ToDoTree() {
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }
}

