/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public final class DERBoolean
extends ASN1Object {
    private byte value;

    public static DERBoolean getInstance(Object object) {
        while (true) {
            if (object == null || object instanceof DERBoolean) {
                return (DERBoolean)object;
            }
            if (object instanceof ASN1OctetString) {
                return new DERBoolean(((ASN1OctetString)object).getOctets());
            }
            if (!(object instanceof ASN1TaggedObject)) break;
            object = ((ASN1TaggedObject)object).getObject();
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public DERBoolean(byte[] byArray) {
        this.value = byArray[0];
    }

    public DERBoolean(boolean bl) {
        this.value = (byte)(bl ? -1 : 0);
    }

    public final boolean isTrue() {
        return this.value != 0;
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = this.value;
        dEROutputStream.writeEncoded(1, byArray2);
    }

    @Override
    protected final boolean asn1Equals(DERObject dERObject) {
        if (dERObject == null || !(dERObject instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)dERObject).value;
    }

    @Override
    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        if (this.value != 0) {
            return "TRUE";
        }
        return "FALSE";
    }

    static {
        new DERBoolean(false);
        new DERBoolean(true);
    }
}

