/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.config;

import ch.elca.el4j.services.xmlmerge.Action;
import ch.elca.el4j.services.xmlmerge.ConfigurationException;
import ch.elca.el4j.services.xmlmerge.Configurer;
import ch.elca.el4j.services.xmlmerge.Mapper;
import ch.elca.el4j.services.xmlmerge.Matcher;
import ch.elca.el4j.services.xmlmerge.MergeAction;
import ch.elca.el4j.services.xmlmerge.XmlMerge;
import ch.elca.el4j.services.xmlmerge.action.OrderedMergeAction;
import ch.elca.el4j.services.xmlmerge.action.StandardActions;
import ch.elca.el4j.services.xmlmerge.factory.OperationResolver;
import ch.elca.el4j.services.xmlmerge.factory.XPathOperationFactory;
import ch.elca.el4j.services.xmlmerge.mapper.IdentityMapper;
import ch.elca.el4j.services.xmlmerge.mapper.StandardMappers;
import ch.elca.el4j.services.xmlmerge.matcher.StandardMatchers;
import ch.elca.el4j.services.xmlmerge.matcher.TagMatcher;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractXPathConfigurer
implements Configurer {
    OperationResolver m_matcherResolver = new OperationResolver(StandardMatchers.class);
    OperationResolver m_actionResolver = new OperationResolver(StandardActions.class);
    OperationResolver m_mapperResolver = new OperationResolver(StandardMappers.class);
    MergeAction m_rootMergeAction = new OrderedMergeAction();
    Matcher m_defaultMatcher = new TagMatcher();
    Mapper m_defaultMapper = new IdentityMapper();
    Action m_defaultAction = new OrderedMergeAction();
    Map m_matchers = new LinkedHashMap();
    Map m_actions = new LinkedHashMap();
    Map m_mappers = new LinkedHashMap();

    protected final void setDefaultMatcher(String matcherName) throws ConfigurationException {
        this.m_defaultMatcher = (Matcher)this.m_matcherResolver.resolve(matcherName);
    }

    protected final void setDefaultMapper(String mapperName) throws ConfigurationException {
        this.m_defaultMapper = (Mapper)this.m_mapperResolver.resolve(mapperName);
    }

    protected final void setDefaultAction(String actionName) throws ConfigurationException {
        this.m_defaultAction = (Action)this.m_actionResolver.resolve(actionName);
    }

    protected final void setRootMergeAction(String actionName) throws ConfigurationException {
        this.m_rootMergeAction = (MergeAction)this.m_actionResolver.resolve(actionName);
    }

    protected final void addMatcher(String xPath, String matcherName) throws ConfigurationException {
        this.m_matchers.put(xPath, (Matcher)this.m_matcherResolver.resolve(matcherName));
    }

    protected final void addAction(String xPath, String actionName) throws ConfigurationException {
        this.m_actions.put(xPath, (Action)this.m_actionResolver.resolve(actionName));
    }

    protected final void addMapper(String xPath, String mapperName) throws ConfigurationException {
        this.m_mappers.put(xPath, (Mapper)this.m_mapperResolver.resolve(mapperName));
    }

    public final void configure(XmlMerge xmlMerge) throws ConfigurationException {
        this.readConfiguration();
        XPathOperationFactory matcherFactory = new XPathOperationFactory();
        matcherFactory.setDefaultOperation(this.m_defaultMatcher);
        matcherFactory.setOperationMap(this.m_matchers);
        this.m_rootMergeAction.setMatcherFactory(matcherFactory);
        XPathOperationFactory mapperFactory = new XPathOperationFactory();
        mapperFactory.setDefaultOperation(this.m_defaultMapper);
        mapperFactory.setOperationMap(this.m_mappers);
        this.m_rootMergeAction.setMapperFactory(mapperFactory);
        XPathOperationFactory actionFactory = new XPathOperationFactory();
        actionFactory.setDefaultOperation(this.m_defaultAction);
        actionFactory.setOperationMap(this.m_actions);
        this.m_rootMergeAction.setActionFactory(actionFactory);
        xmlMerge.setRootMergeAction(this.m_rootMergeAction);
    }

    protected abstract void readConfiguration() throws ConfigurationException;

    public void setActionResolver(OperationResolver actionResolver) {
        this.m_actionResolver = actionResolver;
    }

    public void setMapperResolver(OperationResolver mapperResolver) {
        this.m_mapperResolver = mapperResolver;
    }

    public void setMatcherResolver(OperationResolver matcherResolver) {
        this.m_matcherResolver = matcherResolver;
    }
}

