/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.core.io.net;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.eclipse.swt.widgets.Display;
import to_do_o.core.config.SWTConstants;
import to_do_o.core.io.StreamUtil;
import to_do_o.gui.dialog.CancelDialog;

public final class SyncServer
implements Runnable {
    private CancelDialog cancelDialog;
    private DatagramSocket udpServerSocket;
    private SSLServerSocket tcpServerSocket;
    private SSLSocket tcpSocket;
    private String request;

    public SyncServer(CancelDialog dialog) {
        this.cancelDialog = dialog;
    }

    public final void closeSockets() {
        IOException iOException;
        if (this.udpServerSocket != null) {
            this.udpServerSocket.close();
        }
        if (this.tcpServerSocket != null) {
            try {
                this.tcpServerSocket.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                iOException2.printStackTrace();
            }
        }
        if (this.tcpSocket != null) {
            try {
                this.tcpSocket.close();
                return;
            }
            catch (IOException iOException3) {
                iOException = iOException3;
                iOException3.printStackTrace();
            }
        }
    }

    private void performSync() throws IOException {
        if (this.request.equals("To-Do-O?")) {
            SSLServerSocketFactory sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            if (this.tcpServerSocket != null) {
                this.tcpServerSocket.close();
            }
            this.tcpServerSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(26001);
            if (this.tcpSocket != null) {
                this.tcpSocket.close();
            }
            this.tcpSocket = (SSLSocket)this.tcpServerSocket.accept();
            this.tcpSocket.startHandshake();
            InputStream in = this.tcpSocket.getInputStream();
            ASN1StreamParser.writeInputStreamToFile((InputStream)in, (String)SWTConstants.INCOMING_XML_FILE);
            this.tcpSocket.close();
            this.tcpSocket = (SSLSocket)this.tcpServerSocket.accept();
            this.tcpServerSocket.close();
        }
    }

    @Override
    public final void run() {
        try {
            SyncServer syncServer = this;
            this.udpServerSocket = new DatagramSocket(26001);
            Object object = new byte[100];
            object = new DatagramPacket((byte[])object, ((byte[])object).length);
            syncServer.udpServerSocket.receive((DatagramPacket)object);
            syncServer.request = new String(((DatagramPacket)object).getData(), ((DatagramPacket)object).getOffset(), ((DatagramPacket)object).getLength());
            if (syncServer.request.equals("To-Do-O?")) {
                String string = "To-Do-O!";
                object = new DatagramPacket(string.getBytes(), string.getBytes().length, ((DatagramPacket)object).getSocketAddress());
                syncServer.udpServerSocket.send((DatagramPacket)object);
                syncServer.udpServerSocket.close();
            }
            this.performSync();
        }
        catch (Exception exception) {
            try {
                this.closeSockets();
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                if (!this.cancelDialog.isDisposed()) {
                    Display.getDefault().syncExec(new Runnable(this){
                        private /* synthetic */ SyncServer this$0;
                        {
                            this.this$0 = syncServer;
                        }

                        @Override
                        public final void run() {
                            this.this$0.cancelDialog.close();
                        }
                    });
                }
                throw throwable;
            }
            if (!this.cancelDialog.isDisposed()) {
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                return;
            }
        }
        if (!this.cancelDialog.isDisposed()) {
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            return;
        }
    }

    public final void sendNewFile(String fileName) throws IOException {
        FileInputStream in = new FileInputStream(fileName);
        OutputStream out = this.tcpSocket.getOutputStream();
        StreamUtil.writeInputStreamToOutputStream(in, out);
    }
}

