/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.util.encoders.Hex;

public abstract class ASN1OctetString
extends ASN1Object
implements ASN1OctetStringParser {
    byte[] string;

    public static ASN1OctetString getInstance(Object object) {
        while (true) {
            if (object == null || object instanceof ASN1OctetString) {
                return (ASN1OctetString)object;
            }
            if (!(object instanceof ASN1TaggedObject)) break;
            object = ((ASN1TaggedObject)object).getObject();
        }
        if (object instanceof ASN1Sequence) {
            Vector vector = new Vector();
            object = ((ASN1Sequence)object).getObjects();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            return new BERConstructedOctetString(vector);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public ASN1OctetString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("string cannot be null");
        }
        this.string = byArray;
    }

    public ASN1OctetString(DEREncodable dEREncodable) {
        try {
            this.string = dEREncodable.getDERObject().getEncoded("DER");
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    @Override
    public final InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return PKCS1Encoding.hashCode(this.getOctets());
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1OctetString)) {
            return false;
        }
        dERObject = (ASN1OctetString)dERObject;
        return PKCS1Encoding.areEqual(this.string, ((ASN1OctetString)dERObject).string);
    }

    public String toString() {
        return "#" + new String(Hex.encode(this.string));
    }
}

