/*
  TimerJinni - A general timing application
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/L10N.h>
#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Def/Menu.h>
#include <Lum/Def/MultiView.h>

#include <Lum/Dlg/About.h>
#include <Lum/Dlg/Msg.h>
#include <Lum/Dlg/TimeSpanChooser.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>

#include <Lum/OS/Main.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Dialog.h>
#include <Lum/Panel.h>

#include "Configuration.h"

#include "Countdown.h"
#include "Countup.h"

#include "config.h"

static Lum::Def::AppInfo info;

class MainDialog : public Lum::Dialog
{

private:
  Lum::Model::ActionRef aboutAction;

public:
  MainDialog()
  : aboutAction(new Lum::Model::Action())
  {
    Observe(GetOpenedAction());
    Observe(GetClosedAction());
    Observe(aboutAction);
  }

  ~MainDialog()
  {
    // no code
  }

  virtual void PreInit()
  {
    Lum::Def::MultiView multiView(Lum::Def::Desc(L"TimerJinni"));

    Lum::Object *countdown=new Countdown();
    countdown->SetFlex(true,true);

    multiView.AddView(Lum::Def::MultiView::View(0,Lum::Def::Desc(L"Count down"),
                                                countdown));

    Lum::Object *countup=new Countup();
    countup->SetFlex(true,true);

    multiView.AddView(Lum::Def::MultiView::View(0,Lum::Def::Desc(L"Count up"),
                                                countup));

    Lum::Def::Menu *preMenu=Lum::Def::Menu::Create();

    preMenu
      ->GroupProject()
        ->ActionQuit(GetClosedAction())
      ->End();

    Lum::Def::Menu *postMenu=Lum::Def::Menu::Create();

    postMenu
      ->GroupHelp()
        //->ActionHelp()
        ->ActionAbout(aboutAction)
      ->End();

    multiView.SetMenu(preMenu,postMenu);

    Lum::OS::display->GetBehaviour()->ApplyMultiViewDlg(this,multiView);

    Dialog::PreInit();
  }

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==GetOpenedAction() &&
        GetOpenedAction()->IsFinished()) {
      LoadConfig();
    }
    else if (model==GetClosedAction() &&
             GetClosedAction()->IsFinished()) {
      if (configurationChanged && !SaveConfig()) {
        Lum::Dlg::Msg::ShowOk(this,
                              _(L"ERR_CONFIG_SAVE_CAPTION",
                                L"Error while storing configuration..."),
                              _(L"ERR_CONFIG_SAVE_TEXT",
                                L"There was an error while storing the configuration!"));
      }
    }
    else if (model==aboutAction && aboutAction->IsFinished()) {
      Lum::Dlg::About::Show(this,info);
    }

    Dialog::Resync(model,msg);
  }

};

class Main : public Lum::OS::MainDialog<MainDialog>
{
public:
  bool Prepare()
  {
#if defined(APP_DATADIR)
    Lum::Base::Path::SetApplicationDataDir(Lum::Base::StringToWString(APP_DATADIR));
#endif

    info.SetProgram(Lum::Base::StringToWString(PACKAGE_NAME));
    info.SetVersion(Lum::Base::StringToWString(PACKAGE_VERSION));
    info.SetDescription(_(L"ABOUT_DESC",L"How long?"));
    info.SetAuthor(L"Tim Teulings");
    info.SetContact(L"Tim Teulings <tim@teulings.org>");
    info.SetCopyright(L"(c) 2009, Tim Teulings");
    info.SetLicense(L"GNU Public License");

    return Lum::OS::MainDialog<MainDialog>::Prepare();
  }

  void Cleanup()
  {
    Lum::OS::MainDialog<MainDialog>::Cleanup();
  }
};

LUM_MAIN(Main,L"TimerJinni")
