/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef CUSTOMBUTTON_H
#define CUSTOMBUTTON_H

#include <QGraphicsItem>

class CCustomButton : public QObject, public QGraphicsItem
{
    Q_OBJECT

private:
    enum State
    {
        State_Normal,
        State_Pushed,
        State_Hover
    };

public:
    CCustomButton(const QString& strBackground, const QString& strIcon, QPointF iconOffset);
    virtual ~CCustomButton();

    void setIcon(const QString& strIcon);

    QRectF boundingRect() const;
    void paint(QPainter* pPainter, const QStyleOptionGraphicsItem* pOption, QWidget* pWidget);

signals:
    void clicked();

protected:
    virtual void mousePressEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void hoverEnterEvent(QGraphicsSceneHoverEvent* pEvent);
    virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent* pEvent);

private:
    QPixmap m_pxBackground;     ///< The background image
    QPixmap m_pxIcon;           ///< The icon for the button
    State m_State;              ///< The current state of the button
    QPointF m_IconOffset;       ///< The offset for the icon inside the button
};

#endif // CUSTOMBUTTON_H
