/*
A Qt game based on Tic Tac Toe for Maemo
Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "mainwindow.h"
#include "graphicsview.h"

#include <QMainWindow>
#include <QMenu>
#include <QMenuBar>
#include <QAction>
#include <QEvent>
#include <QTimer>

MainWindow::MainWindow ( QWidget* parent ) 
: QMainWindow ( parent )
{
	gv = new GraphicsView(this);
	setCentralWidget(gv);
	
	gv->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	gv->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	gv->show();
	
	QMenu* optionsMenu = new QMenu(this);
	optionsMenu = menuBar()->addMenu(tr("Options"));
	optionsMenu->addAction(tr("Change Level"), this, SLOT(changeLevel()));
// 	optionsMenu->addAction(tr("User Name"), this, SLOT(askUserName()));
	optionsMenu->addAction(tr("Statistics"), this, SLOT(statistics()));
	optionsMenu->addAction(tr("Change Shape"), this, SLOT(changeShape()));
	optionsMenu->addAction(tr("Restart"), this, SLOT(restartGame()));
	
	firstTime = true;
}

MainWindow::~MainWindow()
{
	delete gv;
}

void MainWindow::changeShape()
{
	gv->changeShape();
}

void MainWindow::changeLevel()
{
	gv->changeLevel();
	gv->restartGame();
}

void MainWindow::restartGame()
{
	gv->restartGame();
}

// void MainWindow::askUserName()
// {
// 	gv->askUserName();
// }

void MainWindow::statistics()
{
	gv->statistics();
}

// void MainWindow::showEvent(QShowEvent* event)
// {
// 	if (firstTime && event->type() == QEvent::Show) 
// 	{
// 		QTimer::singleShot(100, this, SLOT(askUserName()));	
// 		firstTime = false;
// 	}
// }

#include "mainwindow.moc"

