#ifndef WEATHERLOGIC_H
#define WEATHERLOGIC_H

#include <QObject>
#include "Description.h"
#include <QSqlRecord>
#include <sstream>
#include <QString>
#include <iostream>
#include "listmodel.h"
#include <QDateTime>

class WeatherElem : public ListItem
{
    Q_OBJECT
public :
    enum WeatherRoles
    {
        weatherNumdayRole = Qt::UserRole + 1,
        weatherNummonthRole,
        weatherNumyearRole,
        weatherNamedayRole,
        weatherNamemonthRole,
        weatherHighttempRole,
        weatherLowtempRole,
        weatherConditionRole,
        weatherCountryRole,
        weatherCityRole,
        weatherIdRole
    };
    WeatherElem(QObject *p = 0);
    WeatherElem(int, int, int, QString, QString, int, int, QString, QString, QString,QObject *p = 0);

    //INHERITED FROM LISTITEM
    int id() const;
    QVariant data(int role) const;
    QHash<int, QByteArray> roleNames() const;
    /////////////////////////
    int getnumday() const;
    int getnummonth()const;
    int getnumyear()const;
    QString getnameday()const;
    QString getnamemonth()const;
    int gethighttemp()const;
    int getlowtemp()const;
    QString getconditions()const;
    QString getcountry()const;
    QString getcity()const;
    int getweatherId()const;
    void setnumday(int);
    void setnummonth(int);
    void setnumyear(int);
    void setnameday(QString);
    void setnamemonth(QString);
    void sethighttemp(int);
    void setlowtemp(int);
    void setconditions(QString);
    void setcountry(QString);
    void setcity(QString);
    void setweatherId(int);
private:
    int numday;
    int nummonth;
    int numyear;
    QString nameday;
    QString namemonth;
    int highttemp;
    int lowtemp;
    QString conditions;
    QString country;
    QString city;
    int weatherId;
    static int nextId;
};


class WeatherLocationElem : public ListItem
{
    Q_OBJECT
public :
    enum WeatherLocationRoles
    {
        weatherLocationCountryRole = Qt::UserRole + 1,
        weatherLocationCityRole,
        weatherLocationIdRole
    };
    WeatherLocationElem(QObject *p = 0);
    WeatherLocationElem(QString, QString, QString, QObject *p = 0);

    //INHERITED FROM LISTITEM
    int id() const;
    QVariant data(int role) const;
    QHash<int, QByteArray> roleNames() const;
    /////////////////////////

    QString getcountry()const;
    QString getcity()const;
    int getweatherLocationId()const;
    QString getIdtime() const;
    void setcountry(QString);
    void setcity(QString);
    void setweatherLocationId(int);
private:
    QString country;
    QString city;
    QString idtime;
    int weatherLocationId;
    static int nextId;
};

class weatherlogic : public QObject
{
    Q_OBJECT
public:
    weatherlogic(QObject *parent = 0);
    void LoadweatherFromDB();
    void LoadWeatherLocation();
    void setWeatherDay(int, int, int, QString, QString, int, int, QString, QString, QString);
    void deleteDBday(QString country, QString city);
    void LoadWeatherfromDB(QString city, QString country);
    void deleteWeatherFromListView();
    void deleteWeatherLocationFromListView();
    void deleteWeatherLocationfromDb(QString country, QString city);
    void addWeatherLocation(QString country, QString city);
    ListModel *getWeatherModel();
    ListModel *getWeatherLocationModel();
private:
     ListModel *weatherMod;
     ListModel *weatherLocationMod;
signals:
    void SendQueryW(QString query, int);
public slots:
    void rcvW(QList<QSqlRecord>, int);
};

#endif // WEATHERLOGIC_H
