import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtWebKit 1.0

Item
{
    id: web_item
    property alias title : web.title;
    property alias url : web.url;
    property int mobileView;
    property bool fullscreen : false;
    property bool errorLoad : false;

    signal addBookMark(string s_url, string s_title);
    signal webMinimized


    Rectangle
    {
        color : tepee.elemBackColor
        opacity : tepee.elemBackOpacity
        anchors.fill : parent
        border.color: "white"
        border.width : 1
        radius : 15
    }

    // QUIT BUTTON
    Rectangle
    {
        Image
        {
            id : close_img
            anchors.centerIn: parent
            source: "ui_svg/close.png"
            smooth: true
            scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
        }
        id : close_button
        color : "transparent"
        scale : close_button_ma.pressed ? 0.9 : 1
        width : tepee.mobileRes / 2
        height : tepee.mobileRes / 2
        anchors
        {
            left : add_book_rec.right
            top : web_item.top
            topMargin : tepee.mobileRes / 6
            leftMargin : tepee.mobileRes / 3
        }
        MouseArea
        {
            id : close_button_ma
            anchors.fill: parent
            onClicked:
            {
                webMinimized();
            }
        }
    }


    // FULL BUTTON
    Rectangle
    {
        Image
        {
            id : full_book_img
            anchors.centerIn: parent
            source: (fullscreen) ? "ui_svg/minimize.png" : "ui_svg/maximize.png"
            smooth: true
            scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
        }
        id : full_switch
        color : "transparent"

        scale: full_mouse_area.pressed ? 0.9 : 1
        width : tepee.mobileRes / 2
        height : tepee.mobileRes / 2
        anchors
        {
            left : in_area.right
            top : web_item.top
            topMargin : tepee.mobileRes / 6
            leftMargin : tepee.mobileRes / 3
        }
        MouseArea
        {
            id : full_mouse_area
            anchors.fill: parent
            onClicked: {fullscreen = !fullscreen;}
        }
    }
    // ADD BUTTON
    Rectangle
    {
        Image
        {
            id : add_book_img
            anchors.centerIn: parent
            source: "ui_svg/add.png"
            smooth: true
            scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
        }
        id : add_book_rec
        width : tepee.mobileRes / 2
        height : tepee.mobileRes / 2
        color : "transparent"
        scale: add_mouse_area.pressed ? 0.9 : 1
        anchors
        {
            left : full_switch.right
            top : web_item.top
            //            bottom : in_area.bottom
            topMargin : tepee.mobileRes / 6
            leftMargin : tepee.mobileRes / 3
        }
        MouseArea
        {
            id : add_mouse_area
            anchors.fill: parent
            onClicked: {addBookMark(web.url, web.title)}
        }
    }

    // BACK BUTTON
    Rectangle
    {
        Image
        {
            id : back_book_img
            anchors.centerIn: parent
            source: "ui_svg/arrow_left.png";
            smooth: true
            scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
        }

        id : back_book_rec
        scale: back_mouse_area.pressed ? 0.9 : 1
        width : tepee.mobileRes / 1.5
        height : tepee.mobileRes / 1.5
        color : "transparent"

        anchors
        {
            left : web_item.left
            top : web_item.top
            topMargin : tepee.mobileRes / 9
            leftMargin : tepee.mobileRes / 5
        }
        MouseArea
        {
            id : back_mouse_area
            anchors.fill: parent
            onClicked: {web.back.trigger()}
        }
    }
    // FORWARD BUTTON
    Rectangle
    {
        Image
        {
            id : forward_book_img
            anchors.centerIn: parent
            source: "ui_svg/arrow_right.png";
            smooth: true
            scale: (tepee.mobileRes == 139) ? 1 : (tepee.mobileRes == 80) ? 0.8 : 0.6
        }
        id : forward_book_rec
        scale: forward_mouse_area.pressed ? 0.9 : 1
        width : tepee.mobileRes / 1.5
        height : tepee.mobileRes / 1.5
        color : "transparent"
        anchors
        {
            left : back_book_rec.right
            top : web_item.top
            topMargin : tepee.mobileRes / 9
            leftMargin : tepee.mobileRes / 5
        }
        MouseArea
        {
            id : forward_mouse_area
            anchors.fill: parent
            onClicked: {web.forward.trigger();}
        }
    }

    // WHITE FONT FOR INPUT
    Rectangle
    {
        id : in_area
        color : web_item.errorLoad ? "red" : "#E0E0E0"
        opacity : 0.8
        radius : 5
        smooth : true
        x : 2 * tepee.mobileRes
        y : tepee.mobileRes / 4
        height : tepee.mobileRes / 3
        width : (parent.width - (5 * tepee.mobileRes))
    }
    // PROGRESS BAR
    Rectangle
    {
        color : "#44A51C"
        Behavior on opacity {NumberAnimation {duration : 250}}
        opacity : (web.progress == 1) ? 0 : 0.8
        radius : 5
        smooth : true
        x : in_area.x
        y : in_area.y
        height :in_area.height
        width : web.progress * in_area.width
    }
    // URL INPUT
    TextInput
    {
        id : url_input
        horizontalAlignment: TextEdit.AlignLeft
        text : web.url
        color : "black"
        font.pixelSize: in_area.height - 4
        //        onTextChanged:
        onAccepted:
        {
            var str = text;
            console.log("sub = " + str.substring(0, 7));
            if (str.substring(0, 7) != "http://")
                web.url = "http://" + text;
            else
                web.url = text;
        }

        anchors
        {
            left : in_area.left
            right : in_area.right
            verticalCenter : in_area.verticalCenter
            leftMargin : tepee.mobileRes / 4
            rightMargin : tepee.mobileRes / 4
        }
    }
    // VALIDATE BUTTON
    Rectangle
    {
        Image
        {
            id : validate_book_img
            anchors.centerIn: parent
            source: "ui_svg/search.png";
            smooth: true
            scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
        }
        id : validate_book_rec
        width : tepee.mobileRes / 2 //1.5
//        height : tepee.mobileRes / 1.5
        color : "transparent"
        scale : validate_ma.pressed ? 0.9 : 1
        anchors
        {
            right : in_area.right
            top : url_input.top
            bottom : url_input.bottom
        }
        MouseArea
        {
            id : validate_ma
            anchors.fill: parent
            onClicked:
            {
                url_input.accepted();
            }
        }
    }


    // WEB_VIEW
    Flickable
    {
        id : webview_flick
        anchors.fill: parent
        anchors.topMargin: tepee.mobileRes * 4 / 5
        anchors.bottomMargin: tepee.mobileRes / 8
        anchors.leftMargin: 2
        anchors.rightMargin: 2
        contentWidth : web.width
        contentHeight: web.height
        clip : true;
        boundsBehavior: Flickable.StopAtBounds

        WebView
        {
            id : web
            preferredWidth :  main_win_rec.width - (2 * mobileView)
            preferredHeight:  main_win_rec.height - (2 * mobileView)
            url : checkUrl(web.url)

            function checkUrl(url)
            {
                return (url);
            }

            onLoadStarted : web_item.errorLoad = false;
            onLoadFailed: web_item.errorLoad = true;
//            onDoubleClick: {web_item.webMinimized();}
        }

        states:
            [
            State
            {
                name: "ShowBarsWeb"
                when: webview_flick.movingVertically || webview_flick.movingVertically
                PropertyChanges { target: verticalScrollBarWeb; opacity: 1 }
                PropertyChanges { target: horizontalScrollBarWeb; opacity: 1}
            }
        ]
    }

    states:
        State   {
        name : "full_web"
        when : web_item.fullscreen
        PropertyChanges {
            target: web_item;
            width : main_win_rec.width;
            height : main_win_rec.height;
            x : -tepee.mobileRes
            y : -tepee.mobileRes
        }
    }

    transitions: Transition {
        NumberAnimation { target: web_item; property: "height"; duration: 250 }
        NumberAnimation { target: web_item; property: "width"; duration: 250 }
        NumberAnimation { target: web_item; property: "x"; duration: 250 }
        NumberAnimation { target: web_item; property: "y"; duration: 250 }
    }
    ScrollBar
    {
        id: verticalScrollBarWeb
        width: 12; height: webview_flick.height-12
        anchors.right: webview_flick.right
        anchors.top: webview_flick.top
        opacity: 0
        orientation: Qt.Vertical
        position: webview_flick.visibleArea.yPosition
        pageSize: webview_flick.visibleArea.heightRatio
    }

    ScrollBar
    {
        id: horizontalScrollBarWeb
        width: webview_flick.width-12; height: 12
        anchors.bottom: webview_flick.bottom
        opacity: 0
        orientation: Qt.Horizontal
        position: webview_flick.visibleArea.xPosition;
        pageSize: webview_flick.visibleArea.widthRatio
    }
}
