#ifndef NOTELOGIC_H
#define NOTELOGIC_H

#include <QDateTime>
#include <QString>
#include <QList>
#include <QObject>
#include <QMetaType>
#include <QAbstractListModel>
#include <QHash>
#include <QByteArray>
#include "Description.h"
#include "listmodel.h"
#include <QSqlRecord>
#include <iostream>
#include <sstream>

class NoteElem : public ListItem
{
    Q_OBJECT
public :
    enum NoteRoles
    {
        titleRole = Qt::UserRole + 1,
        contentRole,
        idRole
    };

    NoteElem(QObject *p = 0);
    NoteElem(QString title, QString content, QString,  QObject *parent = 0);

    // INHEITED METHODES
    int id() const;
    QVariant data(int role) const;
    QHash<int, QByteArray> roleNames() const;
    //////////////////////////////////////////

    QString getNoteTitle() const;
    QString getNoteContent() const;
    QString getIdTime() const;
    int getNoteId() const;
    void setNoteTitle(QString);
    void setNoteContent(QString);
private :
    static int nextId;

    int noteId;
    QString noteTitle;
    QString noteContent;
    QString idTime;
};


Q_DECLARE_METATYPE(QList<NoteElem *>)

class NoteLogic : public QObject
{
    Q_OBJECT
private :
    ListModel   *notesMod;
public:

    explicit            NoteLogic();
    ListModel*          getNotesModel();
    bool                addNote(QString, QString);
    void                editNote(QString title, QString content, int id);
    void                removeNote(int id);
    void LoadNote();
signals:
     void SendQueryNote(QString query, int);
public slots:
     void rcvNote(QList<QSqlRecord>, int);
};


#endif // NOTELOGIC_H
