import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtMobility.location 1.2
//import QtMobility.contacts 1.1

Rectangle
{
    id: main_win_rec
    width: 1680
    height: 1050
    focus : true

    property string username;  //Properties are set in SettingsMenu
    property string passwd;



    //Define all properties for configuration here

    function    synchingProgress(progress) // SLOT TRIGGERED WHEN SYNCHING PROGRESSES
    {
        tepee.synchingProgress(progress);
    }

    function openSettingsMenu()
    {
        tepee.checkLoadedSettingsMenu();
        tepee.state = "Setting State";
        tepee.clearSelection();
        console.log("OPENING SETTINGS MENU");
    }

    Keys.onPressed : {console.log(event.key + "was pressed");
        if (event.key == Qt.Key_Escape)  Qt.quit();}
    // Component.onCompleted: console.log("Plateform : " + main_win_rec.plateform)

    Background
    {
        id : tepee
        Timer
        {
            id : firstConnectCheckTimer;
            interval : 5000;
            running : false;
            repeat : false;
            onTriggered:
            {
                if (!apCtrl.getSettingSet())
                    openSettingsMenu();
                apCtrl.checkSetting();
                tepee.backgroundImg =(apCtrl.getBackGround() == "") ? "Buttons/Wallpaper.JPG" : apCtrl.getBackGround()
                tepee.elemBackColor = apCtrl.getStyleColor();
                tepee.elemBackOpacity = apCtrl.getStyleOpacity();
            }
        }

        Component.onCompleted:
        {

            firstConnectCheckTimer.start();
        }
    }

    InitRect
    {
        id : titi
        Component.onCompleted : opacity = 0
    }
}

