import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Item
{
    property int mobileView
    id : timeBar;
    y : main_win_rec.height - buttonSettings.height;
    Component.onCompleted: {buttonSettings.opacity = 1; buttonEvents.opacity = 1; shadowBar2.opacity = 0.70}

//    function getLocalTime()
//    {
//        var d = new Date();
//        var s = d.getSeconds();
//        var m = d.getMinutes();
//        var time = d.getHours() + ":" +  ((m < 10) ? ("0" + m) : m) + ":" + ((s < 10) ? ("0" + s) : s);
//        return (time);
//    }

    WorkerScript
    {
        id : timeWorker;
        source : "workerscriptTime.js"
        onMessage : {timeText.text = messageObject.time}
    }

    Rectangle
    { id : shadowBar2; color : "#000000"; opacity: 0;
        Behavior on opacity {SequentialAnimation{PauseAnimation {duration : (buttonEvents.numId + 1) * 500} NumberAnimation {duration : 1000}}}
        width : buttonEvents.x - buttonSettings.x ;
        height: buttonSettings.height / 3;
        x : buttonSettings.x + buttonSettings.width / 2;  y : (buttonSettings.height - shadowBar2.height) - buttonSettings.width / 7;
        Timer
        {
            interval: 1000; running: true; repeat: true;
            onTriggered: timeWorker.sendMessage({});
        }
        Text
        {
            id : timeText; color:"white";
            font.pointSize: (mobileView == 139) ? 15 : (mobileView == 80) ? 12 : 4;
            anchors.centerIn: parent;
        }
    }
    Button
    {
        id : buttonSettings; buttonColor: "red"; buttonShape:  "round"
        anchors.left: parent.left; anchors.leftMargin: (main_win_rec.width - (6 * buttonSettings.width + 5 * 38)) / 2;
        numId: 7; text: "Settings"; resImg: mobileView; clickActionState: "Setting State"
        onButtonClicked:
        {
            menu_settings.source = "SettingsMenu.qml"
            background_rect.state = clickActionState;
            background_rect.clearSelection();
        }
    }
    Button
    {
        id : buttonEvents; buttonColor: "blue"; buttonShape: "round"
        anchors.left: parent.left; anchors.leftMargin: (main_win_rec.width - (6 * buttonEvents.width + 5 * 38)) / 2 + 5 * (buttonEvents.width + 38);
        numId: 8; text: "Events"; resImg: mobileView; clickActionState: "Event State"
        onButtonClicked:
        {
            event_win.source = "Events.qml";
            background_rect.state = clickActionState;
            background_rect.clearSelection();
        }
    }
}
