// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import Qt.labs.folderlistmodel 1.0

Rectangle
{
    id : parent_elem
    property string filename_del : filePath
    Behavior on scale {NumberAnimation {duration : 55}}
    color : "transparent"
    scale : elem_ma.pressed ? 0.9 : 1
    Rectangle
    {
        id : back_rec
        anchors.fill: parent
        gradient :
            Gradient    {
            GradientStop {position : 0.0; color : "darkgrey"}
            GradientStop {position : 1.0; color : "black"}
        }
        opacity : 0.7
        smooth : true
        radius : 15
        border.color : "grey"
        border.width: 1
    }
    Text
    {
        anchors.centerIn: parent
        text : fileName
        color : "white"
        font.pointSize: (tepee.mobileRes == 139) ? 25 : (tepee.mobileRes == 80) ? 16 : 7
    }
    Image
    {
        source : "ui_svg/arrow.svg";
        width : tepee.mobileRes
        height : parent.height
        anchors.right: parent.right
        smooth : true
        anchors.rightMargin: tepee.mobileRes / 4
    }

    MouseArea
    {
        id : elem_ma
        anchors.fill: parent
        onClicked:
        {
            folder_model.folder = filename_del;
        }
    }
}
