// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle
{
    property string filename_del : loader_elem.getFilename();
    property bool showPic : loader_elem.getShowPic();

    function checkForPicExtension(name)
    {
        var str = new String(name);
        if (str.search(".*\.((png)|(jpg)|(PNG)|(JPG))") !== -1)
            return (name);
        return "";
    }

    color : "transparent"
    scale : elem_ma.pressed ? 0.9 : 1
    Rectangle
    {
        id : back_rec
        gradient :
            Gradient    {
            GradientStop {position : 0.0; color : "darkgrey"}
            GradientStop {position : 1.0; color : "black"}
        }
        opacity : 0.7
        radius : 15
        smooth : true
        anchors.fill: parent
    }
    Text
    {
        anchors.centerIn: parent
        text :filename_del
        color : "white"
        font.pointSize: (mobileView == 139) ? 15 : (mobileView == 80) ? 12 : 4
    }
    Rectangle
    {
        property string img_src : (showPic) ? checkForPicExtension(filePath) : "";
        width : tepee.mobileRes / 2
        height : tepee.mobileRes / 2
        anchors.verticalCenter: parent.verticalCenter
        anchors.right : parent.right
        anchors.rightMargin: tepee.mobileRes / 2
        border
        {
            width : (showPic) ? 2 : 0
            color : "grey"
        }
        color : "transparent"
        Image
        {
            width : tepee.mobileRes / 2
            height : tepee.mobileRes / 2
            asynchronous: true
            anchors.fill: parent
            source: parent.img_src;
        }
    }
    MouseArea
    {
        id : elem_ma
        anchors.fill: parent
        onClicked :
        {
            // GET NAME OF SELECTED FILE
            browser_item.selected_name = filePath;
        }
    }
}

