#include "bookmarklogic.h"
#include <iostream>

int BookMarkElem::nextId = 0;

BookMarkElem::BookMarkElem(QObject *p) : ListItem(p)
{
    this->bookTitle = "";
    this->bookAddr = QUrl("");
    this->bookId = BookMarkElem::nextId++;
}

BookMarkElem::BookMarkElem(QString title, QString addr, QString time, QObject *p) : ListItem(p)
{
    this->bookTitle = title;
    this->bookAddr = QUrl(addr);
    this->idTime = time;
    this->bookId = BookMarkElem::nextId++;
}

QString BookMarkElem::getIdTime() const
{
    return this->idTime;
}

QUrl BookMarkElem::getBookAddr() const
{
    return (this->bookAddr);
}

QString BookMarkElem::getBookTitle() const
{
    return (this->bookTitle);
}

int     BookMarkElem::id() const
{
    return (this->bookId);
}

void    BookMarkElem::setBookAddr(QString a)
{
    this->bookAddr = QUrl(a);
    std::cout << "NEW URL " << this->bookAddr.toString().toStdString() << std::endl;

}

void    BookMarkElem::setBookTitle(QString a)
{
    this->bookTitle = a;
}

QHash<int, QByteArray> BookMarkElem::roleNames() const
{
    QHash<int, QByteArray> roles;
    roles[bookTitleRole] = "bookMarkTitle";
    roles[bookAddrRole] = "bookMarkAddr";
    roles[bookIdRole] = "bookId";
    return roles;
}

QVariant BookMarkElem::data(int role) const
{
    switch(role)
    {
    case bookTitleRole :
        return this->getBookTitle();
    case bookAddrRole :
        return this->getBookAddr();
    case bookIdRole :
        return this->id();
    default :
        return QVariant();
    }
}

void BookMarkLogic::rcvBM(QList<QSqlRecord> q, int i)
{
    if (i == FILLBM)
    {
        std::cout << "CLEARIG BOOK MODEL" << std::endl;
        this->bookMarksMod->removeRows(0, this->bookMarksMod->rowCount());
        this->bookMarksMod->appendRow(new BookMarkElem("new_elem_@", "http://www.google.com", QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz"),  this->bookMarksMod));
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        while (it != q.end())
        {
            if ((*it).value("status").toInt() != DEL)
                this->bookMarksMod->appendRow(new BookMarkElem((*it).value("title").toString(), (*it).value("adress").toString(), (*it).value("id").toString(),this->bookMarksMod));
            ++it;
        }
    }
    this->QL = q;
}

void BookMarkLogic::LoadBMfromDB()
{
    QString t = "SELECT * FROM bookmark";
    emit(SendQueryBM(t, FILLBM));
}

BookMarkLogic::BookMarkLogic(QObject *parent) :
    QObject(parent)
{
    this->bookMarksMod = new ListModel(new BookMarkElem);
    this->bookMarksMod->appendRow(new BookMarkElem("new_elem_@", "http://www.epitech.eu", QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz"),  this->bookMarksMod));
}

ListModel *BookMarkLogic::getBookMarksModel()
{
    return (this->bookMarksMod);
}


bool    BookMarkLogic::addBookMark(QString title, QString addr)
{
    QString query;
    QString times = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");

    query = "INSERT INTO bookmark (id, lastup, title, adress, status) VALUES ('";
    query += times;
    query += "','";
    query += times;
    query += "','";
    query += title;
    query += "', '";
    query += addr;
    query += "', ";
    query += QString::number(MODIF);
    query += ");";
    emit (SendQueryBM(query, ADDBM));
    this->bookMarksMod->appendRow(new BookMarkElem(title, addr, times));
    return (true);
}

void    BookMarkLogic::editBookMark(QString title, QString addr, int id)
{
    BookMarkElem *b = (BookMarkElem *)this->bookMarksMod->find(id);
    if (b == NULL)
        return ;
    QString query = "UPDATE bookmark SET title ='";
    query += title;
    query += "', lastup ='";
    query += QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
    query += "' , adress = '";
    query +=  addr;
    query += "', status = ";
    query += QString::number(MODIF);
    query += " WHERE id = '";
    query += b->getIdTime();
    query += "' AND status != ";
    query += QString::number(DEL);
    emit (SendQueryBM(query, ADDBM));
    b->setBookAddr(addr);
    b->setBookTitle(title);

    this->bookMarksMod->updateModelFromElem(b);
}

void    BookMarkLogic::removeBookMark(int id)
{
    ListItem *b = (ListItem *)this->bookMarksMod->find(id);
    if (b == NULL)
        return ;
    int row = this->bookMarksMod->getRowFromItem(b);
    if  (row > -1)
    {
        BookMarkElem *e = (BookMarkElem *)this->bookMarksMod->find(id);
        QString query;
        query = "UPDATE bookmark SET status =";
        query += QString::number(DEL);
        query += ", lastup ='";
        query += QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "' WHERE id = '";
        query += e->getIdTime();
        query += "'";
        emit (SendQueryBM(query, ADDBM));
        this->bookMarksMod->removeRow(row);
    }
}
