#include "weatherlogic.h"

int WeatherElem::nextId = 0;
int WeatherLocationElem::nextId = 0;

WeatherElem::WeatherElem(QObject *p) : ListItem(p)
{
    this->numday = 0;
    this->nummonth = 0;
    this->numyear = 0;
    this->nameday = "";
    this->namemonth= "";
    this->highttemp = 0;
    this->lowtemp = 0;
    this->conditions = "";
    this->country = "";
    this->city = "";
    this->weatherId = WeatherElem::nextId++;
}

WeatherLocationElem::WeatherLocationElem(QObject *p) : ListItem(p)
{
    this->country = "";
    this->city = "";
    this->weatherLocationId = WeatherLocationElem::nextId++;
}

void weatherlogic::rcvW(QList<QSqlRecord> q, int i)
{
    if (i == ASKWEATHER)
    {
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        while (it != q.end())
        {
            if ((*it).value("country").toString().toStdString().size() > 0 && (*it).value("city").toString().toStdString().size() > 0)
                this->weatherMod->appendRow(new WeatherElem((*it).value("numday").toInt(), (*it).value("nummonth").toInt(), (*it).value("numyear").toInt(), (*it).value("nameday").toString(),  (*it).value("namemonth").toString(), (*it).value("highttemp").toInt(), (*it).value("lowtemp").toInt(), (*it).value("conditions").toString(),  (*it).value("country").toString(), (*it).value("city").toString()));
            ++it;
        }
    }
    if (i == ASKWEATHERLOCATION)
    {
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        this->weatherLocationMod->removeRows(0, this->weatherLocationMod->rowCount());
        this->weatherMod->removeRows(0, this->weatherMod->rowCount());
        while (it != q.end())
        {
            if ((*it).value("country").toString().toStdString().size() > 0 && (*it).value("city").toString().toStdString().size() > 0)
            {
                std::cout <<"RCV add city " <<  (*it).value("city").toString().toStdString() << std::endl;
                this->weatherLocationMod->appendRow(new WeatherLocationElem((*it).value("country").toString(), (*it).value("city").toString(), (*it).value("id").toString()));
            }
            ++it;
        }
    }
}

void weatherlogic::setWeatherDay(int numday , int nummonth, int numyear , QString nameday, QString namemonth, int highttemp, int lowtemp, QString conditions, QString country, QString city)
{
    QString  query = "INSERT INTO weather ( numday, nummonth, numyear , nameday, namemonth, highttemp, lowtemp, conditions, country, city) VALUES (";
    query += QString::number(numday).toStdString().c_str();
    query += " , ";
    query += QString::number(nummonth).toStdString().c_str();
    query += " , ";
    query += QString::number(numyear).toStdString().c_str();
    query += " ,' ";
    query += nameday.toStdString().c_str();
    query += "', '";
    query += namemonth.toStdString().c_str();
    query += " ', ";
    query += QString::number(highttemp).toStdString().c_str();
    query += " , ";
    query += QString::number(lowtemp).toStdString().c_str();
    query += " , '";
    query += conditions.toStdString().c_str();
    query += "', '";
    query += country.toStdString().c_str();
    query += "', '";
    query += city.toStdString().c_str();
    query += "')";

    if (this->weatherMod->rowCount() > 0)
        this->weatherMod->removeRows(0, this->weatherMod->rowCount());
    emit(SendQueryW(query, SETWEATHER));
}

void weatherlogic::deleteDBday(QString country, QString city)
{
    QString  query = "DELETE FROM weather WHERE country = '";
    query += country.toStdString().c_str();
    query += "' AND city = '";
    query += city.toStdString().c_str();
    query += "'";
    emit(SendQueryW(query, SETWEATHER));
}


void weatherlogic::LoadWeatherfromDB(QString city, QString country)
{
    std::cout << "LOAD WEATHER " << std::endl;
    QString query = "SELECT * FROM weather WHERE city = '";
    query += city.toStdString().c_str();
    query += "' AND country = '";
    query += country.toStdString().c_str();
    query += "';";
    emit(SendQueryW(query, ASKWEATHER));
}

WeatherElem::WeatherElem(int numdayw , int nummonthw, int numyearw , QString namedayw, QString namemonthw, int highttempw, int lowtempw, QString conditionsw, QString countryw, QString cityw,  QObject *p) : ListItem(p)
{
    this->numday = numdayw;
    this->nummonth = nummonthw;
    this->numyear = numyearw;
    this->nameday = namedayw;
    this->namemonth = namemonthw;
    this->highttemp = highttempw;
    this->lowtemp = lowtempw;
    this->conditions = conditionsw;
    this->country = countryw;
    this->city = cityw;
    this->weatherId = WeatherElem::nextId++;
}

WeatherLocationElem::WeatherLocationElem(QString countryw, QString cityw, QString t,  QObject *p) : ListItem(p)
{
    this->country = countryw;
    this->city = cityw;
    this->idtime = t;
    this->weatherLocationId = WeatherLocationElem::nextId++;
}

QString WeatherLocationElem::getIdtime() const
{
    return this->idtime;
}
int WeatherElem::getnumday() const
{
    return this->numday;
}

int WeatherElem::getnummonth() const
{
    return this->nummonth;
}

int WeatherElem::getnumyear() const
{
    return this->numyear;
}

QString WeatherElem::getnameday() const
{
    return this->nameday;
}

QString WeatherElem::getnamemonth()const
{
    return this->namemonth;
}

int WeatherElem::gethighttemp()const
{
    return this->highttemp;
}

int WeatherElem::getlowtemp()const
{
    return this->lowtemp;
}

QString WeatherElem::getconditions()const
{
    return this->conditions;
}

QString WeatherElem::getcountry()const
{
    return this->country;
}

QString WeatherElem::getcity()const
{
    return this->city;
}

QString WeatherLocationElem::getcountry()const
{
    return this->country;
}

QString WeatherLocationElem::getcity()const
{
    return this->city;
}

int WeatherElem::getweatherId()const
{
    return this->weatherId;
}

int WeatherLocationElem::getweatherLocationId()const
{
    return this->weatherLocationId;
}

void WeatherElem::setnumday(int a)
{
    this->numday = a;
}

void WeatherElem::setnummonth(int a)
{
    this->nummonth = a;
}

void WeatherElem::setnumyear(int a)
{
    this->numyear = a;
}

void WeatherElem::setnameday(QString a)
{
    this->nameday = a;
}

void WeatherElem::setnamemonth(QString a)
{
    this->namemonth = a;
}

void WeatherElem::sethighttemp(int a)
{
    this->highttemp = a;
}

void WeatherElem::setlowtemp(int a)
{
    this->lowtemp = a;
}

void WeatherElem::setconditions(QString a)
{
    this->conditions = a;
}

void WeatherElem::setcountry(QString a)
{
    this->country = a;
}

void WeatherElem::setcity(QString a)
{
    this->city = a;
}

void WeatherLocationElem::setcountry(QString a)
{
    this->country = a;
}

void WeatherLocationElem::setcity(QString a)
{
    this->city = a;
}

void WeatherLocationElem::setweatherLocationId(int a)
{
    this->weatherLocationId = a;

}

void WeatherElem::setweatherId(int a)
{
    this->weatherId = a;

}

weatherlogic::weatherlogic(QObject *parent) :
    QObject(parent)
{
    this->weatherMod = new ListModel(new WeatherElem);
    this->weatherLocationMod = new ListModel(new WeatherLocationElem);
}

ListModel *weatherlogic::getWeatherModel()
{
    return (this->weatherMod);
}

QHash<int, QByteArray> WeatherElem::roleNames() const
{
    QHash<int, QByteArray> roles;
    roles[weatherNumdayRole] = "weatherNumday";
    roles[weatherNummonthRole] = "weatherNummonth";
    roles[weatherNumyearRole] = "weatherNumyear";
    roles[weatherNamedayRole] = "weatherNameday";
    roles[weatherNamemonthRole] = "weatherNamemonth";
    roles[weatherHighttempRole] = "weatherHighttemp";
    roles[weatherLowtempRole] = "weatherLowtemp";
    roles[weatherConditionRole] = "weatherCondition";
    roles[weatherCountryRole] = "weatherCountry";
    roles[weatherCityRole] = "weatherCity";
    roles[weatherIdRole] = " weatherId";
    return roles;
}

QVariant WeatherElem::data(int role) const
{
    switch(role)
    {
    case  weatherNumdayRole :
        return this->getnumday();
    case weatherNummonthRole :
        return this->getnummonth();
    case weatherNumyearRole :
        return this->getnumyear();
    case weatherNamedayRole :
        return this->getnameday();
    case weatherNamemonthRole :
        return this->getnamemonth();
    case weatherHighttempRole :
        return this->gethighttemp();
    case weatherLowtempRole :
        return this->getlowtemp();
    case weatherConditionRole :
        return this->getconditions();
    case weatherCountryRole :
        return this->getcountry();
    case weatherCityRole :
        return this->getcity();
    case weatherIdRole :
        return this->getweatherId();
    default :
        return QVariant();
    }
}

int     WeatherElem::id() const
{
    return (this->weatherId);
}

ListModel *weatherlogic::getWeatherLocationModel()
{
    return (this->weatherLocationMod);
}

QHash<int, QByteArray> WeatherLocationElem::roleNames() const
{
    QHash<int, QByteArray> roles;
    roles[weatherLocationCountryRole] = "weatherLocationCountry";
    roles[weatherLocationCityRole] = "weatherLocationCity";
    roles[weatherLocationIdRole] = "weatherLocationId";
    return roles;
}

QVariant WeatherLocationElem::data(int role) const
{
    switch(role)
    {

    case weatherLocationCountryRole :
        return this->getcountry();
    case weatherLocationCityRole :
        return this->getcity();
    case weatherLocationIdRole :
        return this->getweatherLocationId();
    default :
        return QVariant();
    }
}

int     WeatherLocationElem::id() const
{
    return (this->weatherLocationId);
}

void weatherlogic::LoadWeatherLocation()
{
    QString query = "SELECT * from locationweather WHERE status != 3";
    emit(SendQueryW(query, ASKWEATHERLOCATION));
}

void weatherlogic::deleteWeatherFromListView()
{
    if (this->weatherMod->rowCount() > 0)
        this->weatherMod->removeRows(0, this->weatherMod->rowCount());
}

void weatherlogic::deleteWeatherLocationFromListView()
{
    if (this->weatherLocationMod->rowCount() > 0)
        this->weatherLocationMod->removeRows(0, this->weatherLocationMod->rowCount());
}

void weatherlogic::deleteWeatherLocationfromDb(QString country, QString city)
{
    QString  query = "UPDATE locationweather SET status =" ;
    query += QString::number(DEL);
    query += ", lastup = '";
    query += QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
    query += "' WHERE country = '";
    query += country;
    query += "' AND city = '";
    query += city;
    query += "'";
    emit(SendQueryW(query, SETWEATHER));
}

void    weatherlogic::addWeatherLocation(QString country, QString city)
{
    std::cout << "IN WEATHER LOGIC ADD" << std::endl;
    QString time = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
    QString query = "INSERT INTO locationweather (id, lastup, country, city, status) VALUES ('";
    query += time;
    query += "','";
    query += time;
    query += "','";
    query += country;
    query += "','";
    query += city;
    query += "',";
    query += QString::number(MODIF);
    query += ")";
    emit (SendQueryW(query, SETWEATHER));
}
