#ifndef DESCRIPTION_H
#define DESCRIPTION_H

enum headerType
{
    HEADERNOTE = 1,
    HEADERFILE ,
    HEADERCONTACT,
    HEADERBOOKMARK,
    HEADERAGENDA,
    HEADERWEATHER,
    HEADERSETTING,
    HEADEREVENT,
    HEADERSYS,
    HEADERTASK,
    // BM
    FILLBM,
    ADDBM,
    // CONTACT
    FILLCONTACT,
    SETCONTACT,
    // NOTE
    FILLNOTE,
    SETNOTE,
    // SETTINGS
    ASKSETTINGCONF,
    SETSETTING,
    // USER INFO
    FILLUSERINFO,
    SETUSERINFO,
    // WEATHER
    ASKWEATHER,
    SETWEATHER,
    ASKWEATHERLOCATION,
    // TASK
    ASKTASK,
    SETTASK,
    // EVENT
    SETEVENT,
    FILLEVENT,
    ASKCONTACTEVENT
    // EVENT

};

enum IdCmdSystem
{
    ASKCONNECTION = 1,
    ANSWERCONNECTION,
    ASKSYNC,
    ASKBOOKMARK,
    ANSWERASKBOOKMARK,
    ADDBOOKMARK,
    DELBOOKMARK,
    UPDATEBOOKMARK,
    ENDBOOKMARK,

    ASKNOTE,
    ANSWERASKNOTE,
    ADDNOTE,
    DELNOTE,
    UPDATENOTE,
    ENDNOTE,

    ASKCONTACT,
    ANSWERASKCONTACT,
    ADDCONTACT,
    DELCONTACT,
    UPDATECONTACT,
    ENDCONTACT,

    ASKAGENDA,
    ANSWERASKAGENDA,
    ADDAGENDA,
    DELAGENDA,
    UPDATEAGENDA,
    ENDAGENDA,

    ASKWEATHERLOC,
    ANSWERASKWEATHERLOC,
    ADDWEATHERLOC,
    DELWEATHERLOC,
    UPDATEWEATHERLOC,
    ENDWEATHERLOC,

    ASKSETTING,
    ANSWERSETTING,
    ADDSETTING,
    DELSETTING,
    UPDATESETTING,
    ENDSETTING,

    ASKEVENT,
    ANSWEREVENT,
    ADDEVENT,
    DELEVENT,
    UPDATEEVENT,
    ENDEVENT,
    ENDSYNC
};

enum statusTable
{
    VALID = 1,
    MODIF,
    DEL
};

enum visibity
{
    PRIVATE = 1,
    PUBLIC,
    FRIEND,
    NOTFRIEND
};

struct command
{
    int idHeader;
};

struct  note
{
    int idCmd;
    int status;
    char title[33];
    char content[2048];
    char idTime[24];
    char lastup[24];
};

struct file
{
    int idCmd;
};

struct contact
{
    int     idCmd;
    int     status;
    int     isfriend;
    char    firstname[128];
    char    lastname[128];
    char    email[256];
    char    address[256];
    char    homephone[20];
    char    cellphone[20];
    char    birthday[12];
    char    usernamecontact[32];
    char    idTime[24];
    char    lastup[24];
};

struct bookmark
{
    int idCmd;
    int idDB;
    int status;
    char title[33];
    char adress[256];
    char idTime[24];
    char lastup[24];
};

struct agenda
{
    int idCmd;
    int status;
    char    taskName[32];
    char    taskComment[1024];
    char    taskStartDate[18];
    char    taskEndDate[18];
    char idTime[24];
    char lastup[24];
};

struct weather
{
    int idCmd;
    int status;
    char country[32];
    char city[32];
    char idTime[24];
    char lastup[24];
};

struct setting
{
    int  idCmd;
    int  status;
    int  visibility;
    char lastname[128];
    char firstname[128];
    char email[256];
    char address[256];
    char homephone [20];
    char cellphone[20];
    char birthday[12];
    char idTime[24];
    char lastup[24];
};

struct events
{
    int idCmd;
    int status;
    char idTime[24];
    char lastup[24];
    char country[32];
    char city[32];
    char title[256];
    char date[12];
    char hour[8];
    char createFName[32];
    char createLName[32];
    char contactList[500];
    char description[1000];
};

struct sys
{
    int idCmd;
    char username[32];
    char password[128];
    bool Connect;
};

#endif // DESCRIPTION_H
