// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item
{
    property int radius;
    property real value : (1 - slider_selector.y / height);

    Rectangle
    {
        anchors.fill: parent
        color : "transparent"
        radius : parent.radius
        border
        {
            color : "black"
            width : 1
        }
    }
    Rectangle
    {
        id : slider_selector
        width : parent.width
        height : tepee.mobileRes / 8
        color : "transparent"
        radius : 25
        smooth : true
        border
        {
            width : 5
            color : "black"
        }
    }
    MouseArea
    {
        anchors.fill: parent
        onPressed: moveSlider(mouse);
        onPositionChanged:  moveSlider(mouse)
        function moveSlider(mouse)
        {
            slider_selector.y = Math.max(parent.x, Math.min(parent.height - slider_selector.height, mouseY));
        }
    }
}
