/*
 * longcat: An account plugin for a telepathy connection manager
 * Copyright (C) 2009 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _LONGCAT_H_
#define _LONGCAT_H_

#include <librtcom-accounts-widgets/rtcom-account-plugin.h>

G_BEGIN_DECLS

#define LONGCAT_TYPE (longcat_pn_get_type ())
#define LONGCAT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), LONGCAT_TYPE, LongcatPn))
#define LONGCAT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), LONGCAT_TYPE, LongcatPnClass))
#define IS_LONGCAT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LONGCAT_TYPE))
#define IS_LONGCAT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), LONGCAT_TYPE))
#define LONGCAT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), LONGCAT_TYPE, LongcatPnClass))

typedef struct _LongcatPnClass LongcatPnClass;
typedef struct _LongcatPn LongcatPn;

struct _LongcatPnClass
{
  RtcomAccountPluginClass parent_class;
};

struct _LongcatPn
{
  RtcomAccountPlugin parent_instance;
};

GType longcat_pn_get_type (void) G_GNUC_CONST;

typedef void (*LongcatPnFillAdvancedTableFunc) (LongcatPn *plugin,
    RtcomAccountService *service, AccountItem *account, GtkWidget *table);

typedef GtkWidget * (*LongcatPnGetPageFunc) (LongcatPn *plugin,
    RtcomAccountItem *account);

void longcat_pn_set_values (LongcatPn *plugin, const gchar *name, guint caps,
    LongcatPnGetPageFunc get_login_page, LongcatPnGetPageFunc get_edit_page,
    LongcatPnFillAdvancedTableFunc fill_advanced_table);

typedef void (*LongcatPnFillPageFunc) (LongcatPn *plugin,
    GtkWidget *table);

void longcat_pn_fill_page (LongcatPn *plugin, GtkWidget *page,
    LongcatPnFillPageFunc func);

G_END_DECLS

#endif /* _LONGCAT_H_ */
