/*
 * salut-plugin: An account plugin for telepathy-salut
 * Copyright (C) 2009 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _SALUT_PLUGIN_H_
#define _SALUT_PLUGIN_H_

#include "longcat.h"

G_BEGIN_DECLS

#define SALUT_TYPE_PLUGIN (salut_plugin_get_type ())
#define SALUT_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), SALUT_TYPE_PLUGIN, SalutPlugin))
#define SALUT_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), SALUT_TYPE_PLUGIN, SalutPluginClass))
#define SALUT_IS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SALUT_TYPE_PLUGIN))
#define SALUT_IS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), SALUT_TYPE_PLUGIN))
#define SALUT_PLUGIN_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), SALUT_TYPE_PLUGIN, SalutPluginClass))

typedef struct _SalutPluginClass SalutPluginClass;
typedef struct _SalutPlugin SalutPlugin;

struct _SalutPluginClass
{
  LongcatClass parent_class;
};

struct _SalutPlugin
{
  Longcat parent_instance;
};

GType salut_plugin_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* _SALUT_PLUGIN_H_ */
