/*
 * butterfly-plugin: An account plugin for telepathy-butterfly
 * Copyright (C) 2009 Collabora, Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>

#include "butterfly-plugin.h"

#include <librtcom-accounts-widgets/rtcom-param-string.h>
#include <librtcom-accounts-widgets/rtcom-param-int.h>
#include <librtcom-accounts-widgets/rtcom-param-bool.h>
#include <librtcom-accounts-widgets/rtcom-login.h>
#include <librtcom-accounts-widgets/rtcom-edit.h>

#include <hildon/hildon-entry.h>

#include <telepathy-glib/connection-manager.h>
#include <telepathy-glib/util.h>

ACCOUNT_DEFINE_PLUGIN (ButterflyPlugin, butterfly_plugin, LONGCAT_TYPE);

static void
butterfly_plugin_init (ButterflyPlugin *self)
{
}

static void
fill_advanced_table (Longcat *plugin,
    RtcomAccountService *service,
    AccountItem *account,
    GtkWidget *table)
{
  TpConnectionManagerParam *params, *p;
  GValue *default_server = NULL, *default_port = NULL;
  GtkWidget *label, *widget;
  gchar *range, *widget_text;

  params = service->protocol->params;
  for (p = params; p != NULL && p->name != NULL; p++)
    {
      if (!tp_strdiff (p->name, "server"))
        default_server = &p->default_value;
      else if (!tp_strdiff (p->name, "port"))
        default_port = &p->default_value;

      if (default_server != NULL && default_port != NULL)
        break;
    }

  /* Server */
  label = gtk_label_new (_("Server"));
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, 1, 0, 1,
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_STRING,
          "field", "server",
          "text", g_value_get_string (default_server),
          NULL));

  /* Disable auto-capitalisation */
  g_object_set (widget, "hildon-input-mode",
      HILDON_GTK_INPUT_MODE_FULL | HILDON_GTK_INPUT_MODE_DICTIONARY, NULL);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, 2, 0, 1,
      GTK_EXPAND | GTK_FILL, 0, 0, 0);

  /* Port */
  label = gtk_label_new (_("Port"));
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, 1, 1, 2,
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  range = g_strdup_printf ("0:%" G_GUINT32_FORMAT, G_MAXUINT32);
  widget_text = g_strdup_printf ("%" G_GUINT32_FORMAT,
      g_value_get_uint (default_port));

  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_INT,
          "field", "port",
          "range", range,
          "text", widget_text,
          NULL));

  g_free (widget_text);
  g_free (range);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, 2, 1, 2,
      GTK_EXPAND | GTK_FILL, 0, 0, 0);
}

static GtkWidget *
get_login_page (Longcat *plugin,
    RtcomAccountItem *account)
{
  const static gchar *invalid_chars_re = "[:'\"<>&;#\\s]";

  return g_object_new (RTCOM_TYPE_LOGIN,
      "username-field", "account",
      "username-invalid-chars-re", invalid_chars_re,
      "username-prefill", RTCOM_ACCOUNT_PLUGIN (plugin)->username_prefill,
      "items-mask", RTCOM_ACCOUNT_PLUGIN (plugin)->capabilities,
      "account", account,
      NULL);
}

static GtkWidget *
get_edit_page (Longcat *plugin,
    RtcomAccountItem *account)
{
  const static gchar *invalid_chars_re = "[:'\"<>&;#\\s]";

  return g_object_new (RTCOM_TYPE_EDIT,
      "username-field", "account",
      "username-invalid-chars-re", invalid_chars_re,
      "items-mask", RTCOM_ACCOUNT_PLUGIN (plugin)->capabilities,
      "account", account,
      NULL);
}

static void
butterfly_plugin_constructed (GObject *object)
{
  Longcat *plugin = LONGCAT (object);
  guint caps;

  caps = RTCOM_PLUGIN_CAPABILITY_ADVANCED
    | RTCOM_PLUGIN_CAPABILITY_SCREEN_NAME;

  longcat_set_values (plugin, "butterfly", caps, get_login_page,
      get_edit_page, fill_advanced_table);

  G_OBJECT_CLASS (butterfly_plugin_parent_class)->constructed (object);
}

static void
butterfly_plugin_class_init (ButterflyPluginClass *klass)
{
  GObjectClass* object_class = G_OBJECT_CLASS (klass);
  object_class->constructed = butterfly_plugin_constructed;
}
