# -*- coding: utf-8 -*-
'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
import xml.etree.ElementTree as ET
import re
from PyQt4.QtCore import *
from PyQt4 import QtCore
from PyQt4.QtGui import QMessageBox

#~~~~~Temporary imports for testing only~~~~~
from PyQt4.QtGui import * 
#~~~~~Temporary imports for testing only~~~~~

global COLORCOMPLETED, ICONCOMPLETED, COLOROVERDUE, ICONOVERDUE, COLORDUESOON, ICONDUESOON, COLORACTIVE, COLORACTIVEMAEMO, ICONACTIVE

class PIParser(ET.XMLTreeBuilder):
    """See http://effbot.org/zone/element-pi.htm"""
    def __init__(self):
        ET.XMLTreeBuilder.__init__(self)
        self._parser.ProcessingInstructionHandler = self.handle_pi
        self.tskversion = 31
    
    def handle_pi(self, target, data):
        if target == 'taskcoach':
            matchObject = re.search('tskversion="(\d+)"', data)
            self.tskversion = int(matchObject.group(1))

#Reader class
class tskFile(object):
    def __init__(self, parent, file, taskModel, categoryModel, settings):
        
        self.settings = settings
        self.colors()
        self.icons()
        
        self.parent = parent
        self.__file = file
        self.__taskModel = taskModel
        self.__categoryModel = categoryModel
        self.__tskFileTree = ET
        
        #print self.__model
    
    def colors(self):
        global COLORCOMPLETED, COLOROVERDUE, COLORDUESOON, COLORACTIVE, COLORACTIVEMAEMO
        COLORCOMPLETED = self.settings.getcolor("color", "completedtasks")
        COLOROVERDUE = self.settings.getcolor("color", "overduetasks")
        COLORDUESOON = self.settings.getcolor("color", "duesoontasks")
        COLORACTIVE = self.settings.getcolor("color", "activetasks")
        COLORACTIVEMAEMO = self.settings.getcolor("color", "activetasksmaemo")
    
    def icons(self):
        global ICONCOMPLETED, ICONOVERDUE, ICONDUESOON, ICONACTIVE
        ICONCOMPLETED = self.settings.geticon("icons", "iconcompleted")
        ICONOVERDUE = self.settings.geticon("icons", "iconoverdue")
        ICONDUESOON = self.settings.geticon("icons", "iconduesoon")
        ICONACTIVE = self.settings.geticon("icons", "iconactive")
        
    def write(self):
        self.__tskFileTree.write(self.__file)
    
    def read(self):
        #TODO: Implement the PIParser if taskcoach versions change and it matters
        #TODO: Determine supported versions if releasing public
        parser = PIParser()
        
        
        try:
            self.__tskFileTree = ET.parse(self.__file, parser)
        except Exception:
            #Not a valid xml file
            msgBox = QMessageBox()
            #msgBox.setText("<p align='center'>Selected file does not appear to be a valid Task Coach file<br>"
            msgBox.setText("<p>Selected file does not appear to be a valid Task Coach file<br>"
            "Check to be sure file exists and is a valid Task Coach XML file<br>"
            "File: " + self.__file + "</p>")
            msgBox.setWindowTitle("Uh oh, this is killing productivity")
            msgBox.addButton(QMessageBox.Ok)
            msgBox.exec_()
            #QMessageBox.critical(self.parent, 'Uh oh, this is killing productivity', "Selected file does not appear to be a valid task coach file./nCheck that: " + self.__file + " exists and is a valid Task Coach XML file", QMessageBox.Ok, QMessageBox.Ok)
            #pass
        else:
            self.etModelToQSIModels(self.__tskFileTree)
            #print dir(self.__taskModel)
        
        #print self.__taskModel.rowCount()
        
        #TODO: Guid, syncmlconfig for anything? Not unless writing with something other than elementtree, it will write it back correctly currently
    def checkChildren(self, match, item):
        for id in self.__viewSelectedCategoryItemIds:
            if item.tag == "task":
                if item.attrib["id"] == id:
                    #print "We have a child match: " + item.attrib["subject"]  + " " + item.attrib["id"]
                    match = True
                    break
                else:
                    for children in item.getchildren():
                        if match == True:
                            break
                        elif children.tag == "task":
                            match = self.checkChildren(match, children)
        return match
        
    
    def etModelToQSIModels(self, tree):
        '''
        construct qstandarditemlist from ElementTree
        '''
#        print "The length of categories is:"
#        print len(self.__viewSelectedCategories)
#        print self.__viewSelectedCategories
#        
#        print "the length of ids is: "
#        print len(self.__viewSelectedCategoryItemIds)
#        print self.__viewSelectedCategoryItemIds
        
        root_e = tree.getroot()
        self.__taskModel.clear()
        self.__categoryModel.clear()


        for subelement in root_e:
            completed = False
            overdue = False
            dueToday = False
            
            
            if subelement.tag == "task" and subelement.attrib["id"]:
                #print subelement.attrib
                overdue = False
                completed = False
                            
                try:
                    subelement.attrib["subject"]
                except KeyError:
                    #Just a closing tag, not a valid task
                    pass
                else:
                    root_subject = QStandardItem()
                    root_subject.setData(subelement)
                    root_subject.setText(subelement.attrib["subject"])
                        
                        #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
                    root_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable) 
                    try:
                        subelement.attrib["completiondate"]
                    except KeyError:
                        check = Qt.Unchecked
                    else:
                        check = Qt.Checked
                        completed = True
                    root_subject.setData(QVariant(check), Qt.CheckStateRole)
                        
                    root_priority = QStandardItem()
                    root_priority.setData(subelement)
                    try:
                        subelement.attrib["priority"]
                    except KeyError:
                        root_priority.setText("")
                    else:
                        root_priority.setText(subelement.attrib["priority"])
                    
                    root_id = QStandardItem()
                    root_id.setData(subelement)
                    try:
                        subelement.attrib["id"]
                    except KeyError:
                        root_priority.setText("")
                    else:
                        root_id.setText(subelement.attrib["id"])
                         
                    root_startdate = QStandardItem()
                    root_startdate.setData(subelement)
                    try:
                        subelement.attrib["startdate"]
                    except KeyError:
                        root_startdate.setText("")
                    else:
                        startdateTimeString = subelement.attrib["startdate"].split(' ')
                        startDateString = startdateTimeString[0]
                        root_startdate.setText(startDateString)
                        
                    root_duedate = QStandardItem()
                    root_duedate.setData(subelement)
                    try:
                        subelement.attrib["duedate"]
                    except KeyError:
                        root_duedate.setText("")
                    else:
                        duedateTimeString = subelement.attrib["duedate"].split(' ')
                        dueDateString = duedateTimeString[0]
                        root_duedate.setText(dueDateString)
                        duedateObject = QDate.fromString(dueDateString, "yyyy-MM-dd")
                            
                        if duedateObject == QDate.currentDate():
                            dueToday = True
                        elif duedateObject < QDate.currentDate():
                            overdue = True
                            
                        #if dueDateString == QDate.toString(QDate.currentDate(), "yyyy-MM-dd"):
                            #  dueToday = True
                        #elif duedateObject < QDate.currentDate():
                            #  overdue = True
                        
        #                root_subject.setData(QtCore.QVariant(task))
        #                root_startdate.setData(QtCore.QVariant(task))
        #                root_duedate.setData(QtCore.QVariant(task))
        #                root_priority.setData(QtCore.QVariant(task))
                    if completed == True:
                        #print "Completed"
                        root_subject.setIcon(ICONCOMPLETED)
                        root_subject.setForeground(QBrush(COLORCOMPLETED))
                        root_startdate.setForeground(QBrush(COLORCOMPLETED))
                        root_duedate.setForeground(QBrush(COLORCOMPLETED))
                        root_priority.setForeground(QBrush(COLORCOMPLETED))
                        root_id.setForeground(QBrush(COLORCOMPLETED))
                    elif overdue == True:
                        #print "OverDue"
                        root_subject.setIcon(ICONOVERDUE)
                        root_subject.setForeground(QBrush(COLOROVERDUE))
                        root_startdate.setForeground(QBrush(COLOROVERDUE))
                        root_duedate.setForeground(QBrush(COLOROVERDUE))
                        root_priority.setForeground(QBrush(COLOROVERDUE))
                        root_id.setForeground(QBrush(COLOROVERDUE))
                    elif dueToday == True:
                        #print "Due Today"
                        root_subject.setIcon(ICONDUESOON)
                        root_subject.setForeground(QBrush(COLORDUESOON))
                        root_startdate.setForeground(QBrush(COLORDUESOON))
                        root_duedate.setForeground(QBrush(COLORDUESOON))
                        root_priority.setForeground(QBrush(COLORDUESOON))
                        root_id.setForeground(QBrush(COLORDUESOON))
                    else:
                        root_subject.setIcon(ICONACTIVE)
                    
                    self.__taskModel.appendRow([root_subject, root_startdate, root_duedate, root_priority, root_id])
    #                    self.__taskModel.appendRow(root_subject)
    #                    curPosition = self.__taskModel.indexFromItem(root_subject)
    #                    self.__taskModel.setItem(curPosition.row(),  curPosition.column()+1,  root_startdate)
    #                    self.__taskModel.setItem(curPosition.row(),  curPosition.column()+2,  root_duedate)
    #                    self.__taskModel.setItem(curPosition.row(),  curPosition.column()+3,  root_priority)
    
                    for children in subelement.getchildren():
                        if children.tag == "task":
                            self.extend_tree(self.__taskModel, children, root_subject)
                            
            elif subelement.tag == "category" and subelement.attrib["id"]:
                try:
                    subelement.attrib["subject"]
                except KeyError:
                    #Just a closing tag, not a valid task
                    pass
                else:
                    task_root_subject = QStandardItem()
                    task_root_subject.setData(subelement)
                    task_root_subject.setText(subelement.attrib["subject"])
                    
                    #Figure out when to check and uncheck these items
                    #check = Qt.Unchecked
                    check = Qt.Unchecked
                    task_root_subject.setData(QVariant(check), Qt.CheckStateRole)
                    
                try:
                    subelement.attrib["id"]
                except KeyError:
                    #Just a closing tag, not a valid task
                    pass
                else:
                    task_root_id = QStandardItem()
                    task_root_id.setData(subelement)
                    task_root_id.setText(subelement.attrib["id"])
                    #print subelement.attrib["id"]
                    #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
                    task_root_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable)
                
                self.__categoryModel.appendRow([task_root_subject, task_root_id])
                #curPosition = self.__categoryModel.indexFromItem(task_root_subject)
                #self.__categoryModel.setItem(curPosition.row(),  curPosition.column()+1,  task_root_id)
                
                for children in subelement.getchildren():
                    if children.tag == "category":
                        self.extend_category_tree(self.__categoryModel, children, task_root_subject)
                
                self.__categoryModel.setHeaderData(0, Qt.Horizontal, QVariant("Subject"))
                self.__categoryModel.setHeaderData(1, Qt.Horizontal, QVariant("ID"))
        
        

    
        return self.__taskModel
    
    def extend_category_tree(self, treestore, element, parent_node):
        try:
            element.attrib["subject"]
        except KeyError:
            #set to text instead of a qstandarditem and skip adding it cause its not a real task, just a closing tag
            node_subject = ""
            pass
        else:
            #print element.attrib["subject"]
            node_subject = QStandardItem()
            node_subject.setData(element)
            node_subject.setText(element.attrib["subject"])
            #Figure out when to check and uncheck these items
            #check = Qt.Unchecked
            check = Qt.Unchecked
            node_subject.setData(QVariant(check), Qt.CheckStateRole)
        
            #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
            node_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable)
            
            node_id = QStandardItem()
            node_id.setData(element)
            try:
                element.attrib["id"]
            except KeyError:
                node_id.setText("")
            else:
                node_id.setText(element.attrib["id"])
                
            #print node_subject.text()
            parent_node.appendRow([node_subject, node_id])
            
            # recurse over children
            for child_element in element.getchildren():
                child_node = self.extend_category_tree(treestore, child_element, node_subject)
                
        return node_subject
        
    def extend_tree(self, treestore, element, parent_node):
        '''
        '''
        completed = False
        overdue = False
        dueToday = False
            
        
        try:
            element.attrib["subject"]
        except KeyError:
            #set to text instead of a qstandarditem and skip adding it cause its not a real task, just a closing tag
            node_subject = ""
            pass
        else:
            node_subject = QStandardItem()
            node_subject.setData(element)
            node_subject.setText(element.attrib["subject"])
            
            #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
            node_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable)
            try:
                element.attrib["completiondate"]
            except KeyError:
                check = Qt.Unchecked
            else:
                check = Qt.Checked
                completed = True
            node_subject.setData(QVariant(check), Qt.CheckStateRole)
                    
            #Skip if it is just the text none, set above to note just a closing tag
            #if node_subject != "none":
                
            node_priority = QStandardItem()
            node_priority.setData(element)
            try:
                element.attrib["priority"]
            except KeyError:
                node_priority.setText("")
            else:
                node_priority.setText(element.attrib["priority"])
                
            node_id = QStandardItem()
            node_id.setData(element)
            try:
                element.attrib["id"]
            except KeyError:
                node_priority.setText("")
            else:
                node_id.setText(element.attrib["id"])
                    
            node_startdate = QStandardItem()    
            node_startdate.setData(element)    
            try:
                element.attrib["startdate"]
            except KeyError:
                node_startdate.setText("")
            else:
                startdateTimeString = element.attrib["startdate"].split(' ')
                startDateString = startdateTimeString[0]
                node_startdate.setText(startDateString)
                
            node_duedate = QStandardItem()
            node_duedate.setData(element)
            try:
                element.attrib["duedate"]
            except KeyError:
                node_duedate.setText("")
            else:
                duedateTimeString = element.attrib["duedate"].split(' ')
                dueDateString = duedateTimeString[0]
                node_duedate.setText(dueDateString)
                duedateObject = QDate.fromString(dueDateString, "yyyy-MM-dd")
                
                if duedateObject < QDate.currentDate():
                    overdue = True
                elif duedateObject <= QDate.currentDate():
                    dueToday = True
                
        #task = {'id': node_priority.setText(),  'label': node_subject.setText(),  'startdate': node_startdate.setText(),  'duedate': node_duedate.setText()}
        #        node_subject.setData(QtCore.QVariant(task))
        #        node_startdate.setData(QtCore.QVariant(task))
        #        node_duedate.setData(QtCore.QVariant(task))
        #        node_priority.setData(QtCore.QVariant(task))
        
            if completed == True:
                node_subject.setIcon(ICONCOMPLETED)
                node_subject.setForeground(QBrush(QColor(Qt.green)))
                node_startdate.setForeground(QBrush(QColor(Qt.green)))
                node_duedate.setForeground(QBrush(QColor(Qt.green)))
                node_priority.setForeground(QBrush(QColor(Qt.green)))
                node_id.setForeground(QBrush(QColor(Qt.green)))
            elif overdue == True:
                node_subject.setIcon(ICONOVERDUE)
                node_subject.setForeground(QBrush(COLOROVERDUE))
                node_startdate.setForeground(QBrush(COLOROVERDUE))
                node_duedate.setForeground(QBrush(COLOROVERDUE))
                node_priority.setForeground(QBrush(COLOROVERDUE))
                node_id.setForeground(QBrush(COLOROVERDUE))
            elif dueToday == True:
                node_subject.setIcon(ICONDUESOON)
                node_subject.setForeground(QBrush(COLORDUESOON))
                node_startdate.setForeground(QBrush(COLORDUESOON))
                node_duedate.setForeground(QBrush(COLORDUESOON))
                node_priority.setForeground(QBrush(COLORDUESOON))
                node_id.setForeground(QBrush(COLORDUESOON))
            else:
                node_subject.setIcon(ICONACTIVE)
        
            parent_node.appendRow([node_subject, node_startdate, node_duedate, node_priority, node_id])
                
                # recurse over children
            for child_element in element.getchildren():
                child_node = self.extend_tree(treestore, child_element, node_subject)
                    
        return node_subject

    def getTree(self):
        return self.__tskFileTree
        
    def getTaskModel(self):
        return self.__taskModel
        
    def getCategoryModel(self):
        return self.__categoryModel
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
#Below this is all temporary, used for testing  
def main():
     
    path = "testTasks.tsk"
    reader = tskReader(path)
    app = QApplication(sys.argv)
    
    tree = QTreeView()
    tree.setModel(reader.model())
    tree.show()
    
    sys.exit(app.exec_())

if __name__ == "__main__":
    import sys
    main()
    sys.exit()
