#!/usr/bin/env python2.5
'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
# -*- coding: utf-8 -*-

import sys
from os import path
from PyQt4.QtCore import QObject, SIGNAL,  QDateTime
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui
#from ui.mainwindow import MainWindow

from tskXml.tskXml import *
#from task.task import *
from thirdparty import relativedelta
from thirdparty import parser
from ui.taskProperties import taskProperties
from ui.help import HelpWindow
from settings.settings import MyConfigParser
from ui.categories import CategoryWindow as catWin

from model.model import *

from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature

# ElementTree - --- --- --- --- --- --- ---
import xml.etree.ElementTree as ET
from xml.etree.ElementTree import Element
# --- --- --- --- --- --- --- --- --- --- --- --- 
import sys
# --- --- --- --- --- --- --- --- --- --- --- --- 

from ui.Ui_mainwindow import Ui_MainWindow

global AUTOSAVE, UNSAVEDCHANGES,  myobj
global COLORCOMPLETED, ICONCOMPLETED, COLOROVERDUE, ICONOVERDUE, COLORDUESOON, ICONDUESOON, COLORACTIVE, COLORACTIVEMAEMO, ICONACTIVE
global EXPANDALL
EXPANDALL = False
WIDTHCOL0 = 430
WIDTHCOL1 = 130
WIDTHCOL2 = 130
SORTCOL = 2
SORTORDER = QtCore.Qt.AscendingOrder
UNSAVEDCHANGES = False
         
class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, maemo5, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.__maemo5 = maemo5
        self.setupUi(self)
        #print id(self)
        #Can probably remove the buttons, but for now leaving them until the toolbar is thoroughly tested.
        #self.buttonsWidget.hide()
        #self.buttonHLayout.hide()
        
        #self.__hidecompleted = False
        
        #Cannot initialize a QPaintDevice before an application exists, so getting setting values here
        #Read these values from settings file
        self.loadSettings()
        
        self.model = taskPoachModel(self, self.maemo5(), self.settings, self.taskTreeView)
        self.modelFilter = filterManager(self)
        #Set up the toolbar
        self.loadToolBar()
        self.setupAdditionalShortcuts()
        
        #Disable the buttons that should only be available when a item is highlighted
        #self.newSubTask.setEnabled(False)
        #self.editTask.setEnabled(False)
        #self.delTask.setEnabled(False)
        
        #If load last file is set in settings load that file - if it can't be found work on error notification
        if self.settings.getboolean("file", "loadlastfile"):
            #print "Yes load the last file"
            self.filename = self.settings.get("file", "lastfile")
            self.model.loadModel(self.filename)
    
    def setupAdditionalShortcuts(self):
        #New File
        #self.newFileAction = QtGui.QAction(QtGui.QIcon('new.png'), '&New', self)
        self.actionNew.setShortcut('Ctrl+N')
        #self.connect(self.newFileAction, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_actionNew_triggered()'))
        #self.connect(self.newFileAction, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnNew_released()'))
        #self.connect(self.newSubTask, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnSubtask_released()'))
        
        #Help
        #self.helpAction = QtGui.QAction(QtGui.QIcon('help.png'), '&Help', self)
        self.actionHelp.setShortcut('Ctrl+Shift+H')
        #self.helpAction.setStatusTip('Help')
        #self.connect(self.helpAction, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_actionAbout_triggered()'))
        #About
        self.actionAbout.setShortcut('Ctrl+Shift+A')
        #Open File
        self.actionOpen.setShortcut('Ctrl+O')
        #Edit Task
        self.actionEdit_task.setShortcut('Ctrl+E')
        #Quit
        self.actionQuit.setShortcut('Ctrl+Q')
        #Save File
        self.actionSave.setShortcut('Ctrl+S')

    def focusInEvent(self, event):
        #print 'Got focus'
        #need to scroll to selection after other windows return focus to main window
        #self.scrollToSelection()
        pass

    #Prompt for changes if auto save is not on and there are unsaved changes
    def closeEvent(self, event):
        global UNSAVEDCHANGES
        
        if UNSAVEDCHANGES:
            reply = QtGui.QMessageBox.question(self, 'Message',
                                               "Save task file before exiting?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No |QtGui.QMessageBox.Cancel, QtGui.QMessageBox.Yes)

            if reply == QtGui.QMessageBox.Yes:
                self.saveFile()
                event.accept()
            elif reply == QtGui.QMessageBox.No:
                event.accept()
            else:
                event.ignore()
        
    def loadSettings(self):
        self.settings = MyConfigParser(self)
        global AUTOSAVE
        self.__hidecompleted =  self.settings.getboolean("taskview", "hidecompleted")
        AUTOSAVE = self.settings.getboolean("file","autosave")
        self.colors()
        self.icons()
        loadLastFile = self.settings.getboolean("file","loadlastfile")
        #print "Load last file?: "
        
    
    def icons(self):
        global ICONCOMPLETED, ICONOVERDUE, ICONDUESOON, ICONACTIVE
        ICONCOMPLETED = self.settings.geticon("icons", "iconcompleted")
        ICONOVERDUE = self.settings.geticon("icons", "iconoverdue")
        ICONDUESOON = self.settings.geticon("icons", "iconduesoon")
        ICONACTIVE = self.settings.geticon("icons", "iconactive")
        
    def colors(self):
        global COLORCOMPLETED, COLOROVERDUE, COLORDUESOON, COLORACTIVE, COLORACTIVEMAEMO
        COLORCOMPLETED = self.settings.getcolor("color", "completedtasks")
        COLOROVERDUE = self.settings.getcolor("color", "overduetasks")
        COLORDUESOON = self.settings.getcolor("color", "duesoontasks")
        COLORACTIVE = self.settings.getcolor("color", "activetasks")
        COLORACTIVEMAEMO = self.settings.getcolor("color", "activetasksmaemo")
        
    def loadToolBar(self):
        global AUTOSAVE
        
        #Put all task specific buttons first & keep together
        #New task
        if self.maemo5():
          self.newTask = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/filenew.png'), 'New Task', self)
        else:
          self.newTask = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/filenew.png'), 'New Task', self)
        self.newTask.setShortcut('Ctrl+T')
        self.connect(self.newTask, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnNew_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.newTask)
        
        #New subtask
        if self.maemo5():
          self.newSubTask = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/custom_newsub.png'), 'New SubTask', self)
        else:
          self.newSubTask = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/custom_newsub.png'), 'New SubTask', self)
        self.newSubTask.setShortcut('Ctrl+Shift+T')
        self.connect(self.newSubTask, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnSubtask_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.newSubTask)
        
        #Edit Task
        #self.editTask = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit.png'), 'Edit Task', self)
        if self.maemo5():
          self.editTask = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/edit.png'), 'Edit Task', self)
        else:
          self.editTask = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit.png'), 'Edit Task', self)
        #self.editTask.setShortcut('Ctrl+E')
        self.connect(self.editTask, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_actionEdit_task_triggered()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.editTask)
        
        #Delete Task
        if self.maemo5():
          self.delTask = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/editdelete.png'), 'Delete Task', self)
        else:
          self.delTask = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/editdelete.png'), 'Delete Task', self)
        self.delTask.setShortcut('Ctrl+D')
        self.connect(self.delTask, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnDelete_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.delTask)
        
        
        #Spacer to move the app wide buttons all the way to the right
        spacer = QWidget()
        spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.toolBar.addWidget(spacer) 
        
        #Hide completed
        if self.maemo5():
          self.hideBtn = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/custom_ledgreen_fading.png'), 'Hide Completed', self)
        else:
          self.hideBtn = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/custom_ledgreen_fading.png'), 'Hide Completed', self)
        self.hideBtn.setShortcut('Ctrl+H')
        self.connect(self.hideBtn, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnHideCompleted_released()'))
        self.toolBar.addAction(self.hideBtn)
        
        #Categories/Filter
        if self.maemo5():
          self.categories = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/toggle_log.png'), 'Categories', self)
        else:
          self.categories = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/toggle_log.png'), 'Categories', self)
        self.categories.setShortcut('Ctrl+F')
        self.connect(self.categories, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnCategories_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.categories)
        
        #Expand All
        if self.maemo5():
          self.expandAll = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/edit_add.png'), 'Expand All', self)
        else:
          self.expandAll = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit_add.png'), 'Expand All', self)
        self.expandAll.setShortcut('Ctrl+U')
        self.connect(self.expandAll, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnExpandAll_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.expandAll)
        
        #Collapse All
        if self.maemo5():
          self.collapseAll = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/edit_remove.png'), 'Collapse All', self)
        else:
          self.collapseAll = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit_remove.png'), 'Collapse All', self)
        self.categories.setShortcut('Ctrl+I')
        self.connect(self.collapseAll , QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnCollapseAll_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.collapseAll )
        
        #Spacer to move the app wide buttons all the way to the right
        spacer = QWidget()
        spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.toolBar.addWidget(spacer) 
        
        
        #Save button, only show if auto save is off to help remind users to save
        if not AUTOSAVE:
            if self.maemo5():
              self.save = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/devices/3floppy_unmount.png'), 'Save', self)
            else:
              self.save = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/devices/3floppy_unmount.png'), 'Save', self)
            #self.save.setShortcut('Ctrl+S')
            self.connect(self.save, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_actionSave_triggered()'))
            #self.exit.setEnabled(False)
            self.toolBar.addAction(self.save)
        
        #Exit button
        if self.maemo5():
          self.exit = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/exit.png'), 'Exit', self)
        else:
          self.exit = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/exit.png'), 'Exit', self)
        #self.exit.setShortcut('Ctrl+Q')
        self.connect(self.exit, QtCore.SIGNAL('triggered()'), QtCore.SLOT('close()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.exit)

        
    def maemo5(self):
        return self.__maemo5
    
    def hideCompleted(self):
        return self.__hidecompleted
        
    @pyqtSignature("")
    def on_btnNew_released(self):
        """
        Slot documentation goes here.
        """
        # Create a new task to edit & pass to the taskProperties window
        #selection = Task()
        #Be sure there is actually a file created to add tasks to or this will throw an error
        try:
            self.model.etree.getroot()
        except AttributeError:
            #print "No file open"
            reply = QtGui.QMessageBox.question(self, 'Message',
                                               "No task file currently open, create a new file?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No |QtGui.QMessageBox.Cancel, QtGui.QMessageBox.Yes)

            if reply == QtGui.QMessageBox.Yes:
                self.newFile()
                self.addNewTask()
            if reply == QtGui.QMessageBox.No:
                pass
            #Otherwise cancel opening file
        else:
            self.addNewTask()
    
    def addNewTask(self):
        win = taskProperties(self, None, None, self.model.etree.getroot(), self.model.etree, self.model.taskModel, self.model.qSIRow, self.model.categoryModel, self.settings)
        if self.maemo5():
            win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
            #win.setAttribute(QtCore.Qt.WA_Maemo5PortraitOrientation, True)
            #except:print("Cannot set orientation to portrait")
        win.show()
    
    @pyqtSignature("")
    def on_btnSubtask_released(self):
        """
        Slot documentation goes here.
        """
        #Ensure selection variable is defined and a valid element
        if (type(self.model.selection.currentSelection()) == bool):
            #Show a message no item selected, cannot delete
            QtGui.QMessageBox.information(self, "Alert", "No task currently selected. Please select a parent task before trying to create a subtask.", QtGui.QMessageBox.Ok)
        else:
            try:
                self.model.selection.currentSelection().attrib["id"]
            except AttributeError:
                #Show a message no item selected, cannot delete
                QtGui.QMessageBox.information(self, "Alert", "No task currently selected. Please select a parent task before trying to create a subtask.", QtGui.QMessageBox.Ok)
            else:
                try:
                    self.model.selection.currentSelection()
                except NameError:
                    pass
                else:
                #if self.model.selection.currentSelection():
                    win = taskProperties(self, None, None, self.model.selection.currentSelection(), self.model.etree, self.model.taskModel, self.model.qSIRow, self.model.categoryModel, self.settings)
                    if self.maemo5():
                        win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
                        win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
                    win.show()
        
    @pyqtSignature("")
    def on_btnEdit_released(self):
        """
        Slot documentation goes here.
        """
        self.editCurrentTask()
        
    def editCurrentTask(self):
        # Ensure selection variable is defined and not a bool (meaning not a real element)
        if (type(self.model.selection.currentSelection()) == bool):
            #Show a message no item selected, cannot delete
            QtGui.QMessageBox.information(self, "Alert", "No task currently selected. Please make a selection to edit.", QtGui.QMessageBox.Ok)
        else:
            try:
                self.model.selection.currentSelection().attrib["id"]
            except AttributeError:
                #Show a message no item selected, cannot delete
                QtGui.QMessageBox.information(self, "Alert", "No task currently selected. Please make a selection to edit.", QtGui.QMessageBox.Ok)
            else:
                try:
                    self.model.selection.currentSelection()
                except NameError:
                    pass
                else:
                    win = taskProperties(self, self.model.selection.currentSelection(), self.model.selection.qItemSelection(), None,  None, self.model.taskModel, self.model.qSIRow, self.model.categoryModel, self.settings)
                    #if self.model.selection.currentSelection:
                    
                    win = taskProperties(self, self.model.selection.currentSelection(), self.model.selection.qItemSelection(), None,  None, self.model.taskModel, self.model.qSIRow, self.model.categoryModel, self.settings)
                    if self.maemo5():
                        win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
                        win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
                        
                    win.show()
            
    @pyqtSignature("")
    def on_btnDelete_released(self):
        """
        Slot documentation goes here.
        """
        global AUTOSAVE
        #taskModel = tskFileObject.getTaskModel()
        if (type(self.model.selection.currentSelection()) == bool):
            #Show a message no item selected, cannot delete
            QtGui.QMessageBox.information(self, "Alert", "No task currently selected. Please make a selection before trying to delete.", QtGui.QMessageBox.Ok)
        else:
            try:
                self.model.selection.currentSelection().attrib["id"]
            except AttributeError:
                #Show a message no item selected, cannot delete
                QtGui.QMessageBox.information(self, "Alert", "No task currently selected. Please make a selection before trying to delete.", QtGui.QMessageBox.Ok)
            else:
                if self.settings.getboolean("file", "promptOnDeletion"):
                    reply = QtGui.QMessageBox.question(self, 'Message',
                                               "Delete Task?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No, QtGui.QMessageBox.Yes)

                    if reply == QtGui.QMessageBox.Yes:
                        delTask = True
                    else:
                        delTask = False
                else:
                    delTask = True
                    
                if delTask:
                        #if self.model.selection.currentSelection():
                    idToRemove = self.model.selection.currentSelection().attrib["id"]
                    #print selection.attrib["subject"]
                    
                    if self.model.selection.qItemSelection().parent() == None:
                        #print "Delete a top level item"
                        #get root of tree and delete item
                        parentItem = self.model.etree.getroot()
                        parentItem.remove(self.model.selection.currentSelection())
                        #remove from qtstandarditemmodel too
                        self.model.taskModel.removeRow(self.model.selection.qItemSelection().row())
                    else:
                        #print "Delete a child item"
                        #delete item
                        
                        parentItem = self.model.selection.qItemSelection().parent().data().toPyObject()
                        parentItem.remove(self.model.selection.currentSelection())
                        
                        self.model.taskModel.removeRow(self.model.selection.qItemSelection().row(), self.model.taskModel.indexFromItem(self.model.selection.qItemSelection().parent()))
                        #remove from qtstandarditemmodel too
                        #print self.model.selection.qItemSelection().row()
                        #self.model.taskModel.removeRow(self.model.selection.qItemSelection().row(), self.model.selection.qItemSelection().parent().index())
                        #self.model.selection.qItemSelection().parent().data().toPyObject().remove(self.model.selection.currentSelection())
        
                    #check parents, which in turn checks all children
                    self.deleteTaskFromCategories(idToRemove)
                    
                    self.autoSave()
            
    def deleteTaskFromCategories(self, id):
        for i in range (0, self.model.categoryModel.rowCount()):
            #print self.model.categoryModel.index(j, 0, self.model.categoryModel.indexFromItem(parent))
            itemIndex = self.model.categoryModel.index(i, 0)
            element = self.model.categoryModel.itemFromIndex(itemIndex).data().toPyObject()
            #print element.attrib["id"]
            try:
                categorizables = element.attrib["categorizables"]
            except KeyError:
                #This category has no categorizables, no further check needed proceed to checking children and next category
                pass
            else:
                #Check for current selection id in categorizables list
                #print categorizables.find(id)
                if categorizables.find(id) >= 0 :
                    #print "Found in: " + element.attrib["subject"]
                    #print "Found in: " + element.attrib["subject"] + " which is " + element.attrib["categorizables"]
                    
                    #It is in this category, need to remove it
                    #Put string in a list
                    list = element.attrib["categorizables"].split()
                    #Remove the id
                    list.remove(id)
                    #Join the list back to a string and save it in the categorizables of this category
                    element.attrib["categorizables"] =  " ".join(list)
                
            if self.model.categoryModel.item(i, 0).hasChildren():
                self.deleteTaskFromChildCategories(id,  self.model.categoryModel.item(i, 0))
        
    def deleteTaskFromChildCategories(self, id, parent):
        for j in range (0, self.model.categoryModel.rowCount(self.model.categoryModel.indexFromItem(parent))):
            #print self.model.categoryModel.index(j, 0, self.model.categoryModel.indexFromItem(parent))
            itemIndex = self.model.categoryModel.index(j, 0, self.model.categoryModel.indexFromItem(parent))
            element = self.model.categoryModel.itemFromIndex(itemIndex).data().toPyObject()
            try:
                categorizables = element.attrib["categorizables"]
            except KeyError:
                #This category has no categorizables, no further check needed proceed to checking children and next category
                pass
            else:
                #Check for current selection id in categorizables list
                #print categorizables.find(id)
                if categorizables.find(id) >= 0 :
                    #print "Found in: " + element.attrib["subject"]
                    #print "Found in: " + element.attrib["subject"] + " which is " + element.attrib["categorizables"]
                    
                    #It is in this category, need to remove it
                    #Put string in a list
                    list = element.attrib["categorizables"].split()
                    #Remove the id
                    list.remove(id)
                    #Join the list back to a string and save it in the categorizables of this category
                    element.attrib["categorizables"] =  " ".join(list)
                    
            if self.model.categoryModel.itemFromIndex(itemIndex).hasChildren():
                self.deleteTaskFromChildCategories(id, self.model.categoryModel.itemFromIndex(itemIndex))
    
    
    @pyqtSignature("")
    def on_btnExpandAll_released(self):
        """
        Slot documentation goes here.
        """   
        self.taskTreeView.expandAll()
        self.scrollToSelection()
        
    @pyqtSignature("")
    def on_btnCollapseAll_released(self):
        """
        Slot documentation goes here.
        """   
        
        #filtering test using this button, not related to collapsing
        #string = "1122523944:1316750205.88|1176369096:1317327419.7|1123226512:1317356543.57|1291769800:1317337073.24|77650192:1317420674.31|1129674912:1317334895.1|1138778952:1317321323.3"
        #self.model.proxy.setFilterRegExp(QRegExp(string, Qt.CaseInsensitive))
        #self.model.proxy.setFilterKeyColumn(4);
        
        self.taskTreeView.collapseAll()
        self.scrollToSelection()
        
        
    @pyqtSignature("")
    def on_btnCategories_released(self):
        """
        Slot documentation goes here.
        """
        if self.model.categoryModel.rowCount() >= 1:
            #print "Some categories are in selection model"
            pass
        else:
            #print "No categories are in selection model"
            pass
        cats = catWin(self, self.model.etree, self.model.categoryModel, self.maemo5(), self.modelFilter.viewSelectedCategories, self.modelFilter.viewSelectedCategoryItemIds, self.settings)
        
        if self.maemo5():
            cats.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
            cats.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            
        cats.show()
    
    @pyqtSignature("")
    def on_btnHideCompleted_released(self):
        """
        Slot documentation goes here.
        """
        if self.__hidecompleted:
            self.settings.set("taskview", "hidecompleted", "False")
            self.__hidecompleted =  self.settings.getboolean("taskview", "hidecompleted")
            self.settings.save()
            
            #run the update
            #self.tskFileObject.etModelToQSIModels(self.model.etree)
            #self.updateTaskView()
        else:
            self.settings.set("taskview", "hidecompleted", "True")
            self.__hidecompleted =  self.settings.getboolean("taskview", "hidecompleted")
            self.settings.save()
        
        #self.model = ""
        #self.model = taskPoachModel(self, self.maemo5(), self.settings, self.taskTreeView)
        #self.model.loadModel(self.filename)
        
        #print id(self.model)
        self.model.proxy.invalidate()
        #self.model.setUpProxyModel()
        #self.modelFilter.filterTasks()
        #self.model.setUpProxyModel()
        #self.model.proxy.refreshFilter()
        
        #self.hideCompleteTasks()
        self.scrollToSelection()
        
    def hideCompleteTasks(self):
        if self.__hidecompleted:
            #Remove the tasks that are checked (completed) from the qStandardItemModel so they don't show (don't remove them from the etree)
            deleteStack = []
            for i in range (0, self.model.taskModel.rowCount()):
                #print i
                #print self.model.taskModel.index(j, 0, self.model.taskModel.indexFromItem(parent))
                itemIndex = self.model.taskModel.index(i, 0)
                if not self.model.taskModel.itemFromIndex(itemIndex) == None:
                    state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][self.model.taskModel.itemFromIndex(itemIndex).checkState()]
                    if state == 'CHECKED':
                        #Was removing rows here, but once several items are removed was leaving a few items at the end, so put all indexes in a stack & delete them after finding all
                        #print "should be removing row " + str(i)
                        #self.model.taskModel.removeRows(i, 1)
                        deleteStack.append(itemIndex)
            #Now delete all found items
            while len(deleteStack) > 0:
                #print deleteStack
                itemIndex = deleteStack.pop()
                self.model.taskModel.removeRows(self.model.taskModel.itemFromIndex(itemIndex).row(), 1)
            
                #if self.model.taskModel.item(i, 0).hasChildren():
                    #self.childOperations(operation, self.model.taskModel.item(i, 0))
        
        
    @pyqtSignature("")
    def on_actionEdit_task_triggered(self):
        """
        Slot documentation goes here.
        """
        self.editCurrentTask()
        
    @pyqtSignature("")
    def on_actionQuit_triggered(self):
        """
        Slot documentation goes here.
        """
        QtCore.QCoreApplication.instance().quit()
        
    @pyqtSignature("")
    def on_actionHelp_triggered(self):
        """
        Slot documentation goes here.
        """
        self.helpWindow()
        #QtGui.QMessageBox.information(self, "About TaskPoach", "TaskPoach aims to be compatible with TaskCoach XML files. Intended to allow simple updates to your existing .tsk files while preserving important data it cannot edit.", QtGui.QMessageBox.Ok)
        
        #QtGui.QMessageBox('About TaskPoach',"TaskPoach aims to be a (very) simplified program compatible with TaskCoach files.")
        
    @pyqtSignature("")
    def on_actionAbout_triggered(self):
        """
        Slot documentation goes here.
        """
        QtGui.QMessageBox.information(self, "About Task Poach", "Task Poach version 0.0.12 \n Task Poach aims to be compatible with TaskCoach XML files. Intended to allow simple updates to your existing .tsk files while preserving important data it cannot edit.", QtGui.QMessageBox.Ok)
        
        #QtGui.QMessageBox('About TaskPoach',"TaskPoach aims to be a (very) simplified program compatible with TaskCoach files.")
    
    def helpWindow(self):
        win = HelpWindow(self)
        if self.maemo5():
            win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
            #win.setAttribute(QtCore.Qt.WA_Maemo5PortraitOrientation, True)
            #except:print("Cannot set orientation to portrait")
        win.show()
    
    @pyqtSignature("")
    def on_actionSave_triggered(self):
        """
        Slot documentation goes here.
        """
        self.saveFile()
    
    @pyqtSignature("")
    def on_actionNew_triggered(self):
        """
        Slot documentation goes here.
        """
        if UNSAVEDCHANGES:
            reply = QtGui.QMessageBox.question(self, 'Message',
                                               "Save task file before creating a new file?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No |QtGui.QMessageBox.Cancel, QtGui.QMessageBox.Yes)

            if reply == QtGui.QMessageBox.Yes:
                self.saveFile()
                self.newFile()
            if reply == QtGui.QMessageBox.No:
                self.newFile()
            #Otherwise cancel opening file
        else:
            self.newFile()

    def newFile(self):
        homePath = QtCore.QDir.homePath()
        #dialog = QtGui.QFileDialog
        #path = QString("/home/user")
        #dialog.setDirectory(dialog, path)
        #dlg.show()
        
        pickedFileName = False
        cancelCreation = False
        while not pickedFileName:
            self.filename = QtGui.QFileDialog.getSaveFileName(self, 'Create File', homePath, "Task Coach File (*.tsk)")
            if self.filename == "":
                #user pressed cancel, get out of this loop
                cancelCreation = True
                break
            if not (self.filename[-4:] == ".tsk"):
                self.filename = self.filename + ".tsk"
                if (not path.exists(self.filename)):
                    pickedFileName = True
                else:
                    QtGui.QMessageBox.information(self, "Alert", "A file with that name already exists, please chose a different name or path.", QtGui.QMessageBox.Ok)
            else:
                pickedFileName = True
                
                
        #Only create the file if a name was chosen, otherwise user tried to cancel
        if pickedFileName == True:
            self.model.generateNew(self.filename)
            self.model.loadModel(self.filename)

    @pyqtSlot(QStandardItem)
    def on_itemChanged(self,  item):
        if not self.model.updatingModel():
            state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][item.checkState()]
            task = item.data().toPyObject()
            self.changeItem(item, task, state)
            self.modelFilter.filterTasks()
                #if item is due today change to orange
                #otherwise change to black
            
            #print "Item with text '%s', is at state %s\n" % ( item.text(),  state)
            #print completedDate
    
    @pyqtSignature("")
    def on_actionOpen_triggered(self):
        """
        Slot documentation goes here.
        """
        if UNSAVEDCHANGES:
            reply = QtGui.QMessageBox.question(self, 'Message',
                                               "Save task file before opening another file?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No |QtGui.QMessageBox.Cancel, QtGui.QMessageBox.Yes)

            if reply == QtGui.QMessageBox.Yes:
                self.saveFile()
                self.openFile()
            if reply == QtGui.QMessageBox.No:
                self.openFile()
            #Otherwise cancel opening file
        else:
            self.openFile()
    
    def openFile(self):
        homePath = QtCore.QDir.homePath()
        #dialog = QtGui.QFileDialog
        #path = QString("/home/user")
        #dialog.setDirectory(dialog, path)
        #dlg.show()
        self.filename = QtGui.QFileDialog.getOpenFileName(ui, 'Open File', homePath, "*.tsk")
        #print ui.filename
        if self.filename != "":
            #print ui.filename
            self.model.loadModel(self.filename)
            
    def changeRowColor(self, item, color, icon):
        #change the first column color
        #item.setForeground(QBrush(QColor(color)))
        #print item
        #print item.data().toPyObject().attrib["subject"]
        #change the rest of the column colors
        
        if item.parent() == None:
            subjectIndex = self.model.taskModel.index(item.row(), 0)
        else:
            subjectIndex = self.model.taskModel.index(item.row(), 0, self.model.taskModel.indexFromItem(item.parent()))
        subjectItem = self.model.taskModel.itemFromIndex(subjectIndex)
        subjectItem.setIcon(icon)
        
        for i in range(0, 4):
            if item.parent() == None:
                #print "No parent, this is a top level item"
                next = self.model.taskModel.index(item.row(), i)
                #print next
            else:
                #print "there is a parent, sub item"
                next = self.model.taskModel.index(item.row(), i, self.model.taskModel.indexFromItem(item.parent()))
            
            nextItem = self.model.taskModel.itemFromIndex(next)
            #print nextItem
            if not nextItem == None:
                nextItem.setForeground(QBrush(color))
    
    def changeItem(self, item, task, state):
        #Will get called multiple times if we don't specify we are updating it
        self.model.setUpdatingModel(True)
        
        if state == "CHECKED":
            #Check for recurrence, it changes how dates are handled below
            recur = False
            count = 0
            for recurElement in task:
                if recurElement.tag == "recurrence":
                    recur = True
            if recur:
                #Need to get duedateDate & duedateTime                
                try:
                    task.attrib["duedate"]
                except KeyError:
                    #No duedate, set duedate to none
                    duedateDate = "None"
                    duedateTime = "None"
                else:
                    duedateTimeString = task.attrib["duedate"].split(' ')
                    duedateDate = duedateTimeString[0]
                    duedateTime = duedateTimeString[1]
                    #python way works to parse, but need Qt objects for widgets
                    #self.__duedate =  time.strptime(self.__task.attrib["duedate"],"%Y-%m-%d %H:%M:%S")
                
                    #duedate = QDate.fromString(dueDateString, "yyyy-MM-dd")
                    #print date.toString("dd/MM/yyyy")
                    
                    #Need to get startdateDate & startdateTime
                    try:
                        task.attrib["startdate"]
                    except KeyError:
                        #No startdate, set startdate checkbox to unchecked
                        startdateDate = "None"
                        startdateTime = "None"
                    else:
                        startDateTimeString = task.attrib["startdate"].split(' ')
                        startdateDate = startDateTimeString[0]
                        startdateTime = startDateTimeString[1]
                        #python way works to parse, but need Qt objects for widgets
                        #self.__startdate =  time.strptime(self.__task.attrib["startdate"],"%Y-%m-%d %H:%M:%S")                
                
                




                try:
                    recurElement.attrib["count"]
                except KeyError:
                    #no count
                    count = 0
                    recurElement.set("count","1")
                else:
                    count = int(recurElement.attrib["count"])
                    recurElement.set("count",str(int(count) + 1))
                    count = int(recurElement.attrib["count"])
                #print str(count)
                try:
                    recurElement.attrib["max"]
                except KeyError:
                    maxCount = 0
                    #no max
                else:
                    maxCount = int(recurElement.attrib["max"])
                #print str(maxCount)
                try:
                    task.attrib["sameWeekday"]
                except KeyError:
                    sameWeekday = False
                else:
                    sameWeekday = True
                    
                #Recurrance
                #This recurring task is not done yet
                if count < maxCount:
                    #print "Count: " + str(count) + " is less than Max: " + str(maxCount)
                    #change start date and duedate to next recurance time
                    #self.__task.set("startdate", str(startdateDate + " " + startdateTime))
                    #self.__task.set("duedate", str(duedateDate + " " + duedateTime))
                
                    #clear progress
                    try:
                        task.attrib["progress"]
                    except KeyError:
                        #Attribute isn't here, cannot delete
                        pass
                    else:
                        del task.attrib["progress"]
                #if count == max remove recurrance subelement and just make due 1 more time at next reoccurance time (start date and due date), clear progress
                if count == maxCount:
                    #print "Count: " + str(count) + " is equal to Max: " + str(maxCount)
                    #clear progress
                    try:
                        task.attrib["progress"]
                    except KeyError:
                        #Attribute isn't here, cannot delete
                        pass
                    else:
                        del task.attrib["progress"]
            
            
                if (count >= maxCount) and (maxCount <= 0):
                    #print "Count: " + str(count) + " is >= Max: " + str(maxCount) + " and max is >= 0"
                    try:
                        task.attrib["completiondate"]
                    except KeyError:
                        #Attribute isn't here, cannot delete
                        pass
                    else:
                        del task.attrib["completiondate"]
                    #clear progress
                    try:
                        task.attrib["progress"]
                    except KeyError:
                        #Attribute isn't here, cannot delete
                        pass
                    else:
                        del task.attrib["progress"]
                    
                if (count >= maxCount) and (maxCount > 0):
                    #print "Count: " + str(count) + " is >= Max: " + str(maxCount) + " and max is > 0"
                    #print "remove recurrence, it is finished"
                    task.remove(recurElement)
            
                #print "Calculate next occurance"
                #get recurrence period
                try:
                    recurElement.attrib["unit"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    recurPeriod = recurElement.attrib["unit"]
                
                try:
                    recurElement.attrib["amount"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    recurAmount = 1
                else:
                    recurAmount = int(recurElement.attrib["amount"])
                    
                #get recurrance unit (days,weeks,months,years)
                if recurPeriod == "daily":
                    if not startdateDate == "None":
                        recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(days=+recurAmount)
                    else:
                        recurStart = "None"
                    if not duedateDate == "None":
                        recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(days=+recurAmount)
                    else:
                        recurDue = "None"
                elif recurPeriod == "weekly":
                    if not startdateDate == "None":
                        recurStart = parser.parse(startdateDate) + relativedelta.relativedelta(weeks=+recurAmount)
                    else:
                        recurStart = "None"
                    if not duedateDate == "None":
                        recurDue = parser.parse(str(startdateDate)) + relativedelta.relativedelta(weeks=+recurAmount)
                    else:
                        recurDue = "None"
                elif recurPeriod == "monthly":
                    if sameWeekday:
                        #print "Same weekday"
                        #print date.weekday(parser.parse(str(startdateDate)))
                        wkday = date.weekday(parser.parse(str(startdateDate)))
                        if not startdateDate == "None":
                            recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(months=+recurAmount, weekday=wkday)
                        else:
                            recurStart = "None"
                        if not duedateDate == "None":
                            recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(months=+recurAmount, weekday=wkday)
                        else:
                            recurDue = "None"
                    else:
                        if not startdateDate == "None":
                            recurStart = parser.parse(startdateDate) + relativedelta.relativedelta(months=+recurAmount)
                        else:
                            recurStart = "None"
                        if not duedateDate == "None":
                            recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(months=+recurAmount)
                        else:
                            recurDue = "None"
                else: #Yearly
                    if sameWeekday:
                        #print "Same weekday"
                        wkday = date.weekday(parser.parse(startdateDate))
                        if not startdateDate == "None":
                            recurStart = parser.parse(startdateDate) + relativedelta.relativedelta(years=+recurAmount, weekday=wkday)
                        else:
                            recurStart = "None"
                        if not duedateDate == "None":
                            recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(years=+recurAmount, weekday=wkday)
                        else:
                            recurDue = "None"
                    else:
                        if not startdateDate == "None":
                            #print str(startdateDate)
                            #print str(relativedelta.relativedelta(years=+recurAmount))
                            recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(years=+recurPAmount)
                        else:
                            recurStart = "None"
                        if not duedateDate == "None":
                            recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(years=+recurAmount)
                        else:
                            recurDue = "None"
                #print str(recurStart) + " " + startdateTime
                if not recurStart == "None":
                    task.set("startdate", str(recurStart) + " " + startdateTime)
                #print str(recurStart) + " " + duedateTime
                if not recurDue == "None":
                    task.set("duedate", str(recurDue) + " " + duedateTime)
            
                #if item is overdue change to red
                try:
                   task.attrib["duedate"]
                except KeyError:
                    #print "no duedate"
                    icon = ICONACTIVE
                    if self.maemo5():
                        color = COLORACTIVEMAEMO
                    else:
                        color = COLORACTIVE
                else:
                    duedateTimeString = task.attrib["duedate"].split(' ')
                    dueDateString = duedateTimeString[0]
                    duedateObject = QDate.fromString(dueDateString, "yyyy-MM-dd")
                
                    if duedateObject == QDate.currentDate():
                        #due today
                        icon = ICONDUESOON
                        color = COLORDUESOON
                    elif duedateObject < QDate.currentDate():
                        #past due
                        icon = ICONOVERDUE
                        color = COLOROVERDUE
                    else:
                        #future due date
                        icon = ICONACTIVE
                        if self.maemo5():
                            color = COLORACTIVEMAEMO
                        else:
                            color = COLORACTIVE
                
                self.changeRowColor(item, color, icon)
                
                try:
                   task.attrib["duedate"]
                except KeyError:
                    #print "no duedate"
                    newDueDate = "None"
                else:
                    newDueDateTimeString = task.attrib["duedate"].split(' ')
                    newDueDate = newDueDateTimeString[0]
                
                try:
                   task.attrib["startdate"]
                except KeyError:
                    #print "no startdate"
                    newStartDate = "None"
                else:
                    newStartDateTimeString = task.attrib["startdate"].split(' ')
                    newStartDate = newStartDateTimeString[0]
                    
                itemRow = item.row()
                if not newStartDate == "None":
                    startDateIndex = self.model.taskModel.index(itemRow,1)
                    self.model.taskModel.itemFromIndex(startDateIndex).setText(newStartDate)
                if not newDueDate == "None":
                    dueDateIndex = self.model.taskModel.index(itemRow,2)
                    self.model.taskModel.itemFromIndex(dueDateIndex).setText(newDueDate)
                
                item.setData(QVariant(Qt.Unchecked), Qt.CheckStateRole)
                
                #Resort tasks after modifying something and scroll to selected task
                self.sortModel()
                self.scrollToSelection()

            
            #No recurrence, treat as normal just marking complete
            else:
                try:
                    task.attrib["completiondate"]
                except KeyError:
                    #Attribute isn't here, need to update completed date
                    completedDate = QDateTime.toString(QDateTime.currentDateTime(),"yyyy-MM-dd hh:mm:ss")
                    task.set("completiondate", str(completedDate))
                else:
                    pass
                self.changeRowColor(item, COLORCOMPLETED, ICONCOMPLETED)
            
                #print self.model.taskModel.indexFromItem(item).row()
                #print self.model.taskModel.indexFromItem(item).column()
                #print self.model.taskModel.indexFromItem(item).parent()
                #print item.row()
            
            
        elif state == "UNCHECKED":
            #print "need to undo completion"
            #delete start date if there was one, now we don't want it
            try:
                task.attrib["completiondate"]
            except KeyError:
                #Attribute isn't here, cannot delete
                pass
            else:
                del task.attrib["completiondate"]
                
            #if item is overdue change to red
            try:
               task.attrib["duedate"]
            except KeyError:
                #print "no duedate"
                icon = ICONACTIVE
                if self.maemo5():
                    color = COLORACTIVEMAEMO
                else:
                    color = COLORACTIVE
            else:
                duedateTimeString = task.attrib["duedate"].split(' ')
                dueDateString = duedateTimeString[0]
                duedateObject = QDate.fromString(dueDateString, "yyyy-MM-dd")
                
                if duedateObject == QDate.currentDate():
                    #due today
                    icon = ICONDUESOON
                    color = COLORDUESOON
                elif duedateObject < QDate.currentDate():
                    #past due
                    icon = ICONOVERDUE
                    color = COLOROVERDUE
                else:
                    #future due date
                    icon = ICONACTIVE
                    if self.maemo5():
                        color = COLORACTIVEMAEMO
                    else:
                        color = COLORACTIVE
            
            self.changeRowColor(item, color, icon)
            
            #Resort tasks after modifying something and scroll to selected task
            self.sortModel()
            self.scrollToSelection()
        self.updateTaskView()
        self.model.setUpdatingModel(False)
        self.autoSave()
    
    def autoSave(self):
        global AUTOSAVE, UNSAVEDCHANGES
        if AUTOSAVE:
            self.saveFile()
            #print "Should save it now"
        else:
            UNSAVEDCHANGES = True
    
    def saveFile(self):
        self.model.tskFileObject.write()
            
    def update(self):
        self.model.setUpdatingModel(True)
        self.model.tskFileObject.etModelToQSIModels(self.model.etree)
        self.updateTaskView()
        #call the method to hide completed tasks, it will only do that if the global setting says to
        #self.hideCompleteTasks()
        self.model.setUpdatingModel(False)
    
    def scrollToSelection(self):
        if self.taskTreeView.selectedIndexes() != []:
            item = self.taskTreeView.selectedIndexes()[0]
            self.taskTreeView.scrollToTop()
            self.taskTreeView.scrollTo(item, QAbstractItemView.PositionAtCenter)

    def sortModel(self):
        #Re-sort tasks after modifying something and scroll to selected task
        self.taskTreeView.sortByColumn(SORTCOL,SORTORDER)
        self.scrollToSelection()

    def updateTaskView(self):
        #self.btnEdit.setEnabled(0)
        #self.btnSubtask.setEnabled(0)
        #self.btnDelete.setEnabled(0)
        self.sortModel()
        
        #self.model.proxy.applyFilter()
        
        self.model.taskModel.setHeaderData(0, Qt.Horizontal, QVariant("Subject"))
        self.model.taskModel.setHeaderData(1, Qt.Horizontal, QVariant("Start Date"))
        self.model.taskModel.setHeaderData(2, Qt.Horizontal, QVariant("Due Date"))
        self.model.taskModel.setHeaderData(3, Qt.Horizontal, QVariant("Priority"))
        self.model.taskModel.setHeaderData(4, Qt.Horizontal, QVariant("ID"))
        
        #self.taskTreeView.setColumnWidth(0,WIDTHCOL0)
        #self.taskTreeView.setColumnWidth(1,WIDTHCOL1)
        #self.taskTreeView.setColumnWidth(2,WIDTHCOL2)
        #screenGeometry = QApplication.desktop().screenGeometry()
#        if (screenGeometry.height() > screenGeometry.width()):
#            #print "Do portrait layout"
#            self.taskTreeView.resize(480, 770)
#            self.centralwidget.resize(480, 770)
#        else:
#            #print "Do landscape layout" 
#            self.taskTreeView.resize(800, 430)
#            self.centralwidget.resize(800, 430)
        #screenGeometry = QApplication.desktop().screenGeometry()
        #print self.width()
        
        self.setColumnWidth()
        
        #moved below line here so col stays hidden after operations
        #Comment the below line to show ID column
        self.taskTreeView.hideColumn(4)
        
    def setColumnWidth(self):
        if self.maemo5():
            screenGeometry = QApplication.desktop().screenGeometry()
            width = screenGeometry.width()
        else:
            width = self.width()
        self.taskTreeView.setColumnWidth(0,(width*.5))
        self.taskTreeView.setColumnWidth(1,(width*.16))
        self.taskTreeView.setColumnWidth(2,(width*.16))
        self.taskTreeView.setColumnWidth(3,(width*.04))

    def loadPToolBars(self):
        global AUTOSAVE
        
        #Spacer to move the app wide buttons all the way to the right
        self.spacer = QWidget()
        self.spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        
        self.spacerTopLeft = QWidget()
        self.spacerTopLeft.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.spacerTopRight = QWidget()
        self.spacerTopRight.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)        
        self.spacerBottomLeft = QWidget()
        self.spacerBottomLeft.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.spacerBottomRight = QWidget()
        self.spacerBottomRight.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)        

        
        self.toolBar.addWidget(self.spacerTopLeft)
        self.toolBar.addAction(self.newTask)
        #self.toolBar.addWidget(spacer)
        self.toolBar.addAction(self.newSubTask)
        #self.toolBar.addWidget(spacer)
        self.toolBar.addAction(self.editTask)
        #self.toolBar.addWidget(spacer)
        self.toolBar.addAction(self.delTask)
        #self.toolBar.addWidget(spacer)
        self.toolBar.addAction(self.hideBtn)
        #self.toolBar.addWidget(spacer)
        self.toolBar.addWidget(self.spacerTopRight)

        self.toolBar2.addWidget(self.spacerBottomLeft)
        self.toolBar2.addAction(self.categories)
#        self.toolBar2.addWidget(self.spacer)
        self.toolBar2.addAction(self.expandAll)
#        self.toolBar2.addWidget(self.spacer)
        self.toolBar2.addAction(self.collapseAll)
        if not AUTOSAVE:
#            self.toolBar2.addWidget(self.spacer)
            self.toolBar2.addAction(self.save)
#        self.toolBar2.addWidget(self.spacer)
        self.toolBar2.addAction(self.exit)
        self.toolBar2.addWidget(self.spacerBottomRight)

    def loadLToolBar(self):
        global AUTOSAVE

        #Spacer to move the app wide buttons all the way to the right
        spacer = QWidget()
        spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)

        self.toolBar.addWidget(spacer)        
        self.toolBar.addAction(self.newTask)
        self.toolBar.addAction(self.newSubTask)
        self.toolBar.addAction(self.editTask)
        self.toolBar.addAction(self.delTask)
        self.toolBar.addWidget(spacer)
        self.toolBar.addAction(self.hideBtn)
        self.toolBar.addAction(self.categories)
        self.toolBar.addAction(self.expandAll)
        self.toolBar.addAction(self.collapseAll)
        self.toolBar.addWidget(spacer)
        if not AUTOSAVE:
            self.toolBar.addAction(self.save)
        self.toolBar.addAction(self.exit)
        self.toolBar.addWidget(spacer)

    @pyqtSignature("")
    def on_desktop_resized(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        #print screenGeometry
        
        if (screenGeometry.height() > screenGeometry.width()):
            #print "Do portrait layout"
            
            self.removeToolBar(self.toolBar)
            
            self.toolBar2 = QtGui.QToolBar(self)
            self.toolBar2.setAllowedAreas(QtCore.Qt.BottomToolBarArea)
            self.toolBar2.setFloatable(False)
            self.toolBar2.setObjectName("toolBar2")
            self.addToolBar(QtCore.Qt.BottomToolBarArea, self.toolBar2)

            self.addToolBarBreak(QtCore.Qt.BottomToolBarArea)

            self.toolBar = QtGui.QToolBar(self)
            self.toolBar.setAllowedAreas(QtCore.Qt.BottomToolBarArea)
            self.toolBar.setFloatable(False)
            self.toolBar.setObjectName("toolBar")
            self.addToolBar(QtCore.Qt.BottomToolBarArea, self.toolBar)
            
            self.loadPToolBars()
            
            #self.taskTreeView.resize(480, 770)
            #self.centralwidget.resize(480, 770)
            self.setColumnWidth()
        else:
            #print "Do landscape layout" 
            
            #self.taskTreeView.resize(800, 430)
            #self.centralwidget.resize(800, 430)
            
            self.removeToolBar(self.toolBar)
            self.removeToolBar(self.toolBar2)

            self.toolBar = QtGui.QToolBar(self)
            self.toolBar.setAllowedAreas(QtCore.Qt.BottomToolBarArea)
            self.toolBar.setFloatable(False)
            self.toolBar.setObjectName("toolBar")
            self.addToolBar(QtCore.Qt.BottomToolBarArea, self.toolBar)
            
            self.loadLToolBar()
            self.setColumnWidth()
    
#For windows focus, turns out did not need to use to adjust scrollto after child windows return control to parent
#def changedFocusSlot(old, now):
#    if (now==None and QApplication.activeWindow()!=None):
        #print "set focus to the active window"
#        QApplication.activeWindow().setFocus()

if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    issue = open('/etc/issue').read().strip().lower()
    #print QApplication.desktop()
    if issue.startswith('maemo 5'):
        maemo5 = True
        #print "maemo5 = True"
    else:
        maemo5 = False
        #print "maemo5 = False"
    
    ui = MainWindow(maemo5)
    if maemo5:
        ui.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
        ui.setAttribute(Qt.WA_Maemo5AutoOrientation, True)    
    #ui.filename = QtGui.QFileDialog.getOpenFileName(ui, 'Open File', '.')
    #ui.connect(QApplication.desktop(), QtCore.SIGNAL('QApplication.desktop.resized()'), ui.on_desktop_resized)
    QApplication.desktop().resized.connect(ui.on_desktop_resized)
    ui.show()
    
    
    #how to show full screen:
    #ui.showFullScreen()
    
    
    #ui.loadThemUp()
    
    #myobj = MyClass()
    #QObject.connect(ui.taskTreeView.selectionModel(), SIGNAL("selectionChanged(QItemSelection, QItemSelection)"), myobj.slot)
    #ui.taskModel.itemChanged.connect(ui.on_itemChanged)
    
    #For windows focus, turns out did not need to use to adjust scrollto after child windows return control to parent
    #QObject.connect(ui, SIGNAL("focusChanged(QWidget *, QWidget *)"), changedFocusSlot)
         
    sys.exit(app.exec_())
