'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from ConfigParser import SafeConfigParser
import ConfigParser
import os
from PyQt4.QtGui import QColor, QIcon
global SETTINGSFILE

dir = os.path.expanduser("~/.taskpoach/")
settingfile = "taskpoach.ini"
if not os.path.exists(dir):
    os.makedirs(dir)
SETTINGSFILE = dir + settingfile
#print SETTINGSFILE

class MyConfigParser(object):
    """
    Class documentation goes here.
    """
    def __init__(self, parent):
        self.parent = parent
        #print self.parent.maemo5()
        
        #color
        self.overduetasks = '255, 0, 0'
        self.duesoontasks = '255, 153, 0'
        self.completedtasks = '0, 255, 0'
        self.activetasks = '0, 0, 0'
        self.activetasksmaemo = '255, 255, 255'
        
        #taskview
        self.hidecompleted = 'False'
        
        #file
        self.autosave = 'False'
        self.lastfile = ''
        self.loadlastfile = 'False'
        self.promptOnDeletion = 'True'
        
        #icons
        if self.parent.maemo5():
            self.iconcompleted = '/opt/usr/share/icons/hicolor/32x32/actions/ledgreen.png'
        else:
            self.iconcompleted = 'icons/nuvola/32x32/actions/ledgreen.png'
        if self.parent.maemo5():
            self.iconoverdue = '/opt/usr/share/icons/hicolor/32x32/actions/ledred.png'
        else:
            self.iconoverdue = 'icons/nuvola/32x32/actions/ledred.png'
        if self.parent.maemo5():
            self.iconduesoon = '/opt/usr/share/icons/hicolor/32x32/actions/ledorange.png'
        else:
            self.iconduesoon = 'icons/nuvola/32x32/actions/ledorange.png'
        if self.parent.maemo5():
            self.iconactive = '/opt/usr/share/icons/hicolor/32x32/actions/ledblue.png'
        else:
            self.iconactive = 'icons/nuvola/32x32/actions/ledblue.png'
        
        # Initialize the setting with some defaults
        self.setting = ConfigParser.SafeConfigParser(defaults={'overduetasks':self.overduetasks,
                       'duesoontasks':self.duesoontasks, 'completedtasks':self.completedtasks,
                       'activetasks':self.activetasks, 'activetasksmaemo':self.activetasksmaemo, 
                       'hidecompleted':self.hidecompleted, 'autosave':self.autosave,
                       'lastfile':self.lastfile, 'loadlastfile':self.loadlastfile,
                       'promptOnDeletion':self.promptOnDeletion,  
                       'iconcompleted':self.iconcompleted, 'iconoverdue':self.iconoverdue, 
                       'iconduesoon':self.iconduesoon, 'iconactive':self.iconactive})
        
        # Load the configuration file
        self.setting.read(SETTINGSFILE)
        
        #File section of settings
        if not self.setting.has_section("file"):
            self.setting.add_section("file")
            self.setting.set("file", "autosave", self.autosave)
            self.setting.set("file", "lastfile", self.lastfile)
            self.setting.set("file", "loadlastfile", self.loadlastfile)
            self.setting.set("file", "promptOnDeletion", self.promptOnDeletion)
            
        #Color section of settings
        if not self.setting.has_section("color"):
            #print "need to add color section and put values from defaults in it"
            self.setting.add_section("color")
            self.setting.set("color", "overduetasks", self.overduetasks)
            self.setting.set("color", "duesoontasks", self.duesoontasks)
            self.setting.set("color", "completedtasks", self.completedtasks)
            self.setting.set("color", "activetasks", self.activetasks)
            self.setting.set("color", "activetasksmaemo", self.activetasksmaemo)
        
        #Icons section of settings
        if not self.setting.has_section("icons"):
            self.setting.add_section("icons")
            self.setting.set("icons", "iconcompleted", self.iconcompleted)
            self.setting.set("icons", "iconoverdue", self.iconoverdue)
            self.setting.set("icons", "iconduesoon", self.iconduesoon)
            self.setting.set("icons", "iconactive", self.iconactive)
            
        #taskview
        if not self.setting.has_section("taskview"):
            self.setting.add_section("taskview")
            self.setting.set("taskview", "hidecompleted", self.hidecompleted)
        #Check a value
        #try:
        #    self.setting.getboolean("file", "autosave")
        #except ValueError:
        #    print "Value is not a boolean"
        #else:
        #    if self.setting.getboolean("file", "autosave"):
        #        print "Auto save is on"
        #    else:
        #        print "Auto save is off"
        
        #try:
            #self.setting.get("color", "completedtasks")
        #except ValueError:
            #print "Section: color, Option: completedtasks, Value is not valid"
            #pass
        #else:
            #print self.setting.get("color", "completedtasks")
            #pass
        
        #COLORCOMPLETED =  self.setting.get("color", "completedtasks")
        #print COLORCOMPLETED
        self.save()
        
    def save(self):
        self.setting.write(open(SETTINGSFILE, 'w'))

    def get(self, section, option):
        return self.setting.get(section, option)
    
    def geticon(self, section, option):
        return QIcon(self.setting.get(section, option))
        
    def getcolor(self, section, option):
        colorString = self.setting.get(section, option)
        colorList = colorString.split(", ")
        color = QColor(int(colorList[0]), int(colorList[1]), int(colorList[2]))
        return color
    
    def getboolean(self, section, option):
        return self.setting.getboolean(section, option)
    
    def getint(self, section, option):
        return self.setting.getint(section, option)
    
    def getfloat(self, section, option):
        return self.setting.getfloat(section, option)
        
    def set(self, section, option, value):
        return self.setting.set(section, option, value)
    
if __name__ == "__main__":
    import sys
    MyConfigParser()
