#include <QVBoxLayout>
#include <QWidget>
#include <QSlider>
#include <QLabel>
#include <QVariant>
#include "symfonieqslider.h"

SymfonieQSlider::SymfonieQSlider(int groupIndex, QWidget *parent) :
    QWidget(parent),
    slider(new QSlider(Qt::Vertical, parent)),
    valueLabel(new QLabel()),
    nameLabel(new QLabel()),
    vLayout(new QVBoxLayout()),
    groupIndex(groupIndex)
{

   valueLabel->setText(QVariant(this->slider->value()).toString());
   valueLabel->setAlignment(Qt::AlignCenter);
   valueLabel->setMaximumWidth(80);

   QFont font;
   font.setPointSize(12);
   nameLabel->setFont(font);
   nameLabel->setText("");
   nameLabel->setAlignment(Qt::AlignCenter);
   nameLabel->setMaximumWidth(80);
   nameLabel->setAutoFillBackground(true);




   this->setLayout(vLayout);
   this->vLayout->addWidget(nameLabel);
   this->vLayout->addWidget(this->slider);
   this->vLayout->addWidget(this->valueLabel);

   connect(this->getSlider(), SIGNAL(valueChanged(int)), this, SLOT(valueChangedSlot(int)));


   //s->setValue(this->getBandValue(i));

}


SymfonieQSlider::~SymfonieQSlider(){
    delete this->valueLabel;
    delete this->vLayout;
    delete this->slider;
}

int SymfonieQSlider::getGroupIndex(){
    return this->groupIndex;
}

void SymfonieQSlider::valueChangedSlot ( int value ){
  this->setText(QVariant(value).toString());
  emit this->valueChangedSignal(this->groupIndex, value);
}


void SymfonieQSlider::setName(QString text){
    this->nameLabel->setText(text);
}

void SymfonieQSlider::setText(QString text){
    this->valueLabel->setText(text);
}

int SymfonieQSlider::getValue(){
    return this->slider->value();
}

void SymfonieQSlider::setValue(int value){
    this->slider->setValue(value);
}

QSlider* SymfonieQSlider::getSlider(){
    return this->slider;
}
