#include "symfoniedb.h"

SymfonieDb* SymfonieDb::instance = NULL;


SymfonieDb::SymfonieDb(QObject *parent) :
    QObject(parent)
{
    this->db = QSqlDatabase::addDatabase("QSQLITE");

    QString path(QDir::home().path() +
                 QDir::separator() + "MyDocs" +
                 QDir::separator() + ".symfonie-library.sqlite.db");
    path = QDir::toNativeSeparators(path);
    db.setDatabaseName(path);
    qDebug() << "db in " << path;
    if(!db.open()){
        QSqlError error = db.lastError ();
        qWarning() << error.text();
    }

    this->init();


}

SymfonieDb::~SymfonieDb(){
    this->db.close();
    this->db.removeDatabase(db.connectionNames()[0]);
    QSqlDatabase::removeDatabase("QSQLITE");

    if(this->instance != NULL){
        delete this->instance;
    }
}



void SymfonieDb::createInstance(QObject *parent){
   if(instance == 0){
    instance = new SymfonieDb(parent);
   }
}

SymfonieDb* SymfonieDb::getInstance(){
    if(instance == 0){
        SymfonieDb::createInstance();
    }

    return instance;
}

void SymfonieDb::init(){

  QString table1 =
          "CREATE TABLE IF NOT EXISTS song ("
          "id INTEGER PRIMARY KEY, "
          "artist_name TEXT, "
          "album_name TEXT, "
          "title TEXT, "
          "length INTEGER, "
          "file_size TEXT, "
          "file_path TEXT, "
          "is_info_fetched INTEGER "
          ");";
  QString table2 =
          "CREATE TABLE IF NOT EXISTS setting ("
          "name TEXT, "
          "value TEXT "
          ");";

  //query.exec(sql);
  //qDebug() << "---:" << query.lastError().driverText();
  this->executeSql(table1);
  this->executeSql(table2);
}


void SymfonieDb::saveSetting(QString name, QVariant value){
    bool isExist = this->isSettingExists(name);
    QSqlQuery query;
    if(isExist != true){
        qDebug() << "Saving setting: " << name << " = " << value.toString();
         query.prepare("INSERT INTO setting VALUES (:name, :value)");
     }else{
         qDebug() << "Update setting " << name << " = " <<value.toString();
         query.prepare("UPDATE setting SET value=:value WHERE name=:name");
     }
         query.bindValue(":name", name);
         query.bindValue(":value", value);

         this->executeQuery(query);

}

bool SymfonieDb::isSettingExists(QString name){
    QSqlQuery query;
         query.prepare("SELECT  * FROM setting s "
                       "WHERE s.name = :name "
                       "LIMIT 1;"
                       );
         query.bindValue(":name", name);

         if(this->executeQuery(query) && query.first() == true){
             return true;
         }else{
             return false;
         }
}

QVariant SymfonieDb::getSetting(QString name, QVariant defaultValue){
    QSqlQuery query;
         query.prepare("SELECT  value FROM setting s "
                       "WHERE s.name = :name "
                       "LIMIT 1;"
                       );
         query.bindValue(":name", name);

        // qDebug() << query.lastQuery() << name;
         if(this->executeQuery(query) && query.first() == true){
            // qDebug() << "Test: " << query.value(0);
             return query.value(0);
         }else{
             return defaultValue;
         }

}

bool SymfonieDb::executeSql(QString &sql){
  QSqlQuery query;
  return this->executeSql(sql, query);
}

bool SymfonieDb::executeSql(QString &sql, QSqlQuery &query){
    bool r = query.exec(sql);
    this->handlePostQueryExecute(query, r);
    return r;
}

void SymfonieDb::handlePostQueryExecute(QSqlQuery &query, bool result){
/*
    qDebug() << "SQL Error: " << query.lastError().text() << " query: " << query.lastQuery()
            << query.boundValues();
*/
    if(result != true){
        qDebug() << "SQL Error: " << query.lastError().text() << " query: " << query.lastQuery()
                << query.boundValues();
        emit queryErrorSignal(query);
    }
}

bool SymfonieDb::executeQuery(QSqlQuery &query){
    bool r;
    r = query.exec();
    this->handlePostQueryExecute(query, r);
    return r;
}
