import sqlite3
import os

def create_initial_portfolio(sqlite_db):
    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('CREATE TABLE Portfolio (symbol text, name text, '
                        'shares text, price text)')
    sqlite_db.commit()
    cursor_sql.close()

def load_portfolio(sqlite_db):
    portfolio = []
    for table in sqlite_db.execute('select * from Portfolio'):
        portfolio.append([table[0], table[1], table[2], table[3]])

    return portfolio

def insert_new_item_to_portfolio(sqlite_db, item):
    cursor_sql = sqlite_db.cursor()
    cursor_sql.execute('INSERT INTO Portfolio VALUES (?, ?, ?, ?)',
                            (item[0], item[1], item[2], item[3]))

    sqlite_db.commit()
    cursor_sql.close()

def save_portfolio(sqlite_db, portfolio):
    cursor_sql = sqlite_db.cursor()

    for item in portfolio:
        cursor_sql.execute('INSERT INTO Portfolio VALUES (?, ?, ?, ?)',
                            (item[0], item[1], item[2], item[3]))

        sqlite_db.commit()
    cursor_sql.close()

def clear_portfolio(sqlite_db):
    cursor_sql = sqlite_db.cursor()
    sqlite_db.execute('delete from Portfolio')
    sqlite_db.commit()
    cursor_sql.close()

def delete_item_from_portfolio(sqlite_db, symbol):
    cursor_sql = sqlite_db.cursor()
    sqlite_db.execute('delete from Portfolio where symbol="%s"' % symbol)
    sqlite_db.commit()
    cursor_sql.close()

def define_paths(locally, HOME):
    configdir = HOME + '/.stockthis/'
    logfile = configdir + 'log.txt'

    if not os.path.exists(configdir):
        os.mkdir(configdir)

    if os.path.exists(configdir + 'settings'):
        settingsdb = sqlite3.connect(configdir + 'settings')
    else:
        settingsdb = sqlite3.connect(configdir + 'settings')
        create_initial_portfolio(settingsdb)

    if locally:
        imgdir = 'pixmaps/'
    else:
        imgdir = '/usr/share/stockthis/pixmaps/'

    return settingsdb, imgdir, configdir, logfile
