# @abstract Views a live camera stream sent by N900 SMSCON app.
# @version $Id: live-viewer.sh 182 2012-05-23 00:00:31Z yablacky $
# @copyright Lutz Schwarz <schwarz.ware@gmx.de>
# @license GPL V2
test "$1" = "--help" && cat << EOH && exit 1
Opens a window to view an incoming SMSCON live camera stream.
SMSCON is a Nokia N900 phone application, see http://wiki.maemo.org/SMSCON.

To watch the camera you must ensure that this linux system is reachable
by the phone via internet by IP or hostname. If this linux system is in
a LAN behind a DSL-router then you need to configure the DSL-router to
do port forwarding.

You turn the phone camera on and off by sending it appropriate COM_CAMERA
commands containing this host's (DSL-routers's) IP/hostname/port info. 

usage: $0 [--help] [port-number]
 --help              This help.
 port-number         Port on this host where to listen for incoming
                     live stream. Default port number is 5000.
EOH
test "${1#-}" != "${1}" && echo "$0: unknown option '$1'. Use --help" && exit 1 
LIVE_VIEWER_LISTEN_PORT=${1:-5000}
test "${LIVE_VIEWER_LISTEN_PORT#[0-9]}" = "${LIVE_VIEWER_LISTEN_PORT}" -o \
     "${LIVE_VIEWER_LISTEN_PORT%[0-9]}" = "${LIVE_VIEWER_LISTEN_PORT}" && \
     echo "$0: unknown parameter '$1'. Use --help" && exit 1

echo Going to listen on port $LIVE_VIEWER_LISTEN_PORT for SMSCON live camera stream.
echo Note 1: A viewer window first appears if camera stream arrives.
echo Note 2: Green sparkles are normal on startup. Just wait for complete image. 
echo ---------------------------------------------------------------------------
# Act as network server: listen for video stream on given udp port
gst-launch-0.10 \
	udpsrc port=${LIVE_VIEWER_LISTEN_PORT} !\
	application/x-rtp,payload=96 ! rtph263depay ! ffdec_h263 !\
	gamma gamma=2 ! videoscale ! video/x-raw-yuv,width=320,height=240 !\
	xvimagesink force-aspect-ratio=true
